/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.AkimaSplineInterpolator;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.VectorFunction;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class DerivativeEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;

    public DerivativeEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (value == null) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
        }
        if (!(value instanceof VectorFunction)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a FunctionVector", this.toExpression(this.constructingFactory), value.getClass().getSimpleName()));
        }
        VectorFunction vectorFunction = (VectorFunction)value;
        DifferentiableUnivariateFunction func = null;
        double[] x = (double[])vectorFunction.getFromContext("x");
        if (!(vectorFunction.getFunction() instanceof DifferentiableUnivariateFunction)) {
            double[] y = (double[])vectorFunction.getFromContext("y");
            func = new AkimaSplineInterpolator().interpolate(x, y);
        } else {
            func = (DifferentiableUnivariateFunction)vectorFunction.getFunction();
        }
        UnivariateFunction derfunc = func.derivative();
        double[] dvalues = new double[x.length];
        int i = 0;
        while (i < x.length) {
            dvalues[i] = derfunc.value(x[i]);
            ++i;
        }
        VectorFunction vf = new VectorFunction((Object)derfunc, dvalues);
        vf.addToContext("x", x);
        vf.addToContext("y", dvalues);
        return vf;
    }
}

