/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class DateEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    private SimpleDateFormat parseFormat;

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public DateEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        String sdate = values[0].toString();
        String template = values[1].toString();
        if (sdate.startsWith("\"")) {
            sdate = sdate.replace("\"", "");
        }
        if (template.startsWith("\"")) {
            template = template.replace("\"", "");
        }
        if (this.parseFormat == null) {
            String timeZone = "UTC";
            if (values.length == 3) {
                timeZone = values[2].toString();
            }
            this.parseFormat = new SimpleDateFormat(template, Locale.US);
            this.parseFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        }
        try {
            Date date = this.parseFormat.parse(sdate);
            return dateFormat.format(date);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

