/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class CopyOfRangeEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public CopyOfRangeEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object doWork(Object ... values) throws IOException {
        if (Arrays.stream(values).anyMatch(item -> item == null)) {
            return null;
        }
        if (values.length < 1) throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", this.toExpression(this.constructingFactory), this.containedEvaluators.size()));
        List<Object> sourceValues = values[0] instanceof List ? (List<Object>)values[0] : Arrays.asList(values[0]);
        Integer startIdx = 0;
        Integer endIdx = sourceValues.size() - 1;
        if (values.length >= 2) {
            if (!(values[1] instanceof Number)) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - if second parameter is provided then it must be a valid number but found %s instead", this.toExpression(this.constructingFactory), values[1].getClass().getSimpleName()));
            }
            startIdx = ((Number)values[1]).intValue();
            if (values.length >= 3) {
                if (!(values[2] instanceof Number)) throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - if third parameter is provided then it must be a valid number but found %s instead", this.toExpression(this.constructingFactory), values[2].getClass().getSimpleName()));
                endIdx = ((Number)values[2]).intValue();
            }
        }
        if (startIdx > endIdx) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - startIdx (%d) must be less than endIdx (%d)", this.toExpression(this.constructingFactory), startIdx, endIdx));
        }
        if (endIdx <= sourceValues.size()) return Arrays.stream(Arrays.copyOfRange(sourceValues.toArray(), (int)startIdx, (int)endIdx)).collect(Collectors.toList());
        throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - endIdx (%d) must not be greater then size of source array (%d)", this.toExpression(this.constructingFactory), endIdx, sourceValues.size()));
    }
}

