/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.euclidean.twod.hull.ConvexHull2D;
import org.apache.commons.math3.geometry.euclidean.twod.hull.MonotoneChain;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ConvexHullEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public ConvexHullEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... objects) throws IOException {
        if (objects[0] instanceof Matrix) {
            return ConvexHullEvaluator.getConvexHull((Matrix)objects[0]);
        }
        throw new IOException("The convexHull function operates on a matrix of 2D vectors");
    }

    public static ConvexHull2D getConvexHull(Matrix matrix) throws IOException {
        double[][] data = matrix.getData();
        ArrayList<Vector2D> points = new ArrayList<Vector2D>(data.length);
        if (data[0].length == 2) {
            double[][] dArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                double[] row = dArray[n2];
                points.add(new Vector2D(row[0], row[1]));
                ++n2;
            }
            MonotoneChain monotoneChain = new MonotoneChain();
            ConvexHull2D convexHull2D = monotoneChain.generate(points);
            return convexHull2D;
        }
        throw new IOException("The convexHull function operates on a matrix of 2D vectors");
    }
}

