/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import org.apache.commons.math3.analysis.interpolation.PiecewiseBicubicSplineInterpolatingFunction;
import org.apache.commons.math3.analysis.interpolation.PiecewiseBicubicSplineInterpolator;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class BicubicSplineEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public BicubicSplineEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... objects) throws IOException {
        if (objects.length != 3) {
            throw new IOException("The bicubicSpline function requires three paremeters," + objects.length + " found.");
        }
        Object first = objects[0];
        Object second = objects[1];
        Object third = objects[2];
        double[] x = null;
        double[] y = null;
        double[][] grid = null;
        if (first instanceof List && second instanceof List && third instanceof Matrix) {
            List xlist = (List)first;
            x = new double[xlist.size()];
            int i = 0;
            while (i < x.length) {
                x[i] = ((Number)xlist.get(i)).doubleValue();
                ++i;
            }
            List ylist = (List)second;
            y = new double[ylist.size()];
            int i2 = 0;
            while (i2 < y.length) {
                y[i2] = ((Number)ylist.get(i2)).doubleValue();
                ++i2;
            }
            Matrix matrix = (Matrix)third;
            grid = matrix.getData();
            PiecewiseBicubicSplineInterpolator interpolator = new PiecewiseBicubicSplineInterpolator();
            PiecewiseBicubicSplineInterpolatingFunction bivariateFunction = interpolator.interpolate(x, y, grid);
            return bivariateFunction;
        }
        throw new IOException("The bicubicSpline function expects two numeric arrays and a matrix as parameters.");
    }
}

