/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class AscEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    private static final long serialVersionUID = 1L;

    public AscEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (value == null) {
            return value;
        }
        if (!(value instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for value, expecting a List", this.toExpression(this.constructingFactory), value.getClass().getSimpleName()));
        }
        List list = (List)value;
        if (list.size() == 0) {
            return list;
        }
        Object checkingObject = list.get(0);
        int idx = 0;
        while (idx < list.size()) {
            Object item = list.get(0);
            if (item == null) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found null value", this.toExpression(this.constructingFactory)));
            }
            if (!(item instanceof Comparable)) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found non-comparable value %s of type %s", this.toExpression(this.constructingFactory), item.toString(), item.getClass().getSimpleName()));
            }
            if (!item.getClass().getCanonicalName().equals(checkingObject.getClass().getCanonicalName())) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - value %s is of type %s but we are expeting type %s", this.toExpression(this.constructingFactory), item.toString(), item.getClass().getSimpleName(), checkingObject.getClass().getCanonicalName()));
            }
            ++idx;
        }
        return list.stream().sorted((left, right) -> ((Comparable)left).compareTo((Comparable)right)).collect(Collectors.toList());
    }
}

