/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eq;

import java.io.IOException;
import java.util.UUID;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.MultipleFieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.StreamEqualitor;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MultipleFieldEqualitor
implements StreamEqualitor {
    private static final long serialVersionUID = 1L;
    private UUID equalitorNodeId = UUID.randomUUID();
    private StreamEqualitor[] eqs;

    public MultipleFieldEqualitor(StreamEqualitor ... eqs) {
        this.eqs = eqs;
    }

    public StreamEqualitor[] getEqs() {
        return this.eqs;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StringBuilder sb = new StringBuilder();
        StreamEqualitor[] streamEqualitorArray = this.eqs;
        int n = this.eqs.length;
        int n2 = 0;
        while (n2 < n) {
            StreamEqualitor eq = streamEqualitorArray[n2];
            if (eq instanceof Expressible) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
            } else {
                throw new IOException("This MultiEqualitor contains a non-expressible equalitor - it cannot be converted to an expression");
            }
            sb.append(((Expressible)eq).toExpression(factory));
            ++n2;
        }
        return new StreamExpressionValue(sb.toString());
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.equalitorNodeId.toString()).withExpressionType("equalitor").withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }

    @Override
    public boolean isDerivedFrom(StreamEqualitor base) {
        if (base == null) {
            return false;
        }
        if (base instanceof MultipleFieldEqualitor) {
            MultipleFieldEqualitor baseEq = (MultipleFieldEqualitor)base;
            if (baseEq.eqs.length >= this.eqs.length) {
                int idx = 0;
                while (idx < this.eqs.length) {
                    if (!this.eqs[idx].isDerivedFrom(baseEq.eqs[idx])) {
                        return false;
                    }
                    ++idx;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDerivedFrom(StreamComparator base) {
        MultipleFieldComparator baseComps;
        if (base == null) {
            return false;
        }
        if (base instanceof StreamComparator && (baseComps = (MultipleFieldComparator)base).getComps().length >= this.eqs.length) {
            int idx = 0;
            while (idx < this.eqs.length) {
                if (!this.eqs[idx].isDerivedFrom(baseComps.getComps()[idx])) {
                    return false;
                }
                ++idx;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean test(Tuple t1, Tuple t2) {
        StreamEqualitor[] streamEqualitorArray = this.eqs;
        int n = this.eqs.length;
        int n2 = 0;
        while (n2 < n) {
            StreamEqualitor eq = streamEqualitorArray[n2];
            if (!eq.test(t1, t2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

