/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.comp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MultipleFieldComparator
implements StreamComparator {
    private static final long serialVersionUID = 1L;
    private UUID comparatorNodeId = UUID.randomUUID();
    private StreamComparator[] comps;

    public MultipleFieldComparator(StreamComparator ... comps) {
        this.comps = comps;
    }

    public StreamComparator[] getComps() {
        return this.comps;
    }

    @Override
    public int compare(Tuple t1, Tuple t2) {
        StreamComparator[] streamComparatorArray = this.comps;
        int n = this.comps.length;
        int n2 = 0;
        while (n2 < n) {
            StreamComparator comp = streamComparatorArray[n2];
            int i = comp.compare(t1, t2);
            if (i != 0) {
                return i;
            }
            ++n2;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipleFieldComparator that = (MultipleFieldComparator)o;
        return Arrays.equals(this.comps, that.comps);
    }

    public int hashCode() {
        return Arrays.hashCode(this.comps);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StringBuilder sb = new StringBuilder();
        StreamComparator[] streamComparatorArray = this.comps;
        int n = this.comps.length;
        int n2 = 0;
        while (n2 < n) {
            StreamComparator comp = streamComparatorArray[n2];
            if (comp instanceof Expressible) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
            } else {
                throw new IOException("This MultiComp contains a non-expressible comparator - it cannot be converted to an expression");
            }
            sb.append(comp.toExpression(factory));
            ++n2;
        }
        return new StreamExpressionValue(sb.toString());
    }

    @Override
    public boolean isDerivedFrom(StreamComparator base) {
        if (base == null) {
            return false;
        }
        if (base instanceof MultipleFieldComparator) {
            MultipleFieldComparator baseComp = (MultipleFieldComparator)base;
            if (baseComp.comps.length >= this.comps.length) {
                int idx = 0;
                while (idx < this.comps.length) {
                    if (!this.comps[idx].isDerivedFrom(baseComp.comps[idx])) {
                        return false;
                    }
                    ++idx;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.comparatorNodeId.toString()).withExpressionType("sorter").withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }

    @Override
    public MultipleFieldComparator copyAliased(Map<String, String> aliases) {
        StreamComparator[] aliasedComps = new StreamComparator[this.comps.length];
        int idx = 0;
        while (idx < this.comps.length) {
            aliasedComps[idx] = this.comps[idx].copyAliased(aliases);
            ++idx;
        }
        return new MultipleFieldComparator(aliasedComps);
    }

    @Override
    public StreamComparator append(StreamComparator other) {
        StreamComparator comp;
        ArrayList<StreamComparator> newComps = new ArrayList<StreamComparator>();
        StreamComparator[] streamComparatorArray = this.comps;
        int n = this.comps.length;
        int n2 = 0;
        while (n2 < n) {
            comp = streamComparatorArray[n2];
            newComps.add(comp);
            ++n2;
        }
        if (other instanceof FieldComparator) {
            newComps.add(other);
        } else if (other instanceof MultipleFieldComparator) {
            streamComparatorArray = ((MultipleFieldComparator)other).comps;
            n = ((MultipleFieldComparator)other).comps.length;
            n2 = 0;
            while (n2 < n) {
                comp = streamComparatorArray[n2];
                newComps.add(comp);
                ++n2;
            }
        }
        return new MultipleFieldComparator(newComps.toArray(new StreamComparator[newComps.size()]));
    }
}

