/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.client.solrj.impl.SolrClientBuilder;
import org.apache.solr.common.params.ModifiableSolrParams;

public class LBHttpSolrClient
extends LBSolrClient {
    private final HttpClient httpClient;
    private final boolean clientIsInternal;
    private final ConcurrentHashMap<String, HttpSolrClient> urlToClient = new ConcurrentHashMap();
    private final HttpSolrClient.Builder httpSolrClientBuilder;
    private Integer connectionTimeout;
    private volatile Integer soTimeout;

    @Deprecated
    protected LBHttpSolrClient(HttpSolrClient.Builder httpSolrClientBuilder, HttpClient httpClient, String ... solrServerUrl) {
        this(((Builder)new Builder().withHttpSolrClientBuilder(httpSolrClientBuilder).withHttpClient(httpClient)).withBaseSolrUrls(solrServerUrl));
    }

    @Deprecated
    protected LBHttpSolrClient(HttpClient httpClient, ResponseParser parser, String ... solrServerUrl) {
        this((Builder)((Builder)new Builder().withBaseSolrUrls(solrServerUrl).withResponseParser(parser)).withHttpClient(httpClient));
    }

    protected LBHttpSolrClient(Builder builder) {
        super(builder.baseSolrUrls);
        this.clientIsInternal = builder.httpClient == null;
        this.httpSolrClientBuilder = builder.httpSolrClientBuilder;
        this.httpClient = builder.httpClient == null ? this.constructClient(builder.baseSolrUrls.toArray(new String[builder.baseSolrUrls.size()])) : builder.httpClient;
        this.connectionTimeout = builder.connectionTimeoutMillis;
        this.soTimeout = builder.socketTimeoutMillis;
        this.parser = builder.responseParser;
        for (String baseUrl : builder.baseSolrUrls) {
            this.urlToClient.put(baseUrl, this.makeSolrClient(baseUrl));
        }
    }

    private HttpClient constructClient(String[] solrServerUrl) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (solrServerUrl != null && solrServerUrl.length > 1) {
            params.set("retry", false);
        } else {
            params.set("retry", true);
        }
        return HttpClientUtil.createClient(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSolrClient makeSolrClient(String server) {
        HttpSolrClient client;
        if (this.httpSolrClientBuilder != null) {
            LBHttpSolrClient lBHttpSolrClient = this;
            synchronized (lBHttpSolrClient) {
                this.httpSolrClientBuilder.withBaseSolrUrl(server).withHttpClient(this.httpClient);
                if (this.connectionTimeout != null) {
                    this.httpSolrClientBuilder.withConnectionTimeout(this.connectionTimeout);
                }
                if (this.soTimeout != null) {
                    this.httpSolrClientBuilder.withSocketTimeout(this.soTimeout);
                }
                client = this.httpSolrClientBuilder.build();
            }
        } else {
            HttpSolrClient.Builder clientBuilder = (HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(server).withHttpClient(this.httpClient)).withResponseParser(this.parser);
            if (this.connectionTimeout != null) {
                clientBuilder.withConnectionTimeout(this.connectionTimeout);
            }
            if (this.soTimeout != null) {
                clientBuilder.withSocketTimeout(this.soTimeout);
            }
            client = clientBuilder.build();
        }
        if (this.requestWriter != null) {
            client.setRequestWriter(this.requestWriter);
        }
        if (this.queryParams != null) {
            client.setQueryParams(this.queryParams);
        }
        return client;
    }

    @Deprecated
    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
        this.urlToClient.values().forEach(client -> client.setConnectionTimeout(timeout));
    }

    @Deprecated
    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
        this.urlToClient.values().forEach(client -> client.setSoTimeout(timeout));
    }

    @Deprecated
    public Rsp request(Req req) throws SolrServerException, IOException {
        LBSolrClient.Rsp rsp = super.request(req);
        Rsp result = new Rsp();
        result.rsp = rsp.rsp;
        result.server = rsp.server;
        return result;
    }

    @Override
    protected SolrClient getClient(String baseUrl) {
        HttpSolrClient client = this.urlToClient.get(baseUrl);
        if (client == null) {
            return this.makeSolrClient(baseUrl);
        }
        return client;
    }

    @Override
    public String removeSolrServer(String server) {
        this.urlToClient.remove(server);
        return super.removeSolrServer(server);
    }

    @Override
    public void close() {
        super.close();
        if (this.clientIsInternal) {
            HttpClientUtil.close(this.httpClient);
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public static class Builder
    extends SolrClientBuilder<Builder> {
        protected final List<String> baseSolrUrls = new ArrayList<String>();
        protected HttpSolrClient.Builder httpSolrClientBuilder;

        public Builder() {
            this.responseParser = new BinaryResponseParser();
        }

        public HttpSolrClient.Builder getHttpSolrClientBuilder() {
            return this.httpSolrClientBuilder;
        }

        public Builder withBaseSolrUrl(String baseSolrUrl) {
            this.baseSolrUrls.add(baseSolrUrl);
            return this;
        }

        public Builder withBaseSolrUrls(String ... solrUrls) {
            String[] stringArray = solrUrls;
            int n = solrUrls.length;
            int n2 = 0;
            while (n2 < n) {
                String baseSolrUrl = stringArray[n2];
                this.baseSolrUrls.add(baseSolrUrl);
                ++n2;
            }
            return this;
        }

        public Builder withHttpSolrClientBuilder(HttpSolrClient.Builder builder) {
            this.httpSolrClientBuilder = builder;
            return this;
        }

        public LBHttpSolrClient build() {
            return new LBHttpSolrClient(this);
        }

        @Override
        public Builder getThis() {
            return this;
        }
    }

    @Deprecated
    public static class Req
    extends LBSolrClient.Req {
        public Req(SolrRequest request, List<String> servers) {
            super(request, servers);
        }

        public Req(SolrRequest request, List<String> servers, Integer numServersToTry) {
            super(request, servers, numServersToTry);
        }
    }

    @Deprecated
    public static class Rsp
    extends LBSolrClient.Rsp {
    }
}

