/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.V2RequestSupport;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.client.solrj.impl.ZkClientClusterStateProvider;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.IsUpdateRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.client.solrj.routing.RequestReplicaListTransformerGenerator;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.ToleratedUpdateError;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionStatePredicate;
import org.apache.solr.common.cloud.CollectionStateWatcher;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocCollectionWatcher;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.UrlScheme;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.Hash;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class BaseCloudSolrClient
extends SolrClient {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private volatile String defaultCollection;
    private static final int MAX_STALE_RETRIES = Integer.parseInt(System.getProperty("cloudSolrClientMaxStaleRetries", "5"));
    private Random rand = new Random();
    private final boolean updatesToLeaders;
    private final boolean directUpdatesToLeadersOnly;
    private final RequestReplicaListTransformerGenerator requestRLTGenerator;
    boolean parallelUpdates;
    private ExecutorService threadPool = ExecutorUtil.newMDCAwareCachedThreadPool(new SolrNamedThreadFactory("CloudSolrClient ThreadPool"));
    @Deprecated
    private String routeFieldDeprecated = null;
    public static final String STATE_VERSION = "_stateVer_";
    private long retryExpiryTime = TimeUnit.NANOSECONDS.convert(3L, TimeUnit.SECONDS);
    private final Set<String> NON_ROUTABLE_PARAMS = new HashSet<String>();
    private volatile List<Object> locks;
    protected final StateCache collectionStateCache;

    public void setRetryExpiryTime(int secs) {
        this.retryExpiryTime = TimeUnit.NANOSECONDS.convert(secs, TimeUnit.SECONDS);
    }

    protected BaseCloudSolrClient(boolean updatesToLeaders, boolean parallelUpdates, boolean directUpdatesToLeadersOnly) {
        this.NON_ROUTABLE_PARAMS.add("expungeDeletes");
        this.NON_ROUTABLE_PARAMS.add("maxSegments");
        this.NON_ROUTABLE_PARAMS.add("commit");
        this.NON_ROUTABLE_PARAMS.add("waitSearcher");
        this.NON_ROUTABLE_PARAMS.add("openSearcher");
        this.NON_ROUTABLE_PARAMS.add("softCommit");
        this.NON_ROUTABLE_PARAMS.add("prepareCommit");
        this.NON_ROUTABLE_PARAMS.add("optimize");
        this.locks = BaseCloudSolrClient.objectList(3);
        this.collectionStateCache = new StateCache();
        this.updatesToLeaders = updatesToLeaders;
        this.parallelUpdates = parallelUpdates;
        this.directUpdatesToLeadersOnly = directUpdatesToLeadersOnly;
        this.requestRLTGenerator = new RequestReplicaListTransformerGenerator();
    }

    public void setCollectionCacheTTl(int seconds) {
        assert (seconds > 0);
        this.collectionStateCache.timeToLive = (long)seconds * 1000L;
    }

    protected abstract LBSolrClient getLbClient();

    public abstract ClusterStateProvider getClusterStateProvider();

    protected abstract boolean wasCommError(Throwable var1);

    @Override
    public void close() throws IOException {
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
        }
    }

    public ResponseParser getParser() {
        return this.getLbClient().getParser();
    }

    public void setParser(ResponseParser processor) {
        this.getLbClient().setParser(processor);
    }

    public RequestWriter getRequestWriter() {
        return this.getLbClient().getRequestWriter();
    }

    public void setRequestWriter(RequestWriter requestWriter) {
        this.getLbClient().setRequestWriter(requestWriter);
    }

    public String getZkHost() {
        return this.assertZKStateProvider().zkHost;
    }

    public ZkStateReader getZkStateReader() {
        if (this.getClusterStateProvider() instanceof ZkClientClusterStateProvider) {
            ZkClientClusterStateProvider provider = (ZkClientClusterStateProvider)this.getClusterStateProvider();
            this.getClusterStateProvider().connect();
            return provider.zkStateReader;
        }
        throw new IllegalStateException("This has no Zk stateReader");
    }

    @Deprecated
    public void setIdField(String routeField) {
        log.warn("setIdField is deprecated, route field inferred from cluster state");
        this.routeFieldDeprecated = routeField;
    }

    @Deprecated
    public String getIdField() {
        log.warn("getIdField is deprecated, route field is in cluster state");
        return this.routeFieldDeprecated;
    }

    public void setDefaultCollection(String collection) {
        this.defaultCollection = collection;
    }

    public String getDefaultCollection() {
        return this.defaultCollection;
    }

    public void setZkConnectTimeout(int zkConnectTimeout) {
        this.assertZKStateProvider().zkConnectTimeout = zkConnectTimeout;
    }

    public void setZkClientTimeout(int zkClientTimeout) {
        this.assertZKStateProvider().zkClientTimeout = zkClientTimeout;
    }

    public boolean isParallelUpdates() {
        return this.parallelUpdates;
    }

    public void connect() {
        this.getClusterStateProvider().connect();
    }

    public void connect(long duration, TimeUnit timeUnit) throws TimeoutException, InterruptedException {
        if (log.isInfoEnabled()) {
            log.info("Waiting for {} {} for cluster at {} to be ready", new Object[]{duration, timeUnit, this.getClusterStateProvider()});
        }
        long timeout = System.nanoTime() + timeUnit.toNanos(duration);
        while (System.nanoTime() < timeout) {
            try {
                this.connect();
                if (log.isInfoEnabled()) {
                    log.info("Cluster at {} ready", (Object)this.getClusterStateProvider());
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                TimeUnit.MILLISECONDS.sleep(250L);
            }
        }
        throw new TimeoutException("Timed out waiting for cluster");
    }

    private ZkClientClusterStateProvider assertZKStateProvider() {
        if (this.getClusterStateProvider() instanceof ZkClientClusterStateProvider) {
            return (ZkClientClusterStateProvider)this.getClusterStateProvider();
        }
        throw new IllegalArgumentException("This client does not use ZK");
    }

    public void waitForState(String collection, long wait, TimeUnit unit, CollectionStatePredicate predicate) throws InterruptedException, TimeoutException {
        this.getClusterStateProvider().connect();
        this.assertZKStateProvider().zkStateReader.waitForState(collection, wait, unit, predicate);
    }

    public void waitForState(String collection, long wait, TimeUnit unit, Predicate<DocCollection> predicate) throws InterruptedException, TimeoutException {
        this.getClusterStateProvider().connect();
        this.assertZKStateProvider().zkStateReader.waitForState(collection, wait, unit, predicate);
    }

    public void registerCollectionStateWatcher(String collection, CollectionStateWatcher watcher) {
        this.getClusterStateProvider().connect();
        this.assertZKStateProvider().zkStateReader.registerCollectionStateWatcher(collection, watcher);
    }

    public void registerDocCollectionWatcher(String collection, DocCollectionWatcher watcher) {
        this.getClusterStateProvider().connect();
        this.assertZKStateProvider().zkStateReader.registerDocCollectionWatcher(collection, watcher);
    }

    private NamedList<Object> directUpdate(AbstractUpdateRequest request, String collection) throws SolrServerException {
        String routeField;
        UpdateRequest updateRequest = (UpdateRequest)request;
        ModifiableSolrParams params = request.getParams();
        ModifiableSolrParams routableParams = new ModifiableSolrParams();
        ModifiableSolrParams nonRoutableParams = new ModifiableSolrParams();
        if (params != null) {
            nonRoutableParams.add(params);
            routableParams.add(params);
            for (String param : this.NON_ROUTABLE_PARAMS) {
                routableParams.remove(param);
            }
        } else {
            params = new ModifiableSolrParams();
        }
        if (collection == null) {
            throw new SolrServerException("No collection param specified on request and no default collection has been set.");
        }
        List<String> aliasedCollections = this.getClusterStateProvider().resolveAlias(collection);
        if (!this.getClusterStateProvider().isRoutedAlias(collection) && aliasedCollections.size() != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Update request to non-routed multi-collection alias not supported: " + collection + " -> " + aliasedCollections);
        }
        collection = aliasedCollections.get(0);
        DocCollection col = this.getDocCollection(collection, null);
        DocRouter router = col.getRouter();
        if (router instanceof ImplicitDocRouter) {
            return null;
        }
        ReplicaListTransformer replicaListTransformer = this.requestRLTGenerator.getReplicaListTransformer(params);
        Map<String, List<String>> urlMap = this.buildUrlMap(col, replicaListTransformer);
        Map<String, ? extends LBSolrClient.Req> routes = this.createRoutes(updateRequest, routableParams, col, router, urlMap, routeField = this.routeFieldDeprecated != null ? this.routeFieldDeprecated : (col.getRouter().getRouteField(col) == null ? "id" : col.getRouter().getRouteField(col)));
        if (routes == null) {
            if (this.directUpdatesToLeadersOnly && BaseCloudSolrClient.hasInfoToFindLeaders(updateRequest, routeField)) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "directUpdatesToLeadersOnly==true but could not find leader(s)");
            }
            return null;
        }
        NamedList<Throwable> exceptions = new NamedList<Throwable>();
        NamedList<NamedList<Object>> shardResponses = new NamedList<NamedList<Object>>(routes.size() + 1);
        long start = System.nanoTime();
        if (this.parallelUpdates) {
            String url;
            HashMap<String, Future<NamedList>> responseFutures = new HashMap<String, Future<NamedList>>(routes.size());
            for (Map.Entry<String, ? extends LBSolrClient.Req> entry : routes.entrySet()) {
                url = entry.getKey();
                LBSolrClient.Req lbRequest = entry.getValue();
                try {
                    MDC.put((String)"CloudSolrClient.url", (String)url);
                    responseFutures.put(url, this.threadPool.submit(() -> this.getLbClient().request(lbRequest).getResponse()));
                }
                finally {
                    MDC.remove((String)"CloudSolrClient.url");
                }
            }
            for (Map.Entry<String, LBSolrClient.Req> entry : responseFutures.entrySet()) {
                url = entry.getKey();
                Future responseFuture = (Future)((Object)entry.getValue());
                try {
                    shardResponses.add(url, (NamedList)responseFuture.get());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    exceptions.add(url, e.getCause());
                }
            }
            if (exceptions.size() > 0) {
                Throwable throwable = (Throwable)exceptions.getVal(0);
                if (throwable instanceof SolrException) {
                    SolrException e = (SolrException)throwable;
                    throw this.getRouteException(SolrException.ErrorCode.getErrorCode(e.code()), exceptions, routes);
                }
                throw this.getRouteException(SolrException.ErrorCode.SERVER_ERROR, exceptions, routes);
            }
        } else {
            for (Map.Entry<String, ? extends LBSolrClient.Req> entry : routes.entrySet()) {
                String url = entry.getKey();
                LBSolrClient.Req lbRequest = entry.getValue();
                try {
                    NamedList<Object> rsp = this.getLbClient().request(lbRequest).getResponse();
                    shardResponses.add(url, rsp);
                }
                catch (Exception e) {
                    if (e instanceof SolrException) {
                        throw (SolrException)e;
                    }
                    throw new SolrServerException(e);
                }
            }
        }
        UpdateRequest nonRoutableRequest = null;
        List<String> list = updateRequest.getDeleteQuery();
        if (list != null && list.size() > 0) {
            UpdateRequest deleteQueryRequest = new UpdateRequest();
            deleteQueryRequest.setDeleteQuery(list);
            nonRoutableRequest = deleteQueryRequest;
        }
        Set<String> paramNames = nonRoutableParams.getParameterNames();
        HashSet<String> intersection = new HashSet<String>(paramNames);
        intersection.retainAll(this.NON_ROUTABLE_PARAMS);
        if (nonRoutableRequest != null || intersection.size() > 0) {
            if (nonRoutableRequest == null) {
                nonRoutableRequest = new UpdateRequest();
            }
            nonRoutableRequest.setParams(nonRoutableParams);
            nonRoutableRequest.setBasicAuthCredentials(request.getBasicAuthUser(), request.getBasicAuthPassword());
            ArrayList<String> urlList = new ArrayList<String>(routes.keySet());
            Collections.shuffle(urlList, this.rand);
            LBSolrClient.Req req = new LBSolrClient.Req(nonRoutableRequest, urlList);
            try {
                LBSolrClient.Rsp rsp = this.getLbClient().request(req);
                shardResponses.add((String)urlList.get(0), rsp.getResponse());
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (String)urlList.get(0), (Throwable)e);
            }
        }
        long end = System.nanoTime();
        RouteResponse rr = this.condenseResponse(shardResponses, (int)TimeUnit.MILLISECONDS.convert(end - start, TimeUnit.NANOSECONDS));
        rr.setRouteResponses(shardResponses);
        rr.setRoutes(routes);
        return rr;
    }

    protected RouteException getRouteException(SolrException.ErrorCode serverError, NamedList<Throwable> exceptions, Map<String, ? extends LBSolrClient.Req> routes) {
        return new RouteException(serverError, exceptions, routes);
    }

    protected Map<String, ? extends LBSolrClient.Req> createRoutes(UpdateRequest updateRequest, ModifiableSolrParams routableParams, DocCollection col, DocRouter router, Map<String, List<String>> urlMap, String routeField) {
        return urlMap == null ? null : updateRequest.getRoutesToCollection(router, col, urlMap, routableParams, routeField);
    }

    private Map<String, List<String>> buildUrlMap(DocCollection col, ReplicaListTransformer replicaListTransformer) {
        Slice[] slices;
        HashMap<String, List<String>> urlMap = new HashMap<String, List<String>>();
        Slice[] sliceArray = slices = col.getActiveSlicesArr();
        int n = slices.length;
        int n2 = 0;
        while (n2 < n) {
            Replica replica2;
            Iterator<Replica> iterator;
            Slice slice = sliceArray[n2];
            String name = slice.getName();
            ArrayList<Replica> sortedReplicas = new ArrayList<Replica>();
            Replica leader = slice.getLeader();
            if (this.directUpdatesToLeadersOnly && leader == null && (iterator = slice.getReplicas(replica -> replica.isActive(this.getClusterStateProvider().getLiveNodes()) && replica.getType() == Replica.Type.NRT).iterator()).hasNext()) {
                leader = replica2 = iterator.next();
            }
            if (leader == null) {
                if (!this.directUpdatesToLeadersOnly) {
                    return null;
                }
            } else {
                if (!this.directUpdatesToLeadersOnly) {
                    iterator = slice.getReplicas().iterator();
                    while (iterator.hasNext()) {
                        replica2 = iterator.next();
                        if (replica2.equals(leader)) continue;
                        sortedReplicas.add(replica2);
                    }
                }
                replicaListTransformer.transform(sortedReplicas);
                sortedReplicas.add(0, leader);
                urlMap.put(name, sortedReplicas.stream().map(Replica::getCoreUrl).collect(Collectors.toList()));
            }
            ++n2;
        }
        return urlMap;
    }

    protected <T extends RouteResponse> T condenseResponse(NamedList response, int timeMillis, Supplier<T> supplier) {
        RouteResponse condensed = (RouteResponse)supplier.get();
        int status = 0;
        Integer rf = null;
        Integer minRf = null;
        ArrayList<SimpleOrderedMap> toleratedErrors = null;
        int maxToleratedErrors = Integer.MAX_VALUE;
        HashMap<String, NamedList> versions = new HashMap<String, NamedList>();
        int i = 0;
        while (i < response.size()) {
            Object rfObj;
            NamedList shardResponse = (NamedList)response.getVal(i);
            NamedList header = (NamedList)shardResponse.get("responseHeader");
            Integer shardStatus = (Integer)header.get("status");
            int s = shardStatus;
            if (s > 0) {
                status = s;
            }
            if ((rfObj = header.get("rf")) != null && rfObj instanceof Integer) {
                Integer routeRf = (Integer)rfObj;
                if (rf == null || routeRf < rf) {
                    rf = routeRf;
                }
            }
            minRf = (Integer)header.get("min_rf");
            List shardTolerantErrors = (List)header.get("errors");
            if (shardTolerantErrors != null) {
                Integer shardMaxToleratedErrors = (Integer)header.get("maxErrors");
                assert (shardMaxToleratedErrors != null) : "TolerantUpdateProcessor reported errors but not maxErrors";
                maxToleratedErrors = Math.min(maxToleratedErrors, ToleratedUpdateError.getEffectiveMaxErrors(shardMaxToleratedErrors));
                if (toleratedErrors == null) {
                    toleratedErrors = new ArrayList<SimpleOrderedMap>(shardTolerantErrors.size());
                }
                for (SimpleOrderedMap err : shardTolerantErrors) {
                    toleratedErrors.add(err);
                }
            }
            for (String updateType : Arrays.asList("adds", "deletes", "deleteByQuery")) {
                Object obj = shardResponse.get(updateType);
                if (!(obj instanceof NamedList)) continue;
                NamedList versionsList = versions.containsKey(updateType) ? (NamedList)versions.get(updateType) : new NamedList();
                versionsList.addAll((NamedList)obj);
                versions.put(updateType, versionsList);
            }
            ++i;
        }
        NamedList<Serializable> cheader = new NamedList<Serializable>();
        cheader.add("status", Integer.valueOf(status));
        cheader.add("QTime", Integer.valueOf(timeMillis));
        if (rf != null) {
            cheader.add("rf", rf);
        }
        if (minRf != null) {
            cheader.add("min_rf", minRf);
        }
        if (toleratedErrors != null) {
            cheader.add("maxErrors", Integer.valueOf(ToleratedUpdateError.getUserFriendlyMaxErrors(maxToleratedErrors)));
            cheader.add("errors", toleratedErrors);
            if (maxToleratedErrors < toleratedErrors.size()) {
                StringBuilder msgBuf = new StringBuilder().append(toleratedErrors.size()).append(" Async failures during distributed update: ");
                NamedList<String> metadata = new NamedList<String>();
                for (SimpleOrderedMap err : toleratedErrors) {
                    ToleratedUpdateError te = ToleratedUpdateError.parseMap(err);
                    metadata.add(te.getMetadataKey(), te.getMetadataValue());
                    msgBuf.append("\n").append(te.getMessage());
                }
                SolrException toThrow = new SolrException(SolrException.ErrorCode.BAD_REQUEST, msgBuf.toString());
                toThrow.setMetadata(metadata);
                throw toThrow;
            }
        }
        for (Map.Entry entry : versions.entrySet()) {
            condensed.add((String)entry.getKey(), entry.getValue());
        }
        condensed.add("responseHeader", cheader);
        return (T)condensed;
    }

    public RouteResponse condenseResponse(NamedList response, int timeMillis) {
        return this.condenseResponse(response, timeMillis, RouteResponse::new);
    }

    @Override
    public NamedList<Object> request(SolrRequest request, String collection) throws SolrServerException, IOException {
        String requestCollection = request.getCollection();
        if (requestCollection != null) {
            collection = requestCollection;
        } else if (collection == null) {
            collection = this.defaultCollection;
        }
        List<String> inputCollections = collection == null ? Collections.emptyList() : StrUtils.splitSmart(collection, ",", true);
        return this.requestWithRetryOnStaleState(request, 0, inputCollections);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected NamedList<Object> requestWithRetryOnStaleState(SolrRequest request, int retryCount, List<String> inputCollections) throws SolrServerException, IOException {
        block30: {
            block33: {
                block31: {
                    block32: {
                        this.connect();
                        stateVerParam = null;
                        requestedCollections = null;
                        isCollectionRequestOfV2 = false;
                        if (request instanceof V2RequestSupport) {
                            request = ((V2RequestSupport)request).getV2Request();
                        }
                        if (request instanceof V2Request) {
                            isCollectionRequestOfV2 = ((V2Request)request).isPerCollectionRequest();
                        }
                        isAdmin = CommonParams.ADMIN_PATHS.contains(request.getPath());
                        v0 = isUpdate = request instanceof IsUpdateRequest != false && request instanceof UpdateRequest != false;
                        if (!(inputCollections.isEmpty() || isAdmin || isCollectionRequestOfV2)) {
                            requestedCollectionNames = this.resolveAliases(inputCollections, isUpdate);
                            stateVerParamBuilder = null;
                            for (String requestedCollection : requestedCollectionNames) {
                                coll = this.getDocCollection(requestedCollection, null);
                                if (coll == null) {
                                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection not found: " + requestedCollection);
                                }
                                collVer = coll.getZNodeVersion();
                                if (coll.getStateFormat() <= 1) continue;
                                if (requestedCollections == null) {
                                    requestedCollections = new ArrayList<Object>(requestedCollectionNames.size());
                                }
                                requestedCollections.add(coll);
                                if (stateVerParamBuilder == null) {
                                    stateVerParamBuilder = new StringBuilder();
                                } else {
                                    stateVerParamBuilder.append("|");
                                }
                                stateVerParamBuilder.append(coll.getName()).append(":").append(collVer);
                            }
                            if (stateVerParamBuilder != null) {
                                stateVerParam = stateVerParamBuilder.toString();
                            }
                        }
                        if (request.getParams() instanceof ModifiableSolrParams) {
                            params = (ModifiableSolrParams)request.getParams();
                            if (stateVerParam != null) {
                                params.set("_stateVer_", new String[]{stateVerParam});
                            } else {
                                params.remove("_stateVer_");
                            }
                        }
                        resp = null;
                        try {
                            resp = this.sendRequest(request, inputCollections);
                            v1 = o = resp == null || resp.size() == 0 ? null : resp.get("_stateVer_", resp.size() - 1);
                            if (o != null && o instanceof Map) {
                                resp.remove(resp.size() - 1);
                                invalidStates = (Map)o;
                                for (E invalidEntries : invalidStates.entrySet()) {
                                    e = (Map.Entry)invalidEntries;
                                    this.getDocCollection((String)e.getKey(), (Integer)e.getValue());
                                }
                            }
                            break block30;
                        }
                        catch (Exception exc) {
                            rootCause = SolrException.getRootCause(exc);
                            if (inputCollections.isEmpty() || isAdmin || request instanceof V2Request && request.getMethod() != SolrRequest.METHOD.GET) {
                                if (exc instanceof SolrServerException) {
                                    throw (SolrServerException)exc;
                                }
                                if (exc instanceof IOException) {
                                    throw (IOException)exc;
                                }
                                if (exc instanceof RuntimeException) {
                                    throw (RuntimeException)exc;
                                }
                                throw new SolrServerException(rootCause);
                            }
                            errorCode = rootCause instanceof SolrException != false ? ((SolrException)rootCause).code() : SolrException.ErrorCode.UNKNOWN.code;
                            v2 = wasCommError = rootCause instanceof ConnectException != false || rootCause instanceof SocketException != false || this.wasCommError(rootCause) != false;
                            if (!wasCommError && (!(exc instanceof RouteException) || errorCode != 503)) break block31;
                            if (requestedCollections == null) break block32;
                            ** for (ext : requestedCollections)
                        }
lbl-1000:
                        // 1 sources

                        {
                            cacheEntry = this.collectionStateCache.get(ext.getName());
                            if (cacheEntry == null) continue;
                            cacheEntry.maybeStale = true;
                            continue;
                        }
                    }
                    if (retryCount < BaseCloudSolrClient.MAX_STALE_RETRIES) {
                        BaseCloudSolrClient.log.info("Request to collection {} failed due to ({}) {}, retry={} maxRetries={} commError={} errorCode={} - retrying", new Object[]{inputCollections, errorCode, rootCause, retryCount, BaseCloudSolrClient.MAX_STALE_RETRIES, wasCommError, errorCode});
                        return this.requestWithRetryOnStaleState(request, retryCount + 1, inputCollections);
                    }
                    break block33;
                }
                BaseCloudSolrClient.log.info("request was not communication error it seems");
            }
            BaseCloudSolrClient.log.info("Request to collection {} failed due to ({}) {}, retry={} maxRetries={} commError={} errorCode={} ", new Object[]{inputCollections, errorCode, rootCause, retryCount, BaseCloudSolrClient.MAX_STALE_RETRIES, wasCommError, errorCode});
            stateWasStale = false;
            if (!(retryCount >= BaseCloudSolrClient.MAX_STALE_RETRIES || requestedCollections == null || requestedCollections.isEmpty() || SolrException.ErrorCode.getErrorCode(errorCode) != SolrException.ErrorCode.INVALID_STATE && errorCode != 404)) {
                stateWasStale = true;
                for (DocCollection ext : requestedCollections) {
                    this.collectionStateCache.remove(ext.getName());
                }
            }
            if (retryCount < BaseCloudSolrClient.MAX_STALE_RETRIES && !stateWasStale && requestedCollections != null && !requestedCollections.isEmpty() && wasCommError) {
                for (DocCollection ext : requestedCollections) {
                    latestStateFromZk = this.getDocCollection(ext.getName(), null);
                    if (latestStateFromZk.getZNodeVersion() == ext.getZNodeVersion()) continue;
                    stateWasStale = true;
                    this.collectionStateCache.put(ext.getName(), new ExpiringCachedDocCollection(latestStateFromZk));
                }
            }
            if (requestedCollections != null) {
                requestedCollections.clear();
            }
            if (stateWasStale) {
                BaseCloudSolrClient.log.warn("Re-trying request to collection(s) {} after stale state error from server.", inputCollections);
                resp = this.requestWithRetryOnStaleState(request, retryCount + 1, inputCollections);
            } else {
                if (exc instanceof SolrException || exc instanceof SolrServerException || exc instanceof IOException) {
                    throw exc;
                }
                throw new SolrServerException(rootCause);
            }
        }
        return resp;
    }

    protected NamedList<Object> sendRequest(SolrRequest request, List<String> inputCollections) throws SolrServerException, IOException {
        SolrParams reqParams;
        this.connect();
        boolean sendToLeaders = false;
        boolean isUpdate = false;
        if (request instanceof IsUpdateRequest) {
            if (request instanceof UpdateRequest) {
                isUpdate = true;
                if (inputCollections.size() > 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Update request must be sent to a single collection or an alias: " + inputCollections);
                }
                String collection = inputCollections.isEmpty() ? null : inputCollections.get(0);
                NamedList<Object> response = this.directUpdate((AbstractUpdateRequest)request, collection);
                if (response != null) {
                    return response;
                }
            }
            sendToLeaders = true;
        }
        if ((reqParams = request.getParams()) == null) {
            reqParams = new ModifiableSolrParams();
        }
        ReplicaListTransformer replicaListTransformer = this.requestRLTGenerator.getReplicaListTransformer(reqParams);
        Set<String> liveNodes = this.getClusterStateProvider().getLiveNodes();
        ArrayList<String> theUrlList = new ArrayList<String>();
        if (request instanceof V2Request) {
            if (!liveNodes.isEmpty()) {
                ArrayList<String> liveNodesList = new ArrayList<String>(liveNodes);
                Collections.shuffle(liveNodesList, this.rand);
                theUrlList.add(UrlScheme.INSTANCE.getBaseUrlForNodeName((String)liveNodesList.get(0)));
            }
        } else if (CommonParams.ADMIN_PATHS.contains(request.getPath())) {
            for (String liveNode : liveNodes) {
                theUrlList.add(UrlScheme.INSTANCE.getBaseUrlForNodeName(liveNode));
            }
        } else {
            Set<String> collectionNames = this.resolveAliases(inputCollections, isUpdate);
            if (collectionNames.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No collection param specified on request and no default collection has been set: " + inputCollections);
            }
            HashMap<String, Slice> slices = new HashMap<String, Slice>();
            String shardKeys = reqParams.get("_route_");
            for (String collectionName : collectionNames) {
                DocCollection col = this.getDocCollection(collectionName, null);
                if (col == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection not found: " + collectionName);
                }
                Collection<Slice> routeSlices = col.getRouter().getSearchSlices(shardKeys, reqParams, col);
                ClientUtils.addSlices(slices, collectionName, routeSlices, true);
            }
            ArrayList<Replica> sortedReplicas = new ArrayList<Replica>();
            ArrayList<Replica> replicas = new ArrayList<Replica>();
            for (Slice slice : slices.values()) {
                Replica leader = slice.getLeader();
                for (Replica replica2 : slice.getReplicas()) {
                    String node = replica2.getNodeName();
                    if (!liveNodes.contains(node) || replica2.getState() != Replica.State.ACTIVE) continue;
                    if (sendToLeaders && replica2.equals(leader)) {
                        sortedReplicas.add(replica2);
                        continue;
                    }
                    replicas.add(replica2);
                }
            }
            replicaListTransformer.transform(sortedReplicas);
            replicaListTransformer.transform(replicas);
            sortedReplicas.addAll(replicas);
            String joinedInputCollections = StrUtils.join(inputCollections, ',');
            HashSet seenNodes = new HashSet();
            sortedReplicas.forEach(replica -> {
                if (seenNodes.add(replica.getNodeName())) {
                    theUrlList.add(ZkCoreNodeProps.getCoreUrl(replica.getBaseUrl(), joinedInputCollections));
                }
            });
            if (theUrlList.isEmpty()) {
                ((ConcurrentHashMap.KeySetView)this.collectionStateCache.keySet()).removeAll(collectionNames);
                throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Could not find a healthy node to handle the request.");
            }
        }
        LBSolrClient.Req req = new LBSolrClient.Req(request, theUrlList);
        LBSolrClient.Rsp rsp = this.getLbClient().request(req);
        return rsp.getResponse();
    }

    private Set<String> resolveAliases(List<String> inputCollections, boolean isUpdate) {
        if (inputCollections.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> uniqueNames = new LinkedHashSet<String>();
        for (String collectionName : inputCollections) {
            if (this.getClusterStateProvider().getState(collectionName) == null) {
                uniqueNames.addAll(this.getClusterStateProvider().resolveAlias(collectionName));
                continue;
            }
            uniqueNames.add(collectionName);
        }
        return uniqueNames;
    }

    public boolean isUpdatesToLeaders() {
        return this.updatesToLeaders;
    }

    public boolean isDirectUpdatesToLeadersOnly() {
        return this.directUpdatesToLeadersOnly;
    }

    public void setParallelCacheRefreshes(int n) {
        this.locks = BaseCloudSolrClient.objectList(n);
    }

    protected static ArrayList<Object> objectList(int n) {
        ArrayList<Object> l = new ArrayList<Object>(n);
        int i = 0;
        while (i < n) {
            l.add(new Object());
            ++i;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocCollection getDocCollection(String collection, Integer expectedVersion) throws SolrException {
        DocCollection col;
        if (expectedVersion == null) {
            expectedVersion = -1;
        }
        if (collection == null) {
            return null;
        }
        ExpiringCachedDocCollection cacheEntry = this.collectionStateCache.get(collection);
        DocCollection docCollection = col = cacheEntry == null ? null : cacheEntry.cached;
        if (col != null && expectedVersion <= col.getZNodeVersion() && !cacheEntry.shouldRetry()) {
            return col;
        }
        ClusterState.CollectionRef ref = this.getCollectionRef(collection);
        if (ref == null) {
            return null;
        }
        if (!ref.isLazilyLoaded()) {
            return ref.get();
        }
        List<Object> locks = this.locks;
        Object lock = locks.get(Math.abs(Hash.murmurhash3_x86_32(collection, 0, collection.length(), 0) % locks.size()));
        DocCollection fetchedCol = null;
        Object object = lock;
        synchronized (object) {
            block13: {
                cacheEntry = this.collectionStateCache.get(collection);
                DocCollection docCollection2 = col = cacheEntry == null ? null : cacheEntry.cached;
                if (col != null && expectedVersion <= col.getZNodeVersion() && !cacheEntry.shouldRetry()) {
                    return col;
                }
                fetchedCol = ref.get();
                if (fetchedCol != null) break block13;
                return null;
            }
            if (col != null && fetchedCol.getZNodeVersion() == col.getZNodeVersion()) {
                cacheEntry.setRetriedAt();
                cacheEntry.maybeStale = false;
            } else if (fetchedCol.getStateFormat() > 1) {
                this.collectionStateCache.put(collection, new ExpiringCachedDocCollection(fetchedCol));
            }
            return fetchedCol;
        }
    }

    ClusterState.CollectionRef getCollectionRef(String collection) {
        return this.getClusterStateProvider().getState(collection);
    }

    public int getMinAchievedReplicationFactor(String collection, NamedList resp) {
        NamedList header = (NamedList)resp.get("responseHeader");
        Integer achRf = (Integer)header.get("rf");
        if (achRf != null) {
            return achRf;
        }
        Map<String, Integer> shardRf = this.getShardReplicationFactor(collection, resp);
        for (Integer rf : shardRf.values()) {
            if (achRf != null && rf >= achRf) continue;
            achRf = rf;
        }
        return achRf != null ? achRf : -1;
    }

    public Map<String, Integer> getShardReplicationFactor(String collection, NamedList resp) {
        this.connect();
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        if (resp instanceof RouteResponse) {
            NamedList routes = ((RouteResponse)resp).getRouteResponses();
            DocCollection coll = this.getDocCollection(collection, null);
            HashMap<String, String> leaders = new HashMap<String, String>();
            Slice[] sliceArray = coll.getActiveSlicesArr();
            int n = sliceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Slice slice = sliceArray[n2];
                Replica leader = slice.getLeader();
                if (leader != null) {
                    ZkCoreNodeProps zkProps = new ZkCoreNodeProps(leader);
                    String leaderUrl = String.valueOf(zkProps.getBaseUrl()) + "/" + zkProps.getCoreName();
                    leaders.put(leaderUrl, slice.getName());
                    String altLeaderUrl = String.valueOf(zkProps.getBaseUrl()) + "/" + collection;
                    leaders.put(altLeaderUrl, slice.getName());
                }
                ++n2;
            }
            for (Map.Entry next : routes) {
                String host = next.getKey();
                NamedList hostResp = (NamedList)next.getValue();
                Integer rf = (Integer)((NamedList)hostResp.get("responseHeader")).get("rf");
                if (rf == null) continue;
                String shard = (String)leaders.get(host);
                if (shard == null) {
                    if (host.endsWith("/")) {
                        shard = (String)leaders.get(host.substring(0, host.length() - 1));
                    }
                    if (shard == null) {
                        shard = host;
                    }
                }
                results.put(shard, rf);
            }
        }
        return results;
    }

    private static boolean hasInfoToFindLeaders(UpdateRequest updateRequest, String idField) {
        boolean hasNoDeleteById;
        Map<SolrInputDocument, Map<String, Object>> documents = updateRequest.getDocumentsMap();
        Map<String, Map<String, Object>> deleteById = updateRequest.getDeleteByIdMap();
        boolean hasNoDocuments = documents == null || documents.isEmpty();
        boolean bl = hasNoDeleteById = deleteById == null || deleteById.isEmpty();
        if (hasNoDocuments && hasNoDeleteById) {
            return false;
        }
        if (documents != null) {
            for (Map.Entry<SolrInputDocument, Map<String, Object>> entry : documents.entrySet()) {
                SolrInputDocument doc = entry.getKey();
                Object fieldValue = doc.getFieldValue(idField);
                if (fieldValue != null) continue;
                return false;
            }
        }
        return true;
    }

    class ExpiringCachedDocCollection {
        final DocCollection cached;
        final long cachedAt;
        volatile long retriedAt = -1L;
        volatile boolean maybeStale = false;

        ExpiringCachedDocCollection(DocCollection cached) {
            this.cached = cached;
            this.cachedAt = System.nanoTime();
        }

        boolean isExpired(long timeToLiveMs) {
            return System.nanoTime() - this.cachedAt > TimeUnit.NANOSECONDS.convert(timeToLiveMs, TimeUnit.MILLISECONDS);
        }

        boolean shouldRetry() {
            return this.maybeStale && (this.retriedAt == -1L || System.nanoTime() - this.retriedAt > BaseCloudSolrClient.this.retryExpiryTime);
        }

        void setRetriedAt() {
            this.retriedAt = System.nanoTime();
        }
    }

    public static class RouteException
    extends SolrException {
        private NamedList<Throwable> throwables;
        private Map<String, ? extends LBSolrClient.Req> routes;

        public RouteException(SolrException.ErrorCode errorCode, NamedList<Throwable> throwables, Map<String, ? extends LBSolrClient.Req> routes) {
            super(errorCode, throwables.getVal(0).getMessage(), throwables.getVal(0));
            this.throwables = throwables;
            this.routes = routes;
            NamedList<String> metadata = new NamedList<String>();
            int i = 0;
            while (i < throwables.size()) {
                SolrException e;
                NamedList<String> eMeta;
                Throwable t = throwables.getVal(i);
                if (t instanceof SolrException && (eMeta = (e = (SolrException)t).getMetadata()) != null) {
                    metadata.addAll(eMeta);
                }
                ++i;
            }
            if (metadata.size() > 0) {
                this.setMetadata(metadata);
            }
        }

        public NamedList<Throwable> getThrowables() {
            return this.throwables;
        }

        public Map<String, ? extends LBSolrClient.Req> getRoutes() {
            return this.routes;
        }
    }

    public static class RouteResponse<T extends LBSolrClient.Req>
    extends NamedList {
        private NamedList routeResponses;
        private Map<String, T> routes;

        public void setRouteResponses(NamedList routeResponses) {
            this.routeResponses = routeResponses;
        }

        public NamedList getRouteResponses() {
            return this.routeResponses;
        }

        public void setRoutes(Map<String, T> routes) {
            this.routes = routes;
        }

        public Map<String, T> getRoutes() {
            return this.routes;
        }
    }

    static class StateCache
    extends ConcurrentHashMap<String, ExpiringCachedDocCollection> {
        final AtomicLong puts = new AtomicLong();
        final AtomicLong hits = new AtomicLong();
        final Lock evictLock = new ReentrantLock(true);
        protected volatile long timeToLive = 60000L;

        StateCache() {
        }

        @Override
        public ExpiringCachedDocCollection get(Object key) {
            ExpiringCachedDocCollection val = (ExpiringCachedDocCollection)super.get(key);
            if (val == null) {
                this.evictStale();
                return null;
            }
            if (val.isExpired(this.timeToLive)) {
                super.remove(key);
                return null;
            }
            this.hits.incrementAndGet();
            return val;
        }

        @Override
        public ExpiringCachedDocCollection put(String key, ExpiringCachedDocCollection value) {
            this.puts.incrementAndGet();
            return super.put(key, value);
        }

        void evictStale() {
            if (!this.evictLock.tryLock()) {
                return;
            }
            try {
                for (Map.Entry e : this.entrySet()) {
                    if (!((ExpiringCachedDocCollection)e.getValue()).isExpired(this.timeToLive)) continue;
                    super.remove(e.getKey());
                }
            }
            finally {
                this.evictLock.unlock();
            }
        }
    }
}

