/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.embedded;

import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SSLConfig {
    private boolean useSsl;
    private boolean clientAuth;
    private String keyStore;
    private String keyStorePassword;
    private String trustStore;
    private String trustStorePassword;

    public SSLConfig(boolean useSsl, boolean clientAuth, String keyStore, String keyStorePassword, String trustStore, String trustStorePassword) {
        this.useSsl = useSsl;
        this.clientAuth = clientAuth;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
    }

    public void setUseSSL(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public void setClientAuth(boolean clientAuth) {
        this.clientAuth = clientAuth;
    }

    public boolean isSSLMode() {
        return this.useSsl;
    }

    public boolean isClientAuthMode() {
        return this.clientAuth;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public static SslContextFactory.Server createContextFactory(SSLConfig sslConfig) {
        if (sslConfig != null) {
            return sslConfig.createContextFactory();
        }
        if (Boolean.getBoolean("tests.jettySsl")) {
            return SSLConfig.configureSslFromSysProps();
        }
        return null;
    }

    public SslContextFactory.Server createContextFactory() {
        if (!this.isSSLMode()) {
            return null;
        }
        SslContextFactory.Server factory = new SslContextFactory.Server();
        if (this.getKeyStore() != null) {
            factory.setKeyStorePath(this.getKeyStore());
        }
        if (this.getKeyStorePassword() != null) {
            factory.setKeyStorePassword(this.getKeyStorePassword());
        }
        factory.setNeedClientAuth(this.isClientAuthMode());
        if (this.isClientAuthMode()) {
            if (this.getTrustStore() != null) {
                factory.setTrustStorePath(this.getTrustStore());
            }
            if (this.getTrustStorePassword() != null) {
                factory.setTrustStorePassword(this.getTrustStorePassword());
            }
        }
        return factory;
    }

    public SslContextFactory.Client createClientContextFactory() {
        if (!this.isSSLMode()) {
            return null;
        }
        SslContextFactory.Client factory = new SslContextFactory.Client();
        if (this.getKeyStore() != null) {
            factory.setKeyStorePath(this.getKeyStore());
        }
        if (this.getKeyStorePassword() != null) {
            factory.setKeyStorePassword(this.getKeyStorePassword());
        }
        if (this.isClientAuthMode()) {
            if (this.getTrustStore() != null) {
                factory.setTrustStorePath(this.getTrustStore());
            }
            if (this.getTrustStorePassword() != null) {
                factory.setTrustStorePassword(this.getTrustStorePassword());
            }
        }
        return factory;
    }

    private static SslContextFactory.Server configureSslFromSysProps() {
        SslContextFactory.Server sslcontext = new SslContextFactory.Server();
        if (System.getProperty("javax.net.ssl.keyStore") != null) {
            sslcontext.setKeyStorePath(System.getProperty("javax.net.ssl.keyStore"));
        }
        if (System.getProperty("javax.net.ssl.keyStorePassword") != null) {
            sslcontext.setKeyStorePassword(System.getProperty("javax.net.ssl.keyStorePassword"));
        }
        if (System.getProperty("javax.net.ssl.trustStore") != null) {
            sslcontext.setTrustStorePath(System.getProperty("javax.net.ssl.trustStore"));
        }
        if (System.getProperty("javax.net.ssl.trustStorePassword") != null) {
            sslcontext.setTrustStorePassword(System.getProperty("javax.net.ssl.trustStorePassword"));
        }
        sslcontext.setNeedClientAuth(Boolean.getBoolean("tests.jettySsl.clientAuth"));
        return sslcontext;
    }
}

