/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.Condition;
import org.apache.solr.client.solrj.cloud.autoscaling.Operand;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaCount;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.SealedClause;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.Utils;

public class Violation
implements MapWriter {
    final String shard;
    final String coll;
    final String node;
    final Object actualVal;
    Double replicaCountDelta;
    final Object tagKey;
    private final int hash;
    private final Clause clause;
    private List<ReplicaInfoAndErr> replicaInfoAndErrs = new ArrayList<ReplicaInfoAndErr>();

    Violation(SealedClause clause, String coll, String shard, String node, Object actualVal, Double replicaCountDelta, Object tagKey) {
        this.clause = clause;
        this.shard = shard;
        this.coll = coll;
        this.node = node;
        this.replicaCountDelta = replicaCountDelta;
        this.actualVal = actualVal;
        this.tagKey = tagKey;
        this.hash = (coll + " " + shard + " " + node + " " + String.valueOf(tagKey) + " " + Utils.toJSONString(this.getClause().toMap(new HashMap<String, Object>()))).hashCode();
    }

    public Violation addReplica(ReplicaInfoAndErr r) {
        this.replicaInfoAndErrs.add(r);
        return this;
    }

    public List<ReplicaInfoAndErr> getViolatingReplicas() {
        return this.replicaInfoAndErrs;
    }

    public Clause getClause() {
        return this.clause;
    }

    public boolean matchShard(String shard) {
        if (this.getClause().getShard().op == Operand.WILDCARD) {
            return true;
        }
        return this.shard == null || this.shard.equals(shard);
    }

    public boolean isLessSerious(Violation that) {
        return this.getClause().getTag().varType.compareViolation(this, that) < 0;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isSimilarViolation(Violation that) {
        if (Objects.equals(this.shard, that.shard) && Objects.equals(this.coll, that.coll) && Objects.equals(this.node, that.node)) {
            if (this.clause.isPerCollectiontag() && that.clause.isPerCollectiontag()) {
                return Objects.equals(this.clause.tag.getName(), that.clause.tag.getName());
            }
            if (!this.clause.isPerCollectiontag() && !that.clause.isPerCollectiontag()) {
                return Objects.equals(this.clause.globalTag.getName(), that.clause.globalTag.getName()) && Objects.equals(this.node, that.node);
            }
            return false;
        }
        return false;
    }

    public boolean equals(Object that) {
        if (that instanceof Violation) {
            Violation v = (Violation)that;
            return Objects.equals(this.shard, v.shard) && Objects.equals(this.coll, v.coll) && Objects.equals(this.clause, v.clause);
        }
        return false;
    }

    public String toString() {
        return Utils.toJSONString(Utils.getDeepCopy(this.toMap(new LinkedHashMap<String, Object>()), 5));
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.putIfNotNull("collection", this.coll);
        if (!"#ANY".equals(this.shard)) {
            ew.putIfNotNull("shard", this.shard);
        }
        ew.putIfNotNull("node", this.node);
        ew.putIfNotNull("tagKey", this.tagKey);
        ew.putIfNotNull("violation", ew1 -> {
            if (this.getClause().isPerCollectiontag()) {
                ew1.put((CharSequence)"replica", this.actualVal);
            } else {
                ew1.put((CharSequence)this.clause.tag.name, String.valueOf(this.actualVal));
            }
            ew1.putIfNotNull("delta", this.replicaCountDelta);
        });
        ew.put((CharSequence)"clause", this.getClause());
        if (!this.replicaInfoAndErrs.isEmpty()) {
            ew.put((CharSequence)"violatingReplicas", iw -> {
                for (ReplicaInfoAndErr replicaInfoAndErr : this.replicaInfoAndErrs) {
                    iw.add(replicaInfoAndErr.replicaInfo);
                }
            });
        }
    }

    static class Ctx {
        final Function<Condition, Object> evaluator;
        Object tagKey;
        Clause clause;
        ReplicaCount count;
        Violation currentViolation;
        List<Row> allRows;
        List<Violation> allViolations = new ArrayList<Violation>();

        public Ctx(Clause clause, List<Row> allRows, Function<Condition, Object> evaluator) {
            this.allRows = allRows;
            this.clause = clause;
            this.evaluator = evaluator;
        }

        public Ctx resetAndAddViolation(Object tagKey, ReplicaCount count, Violation currentViolation) {
            this.tagKey = tagKey;
            this.count = count;
            this.currentViolation = currentViolation;
            this.allViolations.add(currentViolation);
            this.clause = currentViolation.getClause();
            return this;
        }
    }

    static class ReplicaInfoAndErr
    implements MapWriter {
        final ReplicaInfo replicaInfo;
        Double delta;

        ReplicaInfoAndErr(ReplicaInfo replicaInfo) {
            this.replicaInfo = replicaInfo;
        }

        public ReplicaInfoAndErr withDelta(Double delta) {
            this.delta = delta;
            return this;
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.put((CharSequence)"replica", this.replicaInfo);
            ew.putIfNotNull("delta", this.delta);
        }
    }
}

