/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.ArrayList;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.Condition;
import org.apache.solr.client.solrj.cloud.autoscaling.Operand;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggestion;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.common.util.StrUtils;

public class VariableBase
implements Variable {
    final Variable.Type varType;

    public VariableBase(Variable.Type type) {
        this.varType = type;
    }

    @Override
    public void getSuggestions(Suggestion.Ctx ctx) {
        if (ctx.violation == null) {
            return;
        }
        if (ctx.violation.replicaCountDelta > 0.0) {
            Suggestion.suggestPositiveViolations(ctx);
        } else {
            Suggestion.suggestNegativeViolations(ctx, ArrayList::new);
        }
    }

    @Override
    public String postValidate(Condition condition) {
        if (Clause.IGNORE_TAGS.contains(condition.getName())) {
            return null;
        }
        if (condition.getOperand() == Operand.WILDCARD && condition.clause.nodeSetPresent) {
            return "#EACH not supported in tags in nodeset";
        }
        return null;
    }

    static Object getOperandAdjustedValue(Object val, Object original) {
        if (original instanceof Condition) {
            Condition condition = (Condition)original;
            if (condition.computedType == null && VariableBase.isIntegerEquivalent(val)) {
                if (condition.op == Operand.LESS_THAN) {
                    val = val instanceof Long ? (double)((Long)val - 1L) : (Double)val - 1.0;
                } else if (condition.op == Operand.GREATER_THAN) {
                    val = val instanceof Long ? (double)((Long)val + 1L) : (Double)val + 1.0;
                }
            }
        }
        return val;
    }

    static boolean isIntegerEquivalent(Object val) {
        if (val instanceof Number) {
            Number number = (Number)val;
            return Math.ceil(number.doubleValue()) == Math.floor(number.doubleValue());
        }
        if (val instanceof String) {
            try {
                double dval = Double.parseDouble((String)val);
                return Math.ceil(dval) == Math.floor(dval);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static Variable.Type getTagType(String name) {
        Variable.Type info = Variable.Type.get(name);
        if (info == null && name.startsWith("sysprop.")) {
            info = Variable.Type.SYSPROP;
        }
        if (info == null && name.startsWith("metrics:")) {
            info = Variable.Type.LAZY;
        }
        return info;
    }

    static Variable loadImpl(Variable.Meta meta, Variable.Type t) {
        Class<VariableBase> implementation = meta.implementation();
        if (implementation == Void.TYPE) {
            implementation = VariableBase.class;
        }
        try {
            return (Variable)implementation.getConstructor(Variable.Type.class).newInstance(t);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate: " + implementation.getName(), e);
        }
    }

    @Override
    public int compareViolation(Violation v1, Violation v2) {
        if (v2.replicaCountDelta == null || v1.replicaCountDelta == null) {
            return 0;
        }
        if (Math.abs(v1.replicaCountDelta) == Math.abs(v2.replicaCountDelta)) {
            return 0;
        }
        return Math.abs(v1.replicaCountDelta) < Math.abs(v2.replicaCountDelta) ? -1 : 1;
    }

    @Override
    public Object validate(String name, Object val, boolean isRuleVal) {
        Number num;
        Condition condition;
        if (val instanceof Condition && (val = condition.op.readRuleValue(condition = (Condition)val)) != condition.val) {
            return val;
        }
        if (!isRuleVal && "".equals(val) && this.varType.type != String.class) {
            val = -1;
        }
        if (name == null) {
            name = this.varType.tagName;
        }
        if (this.varType.type == Double.class) {
            num = Clause.parseDouble(name, val);
            if (isRuleVal) {
                if (this.varType.min != null && Double.compare((Double)num, this.varType.min.doubleValue()) == -1) {
                    throw new RuntimeException(String.valueOf(name) + ": " + val + " must be greater than " + this.varType.min);
                }
                if (this.varType.max != null && Double.compare((Double)num, this.varType.max.doubleValue()) == 1) {
                    throw new RuntimeException(String.valueOf(name) + ": " + val + " must be less than " + this.varType.max);
                }
            }
            return num;
        }
        if (this.varType.type == Long.class) {
            num = Clause.parseLong(name, val);
            if (isRuleVal) {
                if (this.varType.min != null && (Long)num < this.varType.min.longValue()) {
                    throw new RuntimeException(String.valueOf(name) + ": " + val + " must be greater than " + this.varType.min);
                }
                if (this.varType.max != null && (Long)num > this.varType.max.longValue()) {
                    throw new RuntimeException(String.valueOf(name) + ": " + val + " must be less than " + this.varType.max);
                }
            }
            return num;
        }
        if (this.varType.type == String.class) {
            if (isRuleVal && !this.varType.vals.isEmpty() && !this.varType.vals.contains(val)) {
                throw new RuntimeException(String.valueOf(name) + ": " + val + " must be one of " + StrUtils.join(this.varType.vals, ','));
            }
            return val;
        }
        throw new RuntimeException("Invalid type ");
    }

    public static class CoreIndexSizeVariable
    extends VariableBase {
        public CoreIndexSizeVariable(Variable.Type type) {
            super(type);
        }

        @Override
        public Object convertVal(Object val) {
            return Variable.Type.FREEDISK.convertVal(val);
        }
    }

    public static class DiskTypeVariable
    extends VariableBase {
        public DiskTypeVariable(Variable.Type type) {
            super(type);
        }

        @Override
        public void getSuggestions(Suggestion.Ctx ctx) {
            Suggestion.suggestPositiveViolations(ctx);
        }
    }

    public static class LazyVariable
    extends VariableBase {
        public LazyVariable(Variable.Type type) {
            super(type);
        }

        @Override
        public Object validate(String name, Object val, boolean isRuleVal) {
            return Clause.parseString(val);
        }

        @Override
        public boolean match(Object inputVal, Operand op, Object val, String name, Row row) {
            return op.match(Clause.parseString(val), Clause.parseString(inputVal)) == Clause.TestStatus.PASS;
        }

        @Override
        public void getSuggestions(Suggestion.Ctx ctx) {
            Suggestion.suggestPositiveViolations(ctx);
        }
    }

    public static class TotalDiskVariable
    extends VariableBase {
        public TotalDiskVariable(Variable.Type type) {
            super(type);
        }

        @Override
        public Object convertVal(Object val) {
            return Variable.Type.FREEDISK.convertVal(val);
        }
    }
}

