/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.NodeStateProvider;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.Cell;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Row
implements MapWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public final String node;
    final Cell[] cells;
    public Map<String, Map<String, List<ReplicaInfo>>> collectionVsShardVsReplicas;
    boolean anyValueMissing = false;
    boolean isLive = true;
    Policy.Session session;
    Map globalCache;
    Map perCollCache;
    public static final Map<String, CacheEntry> cacheStats = new HashMap<String, CacheEntry>();
    boolean isAlreadyCopied = false;

    public Row(String node, List<Pair<String, Variable.Type>> params, List<String> perReplicaAttributes, Policy.Session session) {
        this(node, params, perReplicaAttributes, session, session.nodeStateProvider, session.cloudManager);
    }

    Row(String node, List<Pair<String, Variable.Type>> params, List<String> perReplicaAttributes, Policy.Session session, NodeStateProvider nsp, SolrCloudManager cloudManager) {
        this.session = session;
        this.collectionVsShardVsReplicas = nsp.getReplicaInfo(node, perReplicaAttributes);
        if (this.collectionVsShardVsReplicas == null) {
            this.collectionVsShardVsReplicas = new HashMap<String, Map<String, List<ReplicaInfo>>>();
        }
        this.node = node;
        this.cells = new Cell[params.size()];
        this.isLive = cloudManager.getClusterStateProvider().getLiveNodes().contains(node);
        List<String> paramNames = params.stream().map(Pair::first).collect(Collectors.toList());
        Map vals = this.isLive ? nsp.getNodeValues(node, paramNames) : Collections.emptyMap();
        int i = 0;
        while (i < params.size()) {
            Pair<String, Variable.Type> pair = params.get(i);
            this.cells[i] = new Cell(i, pair.first(), Clause.validate(pair.first(), vals.get(pair.first()), false), null, pair.second(), this);
            if ("node".equals(pair.first())) {
                this.cells[i].val = node;
            }
            if (this.cells[i].val == null) {
                this.anyValueMissing = true;
            }
            ++i;
        }
        this.globalCache = new HashMap();
        this.perCollCache = new HashMap();
        this.isAlreadyCopied = true;
    }

    public void forEachShard(String collection, BiConsumer<String, List<ReplicaInfo>> consumer) {
        this.collectionVsShardVsReplicas.getOrDefault(collection, Collections.emptyMap()).forEach(consumer);
    }

    public <R> R computeCacheIfAbsent(String cacheName, Function<Object, R> supplier) {
        Object result = this.globalCache.get(cacheName);
        if (result != null) {
            assert (CacheEntry.hit(cacheName));
            return (R)result;
        }
        assert (CacheEntry.miss(cacheName));
        result = supplier.apply(cacheName);
        this.globalCache.put(cacheName, result);
        return (R)result;
    }

    public <R> R computeCacheIfAbsent(String coll, String shard, String cacheName, Object key, Function<Object, R> supplier) {
        Object result;
        HashMap<Object, R> cacheNameMap;
        HashMap shardMap;
        HashMap collMap = (HashMap)this.perCollCache.get(coll);
        if (collMap == null) {
            collMap = new HashMap();
            this.perCollCache.put(coll, collMap);
        }
        if ((shardMap = (HashMap)collMap.get(shard)) == null) {
            shardMap = new HashMap();
            collMap.put(shard, shardMap);
        }
        if ((cacheNameMap = (HashMap<Object, R>)shardMap.get(cacheName)) == null) {
            cacheNameMap = new HashMap<Object, R>();
            shardMap.put(cacheName, cacheNameMap);
        }
        if ((result = cacheNameMap.get(key)) == null) {
            CacheEntry.miss(cacheName);
            result = supplier.apply(key);
            cacheNameMap.put(key, result);
            return (R)result;
        }
        CacheEntry.hit(cacheName);
        return (R)result;
    }

    public Row(String node, Cell[] cells, boolean anyValueMissing, Map<String, Map<String, List<ReplicaInfo>>> collectionVsShardVsReplicas, boolean isLive, Policy.Session session, Map perRowCache, Map globalCache) {
        this.session = session;
        this.node = node;
        this.isLive = isLive;
        this.cells = new Cell[cells.length];
        int i = 0;
        while (i < this.cells.length) {
            this.cells[i] = cells[i].copy();
            this.cells[i].row = this;
            ++i;
        }
        this.anyValueMissing = anyValueMissing;
        this.collectionVsShardVsReplicas = collectionVsShardVsReplicas;
        this.perCollCache = perRowCache;
        this.globalCache = globalCache;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put((CharSequence)"node", this.node);
        ew.put((CharSequence)"replicas", this.collectionVsShardVsReplicas);
        ew.put((CharSequence)"isLive", this.isLive);
        ew.put((CharSequence)"attributes", Arrays.asList(this.cells));
    }

    Row copy() {
        return new Row(this.node, this.cells, this.anyValueMissing, this.collectionVsShardVsReplicas, this.isLive, this.session, this.globalCache, this.perCollCache);
    }

    Object getVal(String name) {
        if ("node".equals(name)) {
            return this.node;
        }
        Cell[] cellArray = this.cells;
        int n = this.cells.length;
        int n2 = 0;
        while (n2 < n) {
            Cell cell = cellArray[n2];
            if (cell.name.equals(name)) {
                return cell.val;
            }
            ++n2;
        }
        return null;
    }

    public Object getVal(String name, Object def) {
        Cell[] cellArray = this.cells;
        int n = this.cells.length;
        int n2 = 0;
        while (n2 < n) {
            Cell cell = cellArray[n2];
            if (cell.name.equals(name)) {
                return cell.val == null ? def : cell.val;
            }
            ++n2;
        }
        return def;
    }

    public String toString() {
        return this.jsonStr();
    }

    public Row addReplica(String coll, String shard, Replica.Type type) {
        return this.addReplica(coll, shard, type, 0, true);
    }

    public Row addReplica(String coll, String shard, Replica.Type type, boolean strictMode) {
        return this.addReplica(coll, shard, type, 0, strictMode);
    }

    Row addReplica(String coll, String shard, Replica.Type type, int recursionCount, boolean strictMode) {
        if (recursionCount > 3) {
            log.error("more than 3 levels of recursion ", (Throwable)new RuntimeException());
            return this;
        }
        this.lazyCopyReplicas(coll, shard);
        LinkedList furtherOps = new LinkedList();
        Consumer<OperationInfo> opCollector = it -> {
            boolean bl = furtherOps.add(it);
        };
        Row row = null;
        row = this.session.copy().getNode(this.node);
        if (row == null) {
            throw new RuntimeException("couldn't get a row");
        }
        row.lazyCopyReplicas(coll, shard);
        Map c = row.collectionVsShardVsReplicas.computeIfAbsent(coll, k -> new HashMap());
        List replicas = c.computeIfAbsent(shard, k -> new ArrayList());
        String replicaname = "SYNTHETIC." + new Random().nextInt(1000) + 1000;
        ReplicaInfo ri = new ReplicaInfo(replicaname, replicaname, coll, shard, type, this.node, Utils.makeMap("type", type != null ? type.toString() : Replica.Type.NRT.toString()));
        replicas.add(ri);
        Cell[] cellArray = row.cells;
        int n = row.cells.length;
        int n2 = 0;
        while (n2 < n) {
            Cell cell = cellArray[n2];
            cell.type.projectAddReplica(cell, ri, opCollector, strictMode);
            ++n2;
        }
        for (OperationInfo op : furtherOps) {
            if (op.isAdd) {
                row = row.session.getNode(op.node).addReplica(op.coll, op.shard, op.type, recursionCount + 1, strictMode);
                continue;
            }
            row.session.getNode(op.node).removeReplica(op.coll, op.shard, op.type, recursionCount + 1);
        }
        return row;
    }

    private void lazyCopyReplicas(String coll, String shard) {
        this.globalCache = new HashMap();
        HashMap cacheCopy = new HashMap(this.perCollCache);
        cacheCopy.remove(coll);
        this.perCollCache = cacheCopy;
        if (this.isAlreadyCopied) {
            return;
        }
        HashMap<String, Map<String, List<ReplicaInfo>>> replicasCopy = new HashMap<String, Map<String, List<ReplicaInfo>>>(this.collectionVsShardVsReplicas);
        Map oneColl = (Map)replicasCopy.get(coll);
        if (oneColl != null) {
            replicasCopy.put(coll, Utils.getDeepCopy(oneColl, 2));
        }
        this.collectionVsShardVsReplicas = replicasCopy;
        this.isAlreadyCopied = true;
    }

    boolean hasColl(String coll) {
        return this.collectionVsShardVsReplicas.containsKey(coll);
    }

    public void createCollShard(Pair<String, String> collShard) {
        Map shardInfo = this.collectionVsShardVsReplicas.computeIfAbsent(collShard.first(), o -> new HashMap());
        if (collShard.second() != null) {
            shardInfo.computeIfAbsent(collShard.second(), o -> new ArrayList());
        }
    }

    public ReplicaInfo getReplica(String coll, String shard, Replica.Type type) {
        Map<String, List<ReplicaInfo>> c = this.collectionVsShardVsReplicas.get(coll);
        if (c == null) {
            return null;
        }
        List<ReplicaInfo> r = c.get(shard);
        if (r == null) {
            return null;
        }
        int idx = -1;
        int i = 0;
        while (i < r.size()) {
            ReplicaInfo info = r.get(i);
            if (type == null || info.getType() == type) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx == -1) {
            return null;
        }
        return r.get(idx);
    }

    public Row removeReplica(String coll, String shard, Replica.Type type) {
        return this.removeReplica(coll, shard, type, 0);
    }

    public Row removeReplica(String coll, String shard, Replica.Type type, int recursionCount) {
        if (recursionCount > 3) {
            log.error("more than 3 levels of recursion ", (Throwable)new RuntimeException());
            return this;
        }
        LinkedList furtherOps = new LinkedList();
        Consumer<OperationInfo> opCollector = it -> {
            boolean bl = furtherOps.add(it);
        };
        Row row = this.session.copy().getNode(this.node);
        row.lazyCopyReplicas(coll, shard);
        Map<String, List<ReplicaInfo>> c = row.collectionVsShardVsReplicas.get(coll);
        if (c == null) {
            return null;
        }
        List<ReplicaInfo> r = c.get(shard);
        if (r == null) {
            return null;
        }
        int idx = -1;
        int i = 0;
        while (i < r.size()) {
            ReplicaInfo info = r.get(i);
            if (type == null || info.getType() == type) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx == -1) {
            return null;
        }
        ReplicaInfo removed = r.remove(idx);
        Cell[] cellArray = row.cells;
        int n = row.cells.length;
        int n2 = 0;
        while (n2 < n) {
            Cell cell = cellArray[n2];
            cell.type.projectRemoveReplica(cell, removed, opCollector);
            ++n2;
        }
        return row;
    }

    public Cell[] getCells() {
        return this.cells;
    }

    public boolean isLive() {
        return this.isLive;
    }

    public void forEachReplica(Consumer<ReplicaInfo> consumer) {
        Row.forEachReplica(this.collectionVsShardVsReplicas, consumer);
    }

    public void forEachReplica(String coll, Consumer<ReplicaInfo> consumer) {
        this.collectionVsShardVsReplicas.getOrDefault(coll, Collections.emptyMap()).forEach((shard, replicaInfos) -> {
            for (ReplicaInfo replicaInfo : replicaInfos) {
                consumer.accept(replicaInfo);
            }
        });
    }

    public static void forEachReplica(Map<String, Map<String, List<ReplicaInfo>>> collectionVsShardVsReplicas, Consumer<ReplicaInfo> consumer) {
        collectionVsShardVsReplicas.forEach((coll, shardVsReplicas) -> shardVsReplicas.forEach((shard, replicaInfos) -> {
            int i = 0;
            while (i < replicaInfos.size()) {
                ReplicaInfo r = (ReplicaInfo)replicaInfos.get(i);
                consumer.accept(r);
                ++i;
            }
        }));
    }

    static class CacheEntry
    implements MapWriter {
        AtomicLong hits = new AtomicLong();
        AtomicLong misses = new AtomicLong();

        CacheEntry() {
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.put((CharSequence)"hits", this.hits.get());
            ew.put((CharSequence)"misses", this.misses.get());
        }

        public static boolean hit(String cacheName) {
            return true;
        }

        private static CacheEntry getCacheEntry(String cacheName) {
            CacheEntry cacheEntry = cacheStats.get(cacheName);
            if (cacheEntry == null) {
                cacheEntry = new CacheEntry();
                cacheStats.put(cacheName, cacheEntry);
            }
            return cacheEntry;
        }

        public static boolean miss(String cacheName) {
            CacheEntry.getCacheEntry((String)cacheName).misses.incrementAndGet();
            return true;
        }
    }

    static class OperationInfo {
        final String coll;
        final String shard;
        final String node;
        final String cellName;
        final boolean isAdd;
        final Replica.Type type;

        OperationInfo(String coll, String shard, String node, String cellName, boolean isAdd, Replica.Type type) {
            this.coll = coll;
            this.shard = shard;
            this.node = node;
            this.cellName = cellName;
            this.isAdd = isAdd;
            this.type = type;
        }
    }
}

