/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.List;
import java.util.Objects;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.Condition;
import org.apache.solr.client.solrj.cloud.autoscaling.RangeVal;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Operand {
    WILDCARD("#ANY", Integer.MAX_VALUE){

        @Override
        public Clause.TestStatus match(Object ruleVal, Object testVal) {
            return testVal == null ? Clause.TestStatus.NOT_APPLICABLE : Clause.TestStatus.PASS;
        }
    }
    ,
    RANGE_EQUAL("", 0){

        @Override
        public Clause.TestStatus match(Object ruleVal, Object testVal) {
            return ((RangeVal)ruleVal).match((Number)testVal) ? Clause.TestStatus.PASS : Clause.TestStatus.FAIL;
        }

        @Override
        public Double delta(Object expected, Object actual) {
            return ((RangeVal)expected).delta(((Number)actual).doubleValue());
        }

        @Override
        public Object readRuleValue(Condition condition) {
            String strVal;
            int hyphenIdx;
            if (condition.val instanceof String && (hyphenIdx = (strVal = ((String)condition.val).trim()).indexOf(45)) > 0) {
                String minS = strVal.substring(0, hyphenIdx).trim();
                String maxS = strVal.substring(hyphenIdx + 1, strVal.length()).trim();
                return new RangeVal((Number)condition.varType.validate(condition.name, minS, true), (Number)condition.varType.validate(condition.name, maxS, true), null);
            }
            Number num = (Number)condition.varType.validate(condition.name, condition.val, true);
            return new RangeVal(Math.floor(num.doubleValue()), Math.ceil(num.doubleValue()), num);
        }
    }
    ,
    EQUAL("", 0){

        @Override
        public double _delta(double expected, double actual) {
            return actual - expected;
        }
    }
    ,
    IN("", 0){

        @Override
        public Clause.TestStatus match(Object ruleVal, Object testVal) {
            List l = (List)ruleVal;
            return l.contains(testVal) ? Clause.TestStatus.PASS : Clause.TestStatus.FAIL;
        }
    }
    ,
    RANGE_NOT_EQUAL("", 2){

        @Override
        public Clause.TestStatus match(Object ruleVal, Object testVal) {
            return ((RangeVal)ruleVal).match((Number)testVal) ? Clause.TestStatus.FAIL : Clause.TestStatus.PASS;
        }

        @Override
        public Object readRuleValue(Condition condition) {
            return RANGE_EQUAL.readRuleValue(condition);
        }
    }
    ,
    NOT_EQUAL("!", 2){

        @Override
        public Clause.TestStatus match(Object ruleVal, Object testVal) {
            if (testVal == null) {
                return Clause.TestStatus.PASS;
            }
            return super.match(ruleVal, testVal) == Clause.TestStatus.PASS ? Clause.TestStatus.FAIL : Clause.TestStatus.PASS;
        }

        @Override
        public double _delta(double expected, double actual) {
            return expected - actual;
        }
    }
    ,
    GREATER_THAN(">", 1){

        @Override
        public Clause.TestStatus match(Object ruleVal, Object testVal) {
            if (testVal == null) {
                return Clause.TestStatus.NOT_APPLICABLE;
            }
            if (ruleVal instanceof String) {
                ruleVal = Clause.parseDouble("", ruleVal);
            }
            if (ruleVal instanceof Double) {
                return Double.compare(Clause.parseDouble("", testVal), (Double)ruleVal) == -1 ? Clause.TestStatus.FAIL : Clause.TestStatus.PASS;
            }
            return this.getLong(testVal) > this.getLong(ruleVal) ? Clause.TestStatus.PASS : Clause.TestStatus.FAIL;
        }

        @Override
        public String wrap(Object val) {
            return ">" + (((Number)val).doubleValue() - 1.0);
        }

        @Override
        public Operand opposite(boolean flag) {
            return flag ? LESS_THAN : GREATER_THAN;
        }

        @Override
        protected double _delta(double expected, double actual) {
            return actual > expected ? 0.0 : expected - actual;
        }
    }
    ,
    LESS_THAN("<", 2){

        @Override
        public Clause.TestStatus match(Object ruleVal, Object testVal) {
            if (testVal == null) {
                return Clause.TestStatus.NOT_APPLICABLE;
            }
            if (ruleVal instanceof String) {
                ruleVal = Clause.parseDouble("", ruleVal);
            }
            if (ruleVal instanceof Double) {
                return Double.compare(Clause.parseDouble("", testVal), (Double)ruleVal) == 1 ? Clause.TestStatus.FAIL : Clause.TestStatus.PASS;
            }
            return this.getLong(testVal) < this.getLong(ruleVal) ? Clause.TestStatus.PASS : Clause.TestStatus.FAIL;
        }

        @Override
        public String wrap(Object val) {
            return "<" + (((Number)val).doubleValue() + 1.0);
        }

        @Override
        protected double _delta(double expected, double actual) {
            return actual < expected ? 0.0 : actual - expected;
        }

        @Override
        public Operand opposite(boolean flag) {
            return flag ? GREATER_THAN : this;
        }
    };

    public final String operand;
    final int priority;

    public Operand opposite(boolean flag) {
        return this;
    }

    private Operand(String val, int priority) {
        this.operand = val;
        this.priority = priority;
    }

    public Clause.TestStatus match(Object ruleVal, Object testVal) {
        return Objects.equals(ruleVal, testVal) ? Clause.TestStatus.PASS : Clause.TestStatus.FAIL;
    }

    Long getLong(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return Long.parseLong(String.valueOf(o));
    }

    public Double delta(Object expected, Object actual) {
        if (expected instanceof Number && actual instanceof Number) {
            Double expectedL = ((Number)expected).doubleValue();
            Double actualL = ((Number)actual).doubleValue();
            return this._delta(expectedL, actualL);
        }
        return 0.0;
    }

    protected double _delta(double expected, double actual) {
        return 0.0;
    }

    public String wrap(Object val) {
        return String.valueOf(this.operand) + val.toString();
    }

    public Object readRuleValue(Condition condition) {
        return condition.val;
    }
}

