/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggestion;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.VariableBase;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;

public class NodeVariable
extends VariableBase {
    public NodeVariable(Variable.Type type) {
        super(type);
    }

    @Override
    public void getSuggestions(Suggestion.Ctx ctx) {
        if (ctx.violation == null || ctx.violation.replicaCountDelta == 0.0) {
            return;
        }
        if (ctx.violation.replicaCountDelta > 0.0) {
            int i = 0;
            while ((double)i < Math.abs(ctx.violation.replicaCountDelta)) {
                Suggester suggester = ctx.session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).forceOperation(true).hint(Suggester.Hint.SRC_NODE, ctx.violation.node).hint(ctx.violation.shard.equals("#ANY") ? Suggester.Hint.COLL : Suggester.Hint.COLL_SHARD, ctx.violation.shard.equals("#ANY") ? ctx.violation.coll : new Pair<String, String>(ctx.violation.coll, ctx.violation.shard));
                if (ctx.addSuggestion(suggester) == null) break;
                ++i;
            }
        }
    }
}

