/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.lang.invoke.MethodHandles;
import java.util.Comparator;
import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveReplicaSuggester
extends Suggester {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static Comparator<Pair<ReplicaInfo, Row>> leaderLast = (r1, r2) -> {
        int leaderCompare = Boolean.compare(((ReplicaInfo)r1.first()).isLeader, ((ReplicaInfo)r2.first()).isLeader);
        if (leaderCompare != 0) {
            return leaderCompare;
        }
        return ((ReplicaInfo)r1.first()).getName().compareTo(((ReplicaInfo)r2.first()).getName());
    };

    @Override
    SolrRequest init() {
        SolrRequest operation = this.tryEachNode(true);
        if (operation == null) {
            operation = this.tryEachNode(false);
        }
        return operation;
    }

    SolrRequest tryEachNode(boolean strict) {
        List<Violation> leastSeriousViolation = null;
        Row bestSrcRow = null;
        Row bestTargetRow = null;
        ReplicaInfo sourceReplicaInfo = null;
        List<Pair<ReplicaInfo, Row>> validReplicas = this.getValidReplicas(true, true, -1);
        validReplicas.sort(leaderLast);
        int i1 = 0;
        while (i1 < validReplicas.size()) {
            this.lastBestDeviation = null;
            Pair<ReplicaInfo, Row> fromReplica = validReplicas.get(i1);
            Row fromRow = fromReplica.second();
            ReplicaInfo ri = fromReplica.first();
            if (ri != null) {
                int i = this.session.indexOf(fromRow.node);
                int stopAt = this.force ? 0 : i;
                Row targetRow = null;
                int j = this.session.matrix.size() - 1;
                while (j >= stopAt) {
                    targetRow = this.session.matrix.get(j);
                    if (!targetRow.node.equals(fromRow.node) && this.isNodeSuitableForReplicaAddition(targetRow, fromRow)) {
                        targetRow = targetRow.addReplica(ri.getCollection(), ri.getShard(), ri.getType(), strict);
                        Row srcRowModified = targetRow.session.getNode(fromRow.node).removeReplica(ri.getCollection(), ri.getShard(), ri.getType());
                        List<Violation> errs = this.testChangedMatrix(strict, srcRowModified.session);
                        Policy.Session tmpSession = srcRowModified.session;
                        if (!this.containsNewErrors(errs) && this.isLessSerious(errs, leastSeriousViolation) && (this.force || tmpSession.indexOf(srcRowModified.node) < tmpSession.indexOf(targetRow.node))) {
                            int result = -1;
                            if (!this.force && srcRowModified.isLive && targetRow.isLive && (result = tmpSession.getPolicy().getClusterPreferences().get(0).compare(srcRowModified, tmpSession.getNode(targetRow.node), true)) == 0) {
                                result = tmpSession.getPolicy().getClusterPreferences().get(0).compare(srcRowModified, tmpSession.getNode(targetRow.node), false);
                            }
                            if (result <= 0) {
                                leastSeriousViolation = errs;
                                bestSrcRow = srcRowModified;
                                sourceReplicaInfo = ri;
                                bestTargetRow = targetRow;
                            }
                        }
                    }
                    --j;
                }
            }
            ++i1;
        }
        if (bestSrcRow != null) {
            this.session = bestSrcRow.session;
            return new CollectionAdminRequest.MoveReplica(sourceReplicaInfo.getCollection(), sourceReplicaInfo.getName(), bestTargetRow.node);
        }
        return null;
    }

    @Override
    public CollectionParams.CollectionAction getAction() {
        return CollectionParams.CollectionAction.MOVEREPLICA;
    }
}

