/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.Condition;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ComputedType {
    NULL,
    EQUAL{

        @Override
        public String wrap(String value) {
            return "#EQUAL";
        }

        @Override
        public String match(String val) {
            if ("#EQUAL".equals(val)) {
                return "1";
            }
            return null;
        }
    }
    ,
    ALL{

        @Override
        public String wrap(String value) {
            return "#ALL";
        }

        @Override
        public String match(String val) {
            if ("#ALL".equals(val)) {
                return "1";
            }
            return null;
        }
    }
    ,
    PERCENT{

        @Override
        public String wrap(String value) {
            return String.valueOf(value) + "%";
        }

        @Override
        public String match(String val) {
            if (val != null && !val.isEmpty() && val.charAt(val.length() - 1) == '%') {
                double d;
                String newVal = val.substring(0, val.length() - 1);
                try {
                    d = Double.parseDouble(newVal);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid percentage value : " + val);
                }
                if (d < 0.0 || d > 100.0) {
                    throw new IllegalArgumentException("Percentage value must lie between [1 -100] : provided value : " + val);
                }
                return newVal;
            }
            return null;
        }

        @Override
        public Object compute(Object val, Condition c) {
            if (val == null || Clause.parseDouble(c.name, val) == 0.0) {
                return 0.0;
            }
            return Clause.parseDouble(c.name, val) * Clause.parseDouble(c.name, c.val) / 100.0;
        }

        public String toString() {
            return "%";
        }
    };


    public String match(String val) {
        return null;
    }

    public String wrap(String value) {
        return value;
    }

    public Object compute(Object val, Condition c) {
        return val;
    }
}

