/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.autoscaling.ComputedType;
import org.apache.solr.client.solrj.cloud.autoscaling.Condition;
import org.apache.solr.client.solrj.cloud.autoscaling.Operand;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.Preference;
import org.apache.solr.client.solrj.cloud.autoscaling.RangeVal;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaCount;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.SealedClause;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.VariableBase;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;

public class Clause
implements MapWriter,
Comparable<Clause> {
    public static final String NODESET = "nodeset";
    static final Set<String> IGNORE_TAGS = new HashSet<String>(Arrays.asList("replica", "collection", "shard", "strict", "type", "put", "nodeset"));
    private final int hashCode;
    final boolean hasComputedValue;
    final Map<String, Object> original;
    final Clause derivedFrom;
    boolean nodeSetPresent = false;
    Condition collection;
    Condition shard;
    Condition replica;
    Condition tag;
    Condition globalTag;
    final Replica.Type type;
    Put put;
    boolean strict;
    public static long addReplicaCountsForNode = 0L;
    public static long addReplicaCountsForNodeCacheMiss = 0L;
    public static final String PERSHARD_REPLICAS = String.valueOf(Clause.class.getSimpleName()) + ".perShardReplicas";
    public static final String METRICS_PREFIX = "metrics:";

    protected Clause(Clause clause, Function<Condition, Object> computedValueEvaluator) {
        this.original = clause.original;
        this.hashCode = this.original.hashCode();
        this.type = clause.type;
        this.put = clause.put;
        this.nodeSetPresent = clause.nodeSetPresent;
        this.collection = clause.collection;
        this.shard = clause.shard;
        this.tag = this.evaluateValue(clause.tag, computedValueEvaluator);
        this.replica = this.evaluateValue(clause.replica, computedValueEvaluator);
        this.globalTag = this.evaluateValue(clause.globalTag, computedValueEvaluator);
        this.hasComputedValue = clause.hasComputedValue;
        this.strict = clause.strict;
        this.derivedFrom = clause.derivedFrom;
    }

    Clause(Map<String, Object> original, Condition tag, Condition globalTag, boolean isStrict, Put put, boolean nodeSetPresent) {
        this.hashCode = original.hashCode();
        this.original = original;
        this.tag = tag;
        this.globalTag = globalTag;
        this.globalTag.clause = this;
        this.type = null;
        this.hasComputedValue = false;
        this.strict = isStrict;
        this.derivedFrom = null;
        this.put = put;
        this.nodeSetPresent = nodeSetPresent;
    }

    private Clause(Map<String, Object> m) {
        List<String> ss;
        this.derivedFrom = (Clause)m.remove(Clause.class.getName());
        this.original = Utils.getDeepCopy(m, 10);
        this.hashCode = this.original.hashCode();
        String type = (String)m.get("type");
        this.type = type == null || "#ANY".equals(type) ? null : Replica.Type.valueOf(type.toUpperCase(Locale.ROOT));
        String put = (String)m.getOrDefault("put", m.containsKey(NODESET) ? Put.ON_ALL.val : null);
        if (put != null) {
            this.put = Put.get(put);
            if (this.put == null) {
                Clause.throwExp(m, "invalid value for put : {0}", put);
            }
        }
        this.strict = Boolean.parseBoolean(String.valueOf(m.getOrDefault("strict", "true")));
        Optional<String> globalTagName = m.keySet().stream().filter(Policy.GLOBAL_ONLY_TAGS::contains).findFirst();
        if (globalTagName.isPresent()) {
            if (!(m.size() <= 2 || m.containsKey("strict") && m.size() <= 3)) {
                throw new RuntimeException("Only, 'strict' and one extra tag supported for the tag " + globalTagName.get() + " in " + Utils.toJSONString(m));
            }
            this.globalTag = this.parse(globalTagName.get(), m);
            this.tag = this.parse(m.keySet().stream().filter(s -> !((String)globalTagName.get()).equals(s) && !IGNORE_TAGS.contains(s)).findFirst().get(), m);
        } else {
            this.collection = this.parse("collection", m);
            this.shard = this.parse("shard", m);
            if (m.get("replica") == null) {
                throw new IllegalArgumentException(StrUtils.formatString("'replica' is required in {0}", Utils.toJSONString(m)));
            }
            this.replica = this.parse("replica", m);
            if (this.replica.op == Operand.WILDCARD) {
                throw new IllegalArgumentException("replica val cannot be null" + Utils.toJSONString(m));
            }
            this.nodeSetPresent = this.parseNodeset(m);
            m.forEach((s, o) -> this.parseCondition((String)s, o, m));
        }
        if (this.tag == null) {
            throw new RuntimeException("Invalid op, must have one and only one tag other than collection, shard,replica " + Utils.toJSONString(m));
        }
        if (this.tag.name.startsWith(METRICS_PREFIX) && ((ss = StrUtils.splitSmart(this.tag.name, ':')).size() < 3 || ss.size() > 4)) {
            throw new RuntimeException("Invalid metrics: param in " + Utils.toJSONString(m) + " must have at 2 or 3 segments after 'metrics:' separated by ':'");
        }
        this.doPostValidate(this.collection, this.shard, this.replica, this.tag, this.globalTag);
        this.hasComputedValue = this.hasComputedValue();
    }

    private boolean parseNodeset(Map<String, Object> m) {
        if (!m.containsKey(NODESET)) {
            return false;
        }
        Object o = m.get(NODESET);
        if (o instanceof Map) {
            String key = this.validateObjectInNodeset(m, (Map)o);
            this.parseCondition(key, o, m);
        } else if (o instanceof List) {
            List l = (List)o;
            if (l.size() < 2) {
                Clause.throwExp(m, "nodeset [] must have atleast 2 items", new Object[0]);
            }
            if (this.checkMapArray(l, m)) {
                return true;
            }
            for (Object it : l) {
                if (it instanceof String) continue;
                Clause.throwExp(m, "nodeset :[]must have only string values", new Object[0]);
            }
            this.parseCondition("node", o, m);
        } else {
            Clause.throwExp(m, "invalid value for nodeset, must be an object or a list of String", new Object[0]);
        }
        return true;
    }

    private String validateObjectInNodeset(Map<String, Object> m, Map map) {
        String key;
        Object val;
        if (map.size() != 1) {
            Clause.throwExp(m, "nodeset must only have one and only one key", new Object[0]);
        }
        if ((val = map.get(key = (String)map.keySet().iterator().next())) instanceof String && ((String)val).trim().charAt(0) == '#') {
            Clause.throwExp(m, StrUtils.formatString("computed  value {0} not allowed in nodeset", val), new Object[0]);
        }
        return key;
    }

    private boolean checkMapArray(List l, Map<String, Object> m) {
        ArrayList<Map> maps = null;
        for (Object o : l) {
            if (!(o instanceof Map)) continue;
            if (maps == null) {
                maps = new ArrayList<Map>();
            }
            maps.add((Map)o);
        }
        String key = null;
        if (maps != null) {
            if (maps.size() != l.size()) {
                Clause.throwExp(m, "all elements of nodeset must be Objects", new Object[0]);
            }
            ArrayList<Condition> tags = new ArrayList<Condition>(maps.size());
            for (Map map : maps) {
                String s = this.validateObjectInNodeset(m, map);
                if (key == null) {
                    key = s;
                }
                if (!Objects.equals(key, s)) {
                    Clause.throwExp(m, "all element must have same key", new Object[0]);
                }
                tags.add(this.parse(s, m));
            }
            if (this.put == Put.ON_EACH) {
                Clause.throwExp(m, "cannot use put: ''on-each-node''  with an array value in nodeset ", new Object[0]);
            }
            this.tag = new Condition(key, tags, Operand.IN, null, this);
            return true;
        }
        return false;
    }

    public Condition getThirdTag() {
        return this.globalTag == null ? this.tag : this.globalTag;
    }

    private void doPostValidate(Condition ... conditions) {
        Condition[] conditionArray = conditions;
        int n = conditions.length;
        int n2 = 0;
        while (n2 < n) {
            String err;
            Condition condition = conditionArray[n2];
            if (condition != null && (err = condition.varType.postValidate(condition)) != null) {
                throw new IllegalArgumentException(StrUtils.formatString("Error in clause : {0}, caused by : {1}", Utils.toJSONString(this.original), err));
            }
            ++n2;
        }
    }

    public static Clause create(String json) {
        return Clause.create((Map)Utils.fromJSONString(json));
    }

    public static Clause create(Map<String, Object> m) {
        Clause clause = new Clause(m);
        return clause.hasComputedValue() ? clause : clause.getSealedClause(null);
    }

    public static String parseString(Object val) {
        if (val instanceof Condition) {
            val = ((Condition)val).val;
        }
        return val == null ? null : String.valueOf(val);
    }

    public Condition getCollection() {
        return this.collection;
    }

    public Condition getShard() {
        return this.shard;
    }

    public Condition getReplica() {
        return this.replica;
    }

    public Condition getTag() {
        return this.tag;
    }

    public Condition getGlobalTag() {
        return this.globalTag;
    }

    Condition evaluateValue(Condition condition, Function<Condition, Object> computedValueEvaluator) {
        if (condition == null) {
            return null;
        }
        if (condition.computedType == null) {
            return condition;
        }
        Object val = computedValueEvaluator.apply(condition);
        val = condition.op.readRuleValue(new Condition(condition.name, val, condition.op, null, null));
        return new Condition(condition.name, val, condition.op, null, this);
    }

    public boolean doesOverride(Clause that) {
        return this.collection.equals(that.collection) && this.tag.name.equals(that.tag.name);
    }

    public boolean isPerCollectiontag() {
        return this.globalTag == null;
    }

    void parseCondition(String s, Object o, Map m) {
        if (IGNORE_TAGS.contains(s)) {
            return;
        }
        if (this.tag != null) {
            Clause.throwExp(m, "Only one tag other than collection, shard, replica is possible", new Object[0]);
        }
        this.tag = this.parse(s, o instanceof Map ? (Map<String, Object>)o : Collections.singletonMap(s, o));
    }

    private int compareTypes(Replica.Type t1, Replica.Type t2) {
        if (t1 == null && t2 == null) {
            return 0;
        }
        if (t1 != null && t2 == null) {
            return -1;
        }
        if (t1 == null) {
            return 1;
        }
        return 0;
    }

    private boolean hasComputedValue() {
        if (this.replica != null && this.replica.computedType != null) {
            return true;
        }
        if (this.tag != null && this.tag.computedType != null) {
            return true;
        }
        return this.globalTag != null && this.globalTag.computedType != null;
    }

    @Override
    public int compareTo(Clause that) {
        int v = Integer.compare(this.tag.op.priority, that.tag.op.priority);
        if (v != 0) {
            return v;
        }
        if (this.isPerCollectiontag() && that.isPerCollectiontag()) {
            v = Integer.compare(this.replica.op.priority, that.replica.op.priority);
            if (v == 0) {
                Double thisVal = this.replica.val instanceof RangeVal ? ((RangeVal)this.replica.val).max.doubleValue() : ((Double)this.replica.val).doubleValue();
                Double thatVal = that.replica.val instanceof RangeVal ? ((RangeVal)that.replica.val).max.doubleValue() : ((Double)that.replica.val).doubleValue();
                v = Preference.compareWithTolerance(thisVal, thatVal, 1.0f);
                int n = v = this.replica.op == Operand.LESS_THAN ? v : v * -1;
            }
            if (v == 0) {
                v = this.compareTypes(this.type, that.type);
            }
            return v;
        }
        return 0;
    }

    void addTags(Collection<String> params) {
        if (this.globalTag != null && !params.contains(this.globalTag.name)) {
            params.add(this.globalTag.name);
        }
        if (this.tag != null && !params.contains(this.tag.name)) {
            params.add(this.tag.name);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Clause)) {
            return false;
        }
        Clause that = (Clause)o;
        return Objects.equals(this.original, that.original);
    }

    boolean isReplicaZero() {
        return this.replica != null && this.replica.getOperand() == Operand.EQUAL && this.replica.val instanceof Double && Preference.compareWithTolerance(0.0, (Double)this.replica.val, 1.0f) == 0;
    }

    public SealedClause getSealedClause(Function<Condition, Object> computedValueEvaluator) {
        return this instanceof SealedClause ? (SealedClause)this : new SealedClause(this, computedValueEvaluator);
    }

    Condition parse(String s, Map<String, Object> m) {
        Object expectedVal = null;
        ComputedType computedType = null;
        Object val = m.get(s);
        Variable.Type varType = VariableBase.getTagType(s);
        if (varType.meta.isHidden()) {
            Clause.throwExp(m, "''{0}'' is not allowed", varType.tagName);
        }
        try {
            String conditionName = s.trim();
            Operand operand = null;
            if (val == null) {
                operand = Operand.WILDCARD;
                expectedVal = "#ANY";
            } else if (val instanceof List) {
                if (!varType.meta.supportArrayVals()) {
                    Clause.throwExp(m, "array values are not supported for {0}", conditionName);
                }
                expectedVal = Clause.readListVal(m, (List)val, varType, conditionName);
                operand = Operand.IN;
            } else if (val instanceof String) {
                String strVal = ((String)val).trim();
                val = strVal;
                operand = Clause.getOperand(strVal);
                strVal = strVal.substring(Operand.EQUAL == operand || Operand.WILDCARD == operand ? 0 : 1);
                ComputedType[] computedTypeArray = ComputedType.values();
                int n = computedTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ComputedType t = computedTypeArray[n2];
                    String changedVal = t.match(strVal);
                    if (changedVal != null) {
                        computedType = t;
                        strVal = changedVal;
                        if (varType == null || !varType.supportedComputedTypes.contains((Object)computedType)) {
                            Clause.throwExp(m, "''{0}'' is not allowed for variable :  ''{1}''", new Object[]{t, conditionName});
                        }
                    }
                    ++n2;
                }
                if (computedType == null && ((String)val).charAt(0) == '#' && !varType.wildCards.contains(val)) {
                    Clause.throwExp(m, "''{0}'' is not an allowed value for ''{1}'', supported value is : {2} ", val, conditionName, varType.wildCards);
                }
                operand = varType == null ? operand : varType.getOperand(operand, strVal, computedType);
                expectedVal = Clause.validate(s, new Condition(s, strVal, operand, computedType, null), true);
            } else if (val instanceof Number) {
                operand = Operand.EQUAL;
                operand = varType.getOperand(operand, val, null);
                expectedVal = Clause.validate(s, new Condition(s, val, operand, null, null), true);
            }
            return new Condition(conditionName, expectedVal, operand, computedType, this);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            Clause.throwExp(m, " Invalid tag : {0} " + e.getMessage(), s);
            return null;
        }
    }

    public static void throwExp(Map clause, String msg, Object ... args) {
        throw new IllegalArgumentException("syntax error in clause :" + Utils.toJSONString(clause) + " , msg:  " + StrUtils.formatString(msg, args));
    }

    private static List readListVal(Map m, List val, Variable.Type varType, String conditionName) {
        List list = val;
        if ((list = list.stream().map(it -> varType.validate(conditionName, it, true)).map(it -> {
            if (it instanceof String) {
                String trim = ((String)it).trim();
                if (trim.isEmpty()) {
                    throw new IllegalArgumentException(StrUtils.formatString("{0} cannot have an empty string value in clause : {1}", conditionName, Utils.toJSONString(m)));
                }
                return trim;
            }
            return it;
        }).filter(it -> it != null).collect(Collectors.toList())).isEmpty()) {
            throw new IllegalArgumentException(StrUtils.formatString("{0} cannot have an empty list value in clause : {1}", conditionName, Utils.toJSONString(m)));
        }
        for (Object o : list) {
            if (!(o instanceof String) || Clause.getOperand((String)o) == Operand.EQUAL) continue;
            throw new IllegalArgumentException(StrUtils.formatString("No operators are supported in collection values in condition : {0} in clause : {1}", conditionName, Utils.toJSONString(m)));
        }
        if (list.size() < 2) {
            throw new IllegalArgumentException(StrUtils.formatString("Array should have more than one value in  condition : {0} in clause : {1}", conditionName, Utils.toJSONString(m)));
        }
        return list;
    }

    private static Operand getOperand(String strVal) {
        Operand operand = "#ANY".equals(strVal) || "#EACH".equals(strVal) ? Operand.WILDCARD : (strVal.startsWith(Operand.NOT_EQUAL.operand) ? Operand.NOT_EQUAL : (strVal.startsWith(Operand.GREATER_THAN.operand) ? Operand.GREATER_THAN : (strVal.startsWith(Operand.LESS_THAN.operand) ? Operand.LESS_THAN : Operand.EQUAL)));
        return operand;
    }

    private boolean isRowPass(ComputedValueEvaluator eval, Object t, Row row) {
        eval.node = row.node;
        if (t instanceof Condition) {
            Condition tag = (Condition)t;
            if (tag.computedType != null) {
                tag = this.evaluateValue(tag, eval);
            }
            return tag.isPass(row);
        }
        return t.equals(row.getVal(this.tag.name));
    }

    List<Violation> testGroupNodes(Policy.Session session, double[] deviations) {
        ComputedValueEvaluator eval = new ComputedValueEvaluator(session);
        eval.collName = (String)this.collection.getValue();
        Violation.Ctx ctx = new Violation.Ctx(this, session.matrix, eval);
        Set tags = this.getUniqueTags(session, eval);
        if (tags.isEmpty()) {
            return Collections.emptyList();
        }
        Set<String> shards = this.getShardNames(session, eval);
        for (String s : shards) {
            ReplicaCount replicaCount = new ReplicaCount();
            eval.shardName = s;
            for (Object tag : tags) {
                replicaCount.reset();
                for (Row row : session.matrix) {
                    if (!this.isRowPass(eval, tag, row)) continue;
                    this.addReplicaCountsForNode(eval, replicaCount, row);
                }
                SealedClause sealedClause = this.getSealedClause(eval);
                if (!sealedClause.replica.isPass(replicaCount)) {
                    ReplicaCount replicaCountCopy = replicaCount.copy();
                    Violation violation = new Violation(sealedClause, eval.collName, eval.shardName, null, replicaCountCopy, sealedClause.getReplica().replicaCountDelta(replicaCountCopy), tag);
                    ctx.resetAndAddViolation(tag, replicaCountCopy, violation);
                    sealedClause.addViolatingReplicasForGroup(sealedClause.tag, eval, ctx, this.tag.name, tag, violation, session.matrix);
                    if (this.strict || deviations == null) continue;
                    this.tag.varType.computeDeviation(session, deviations, replicaCount, sealedClause);
                    continue;
                }
                if (this.replica.op != Operand.RANGE_EQUAL) continue;
                this.tag.varType.computeDeviation(session, deviations, replicaCount, sealedClause);
            }
        }
        return ctx.allViolations;
    }

    private Set getUniqueTags(Policy.Session session, ComputedValueEvaluator eval) {
        HashSet<Object> tags = new HashSet<Object>();
        if (this.nodeSetPresent) {
            if (this.tag.val instanceof List && ((List)this.tag.val).get(0) instanceof Condition) {
                tags.addAll((List)this.tag.val);
            } else {
                tags.add(this.tag);
            }
            return tags;
        }
        if (this.tag.op == Operand.WILDCARD) {
            for (Row row : session.matrix) {
                Object val;
                eval.node = row.node;
                Condition tag = this.tag;
                if (tag.computedType != null) {
                    tag = this.evaluateValue(tag, eval);
                }
                if ((val = row.getVal(tag.name)) == null) continue;
                if (tag.op == Operand.LESS_THAN || tag.op == Operand.GREATER_THAN) {
                    tags.add(this.tag);
                    continue;
                }
                if (!tag.isPass(val)) continue;
                tags.add(val);
            }
        } else if (this.tag.op == Operand.LESS_THAN || this.tag.op == Operand.GREATER_THAN || this.tag.op == Operand.RANGE_EQUAL || this.tag.op == Operand.NOT_EQUAL) {
            tags.add(this.tag);
        } else if (this.tag.val instanceof Collection) {
            tags.add(this.tag);
        } else {
            tags.add(this.tag.val);
        }
        return tags;
    }

    void addViolatingReplicasForGroup(Condition tag, ComputedValueEvaluator eval, Violation.Ctx ctx, String tagName, Object tagVal, Violation violation, List<Row> nodes) {
        if (tag.varType.addViolatingReplicas(ctx)) {
            return;
        }
        for (Row row : nodes) {
            boolean isPass;
            if (tagVal instanceof Condition) {
                Condition condition = (Condition)tagVal;
                if (condition.computedType != null) {
                    eval.node = row.node;
                    Object val = eval.apply(condition);
                    condition = new Condition(condition.name, val, condition.op, null, condition.clause);
                }
                isPass = condition.isPass(row);
            } else {
                isPass = tagVal.equals(row.getVal(tagName));
            }
            if (!isPass) continue;
            row.forEachReplica(eval.collName, ri -> {
                if ("#ANY".equals(computedValueEvaluator.shardName) || computedValueEvaluator.shardName.equals(ri.getShard())) {
                    violation.addReplica(new Violation.ReplicaInfoAndErr((ReplicaInfo)ri).withDelta(tag.delta(row.getVal(condition.name))));
                }
            });
        }
    }

    private void addReplicaCountsForNode(ComputedValueEvaluator computedValueEvaluator, ReplicaCount replicaCount, Row node) {
        ++addReplicaCountsForNode;
        ReplicaCount rc = node.computeCacheIfAbsent(computedValueEvaluator.collName, computedValueEvaluator.shardName, PERSHARD_REPLICAS, this, o -> {
            ++addReplicaCountsForNodeCacheMiss;
            ReplicaCount result = new ReplicaCount();
            node.forEachReplica((String)this.collection.getValue(), ri -> {
                if ("#ANY".equals(computedValueEvaluator.shardName) || computedValueEvaluator.shardName.equals(ri.getShard())) {
                    result.increment((ReplicaInfo)ri);
                }
            });
            return result;
        });
        if (rc != null) {
            replicaCount.increment(rc);
        }
    }

    List<Violation> testPerNode(Policy.Session session, double[] deviations) {
        ComputedValueEvaluator eval = new ComputedValueEvaluator(session);
        eval.collName = (String)this.collection.getValue();
        Violation.Ctx ctx = new Violation.Ctx(this, session.matrix, eval);
        Set<String> shards = this.getShardNames(session, eval);
        for (String s : shards) {
            ReplicaCount replicaCount = new ReplicaCount();
            eval.shardName = s;
            for (Row row : session.matrix) {
                replicaCount.reset();
                eval.node = row.node;
                Condition tag = this.tag;
                if (tag.computedType != null) {
                    tag = this.evaluateValue(tag, eval);
                }
                if (!tag.isPass(row)) continue;
                this.addReplicaCountsForNode(eval, replicaCount, row);
                SealedClause sealedClause = this.getSealedClause(eval);
                if (!sealedClause.replica.isPass(replicaCount)) {
                    ReplicaCount replicaCountCopy = replicaCount.copy();
                    Violation violation = new Violation(sealedClause, eval.collName, eval.shardName, eval.node, replicaCountCopy, sealedClause.getReplica().replicaCountDelta(replicaCountCopy), eval.node);
                    ctx.resetAndAddViolation(row.node, replicaCountCopy, violation);
                    sealedClause.addViolatingReplicasForGroup(sealedClause.tag, eval, ctx, "node", row.node, violation, Collections.singletonList(row));
                    if (this.strict || deviations == null) continue;
                    tag.varType.computeDeviation(session, deviations, replicaCount, sealedClause);
                    continue;
                }
                if (this.replica.op != Operand.RANGE_EQUAL) continue;
                tag.varType.computeDeviation(session, deviations, replicaCount, sealedClause);
            }
        }
        return ctx.allViolations;
    }

    private Set<String> getShardNames(Policy.Session session, ComputedValueEvaluator eval) {
        HashSet<String> shards = new HashSet<String>();
        if (this.isShardAbsent()) {
            shards.add("#ANY");
        } else {
            for (Row row : session.matrix) {
                row.forEachShard(eval.collName, (shard, r) -> {
                    if (this.shard.isPass(shard)) {
                        shards.add((String)shard);
                    }
                });
            }
        }
        return shards;
    }

    boolean isShardAbsent() {
        return "#ANY".equals(this.shard.val);
    }

    public List<Violation> test(Policy.Session session, double[] deviations) {
        if (this.isPerCollectiontag()) {
            if (this.nodeSetPresent) {
                if (this.put == Put.ON_EACH) {
                    return this.testPerNode(session, deviations);
                }
                return this.testGroupNodes(session, deviations);
            }
            return this.tag.varType == Variable.Type.NODE || this.tag.varType.meta.isNodeSpecificVal() && this.replica.computedType == null ? this.testPerNode(session, deviations) : this.testGroupNodes(session, deviations);
        }
        ComputedValueEvaluator computedValueEvaluator = new ComputedValueEvaluator(session);
        Violation.Ctx ctx = new Violation.Ctx(this, session.matrix, computedValueEvaluator);
        for (Row r : session.matrix) {
            computedValueEvaluator.node = r.node;
            SealedClause sealedClause = this.getSealedClause(computedValueEvaluator);
            if (!r.isLive() || sealedClause.getGlobalTag().isPass(r)) continue;
            ctx.resetAndAddViolation(r.node, null, new Violation(sealedClause, null, null, r.node, r.getVal(sealedClause.globalTag.name), sealedClause.globalTag.delta(r.getVal(this.globalTag.name)), r.node));
            this.addViolatingReplicasForGroup(sealedClause.globalTag, computedValueEvaluator, ctx, Variable.Type.CORES.tagName, r.node, ctx.currentViolation, session.matrix);
        }
        return ctx.allViolations;
    }

    public boolean isMatch(ReplicaInfo r, String collection, String shard) {
        if (this.type != null && r.getType() != this.type) {
            return false;
        }
        if (r.getCollection().equals(collection)) {
            if (this.shard == null || this.shard.val.equals("#ANY")) {
                return true;
            }
            if (this.shard.val.equals("#EACH") && r.getShard().equals(shard)) {
                return true;
            }
            return this.shard.val.equals(r.getShard()) && r.getShard().equals(shard);
        }
        return false;
    }

    boolean matchShard(String replicaShard, String shardInContext) {
        if (this.shard == null || this.shard.val.equals("#ANY")) {
            return true;
        }
        if (this.shard.val.equals("#EACH") && replicaShard.equals(shardInContext)) {
            return true;
        }
        return this.shard.val.equals(replicaShard);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public String toString() {
        return Utils.toJSONString(this.original);
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        for (Map.Entry<String, Object> e : this.original.entrySet()) {
            ew.put((CharSequence)e.getKey(), e.getValue());
        }
    }

    public static Object validate(String name, Object val, boolean isRuleVal) {
        if (val == null) {
            return null;
        }
        Variable.Type info = VariableBase.getTagType(name);
        if (info == null) {
            throw new RuntimeException("Unknown type :" + name);
        }
        return info.validate(name, val, isRuleVal);
    }

    public static Long parseLong(String name, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        Number num = null;
        if (val instanceof String) {
            try {
                num = Long.parseLong(((String)val).trim());
            }
            catch (NumberFormatException e) {
                try {
                    num = Double.parseDouble((String)val);
                }
                catch (NumberFormatException e1) {
                    throw new RuntimeException(String.valueOf(name) + ": " + val + "not a valid number", e);
                }
            }
        } else if (val instanceof Number) {
            num = (Number)val;
        }
        if (num != null) {
            return num.longValue();
        }
        throw new RuntimeException(String.valueOf(name) + ": " + val + "not a valid number");
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static Double parseDouble(String name, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof RangeVal) {
            val = ((RangeVal)val).actual;
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        Number num = null;
        if (val instanceof String) {
            try {
                num = Double.parseDouble((String)val);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(String.valueOf(name) + ": " + val + "not a valid number", e);
            }
        } else if (val instanceof Number) {
            num = (Number)val;
        }
        if (num != null) {
            return num.doubleValue();
        }
        throw new RuntimeException(String.valueOf(name) + ": " + val + "not a valid number");
    }

    public static class ComputedValueEvaluator
    implements Function<Condition, Object> {
        final Policy.Session session;
        String collName = null;
        String shardName = null;
        String node = null;

        public ComputedValueEvaluator(Policy.Session session) {
            this.session = session;
        }

        @Override
        public Object apply(Condition computedCondition) {
            return computedCondition.varType.computeValue(this.session, computedCondition, this.collName, this.shardName, this.node);
        }
    }

    static enum Put {
        ON_ALL(""),
        ON_EACH("on-each-node");

        public final String val;

        private Put(String s) {
            this.val = s;
        }

        public static Put get(String s) {
            Put[] putArray = Put.values();
            int n = putArray.length;
            int n2 = 0;
            while (n2 < n) {
                Put put = putArray[n2];
                if (put.val.equals(s)) {
                    return put;
                }
                ++n2;
            }
            return null;
        }
    }

    static enum TestStatus {
        NOT_APPLICABLE,
        FAIL,
        PASS;

    }
}

