/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.solr.client.solrj.cloud.autoscaling.AlreadyExistsException;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.BadVersionException;
import org.apache.solr.client.solrj.cloud.autoscaling.NotEmptyException;
import org.apache.solr.client.solrj.cloud.autoscaling.VersionedData;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;

public interface DistribStateManager
extends SolrCloseable {
    public boolean hasData(String var1) throws IOException, KeeperException, InterruptedException;

    public List<String> listData(String var1) throws NoSuchElementException, IOException, KeeperException, InterruptedException;

    public List<String> listData(String var1, Watcher var2) throws NoSuchElementException, IOException, KeeperException, InterruptedException;

    public VersionedData getData(String var1, Watcher var2) throws NoSuchElementException, IOException, KeeperException, InterruptedException;

    default public VersionedData getData(String path) throws NoSuchElementException, IOException, KeeperException, InterruptedException {
        return this.getData(path, null);
    }

    public void makePath(String var1) throws AlreadyExistsException, IOException, KeeperException, InterruptedException;

    public void makePath(String var1, byte[] var2, CreateMode var3, boolean var4) throws AlreadyExistsException, IOException, KeeperException, InterruptedException;

    public String createData(String var1, byte[] var2, CreateMode var3) throws AlreadyExistsException, IOException, KeeperException, InterruptedException;

    public void removeData(String var1, int var2) throws NoSuchElementException, IOException, NotEmptyException, KeeperException, InterruptedException, BadVersionException;

    public void setData(String var1, byte[] var2, int var3) throws BadVersionException, NoSuchElementException, IOException, KeeperException, InterruptedException;

    public List<OpResult> multi(Iterable<Op> var1) throws BadVersionException, NoSuchElementException, AlreadyExistsException, IOException, KeeperException, InterruptedException;

    public AutoScalingConfig getAutoScalingConfig(Watcher var1) throws InterruptedException, IOException;

    default public AutoScalingConfig getAutoScalingConfig() throws InterruptedException, IOException {
        return this.getAutoScalingConfig(null);
    }

    default public List<String> listTree(String root) throws NoSuchElementException, IOException, KeeperException, InterruptedException {
        String node;
        LinkedList<String> queue = new LinkedList<String>();
        ArrayList<String> tree = new ArrayList<String>();
        if (!root.startsWith("/")) {
            root = "/" + root;
        }
        queue.add(root);
        tree.add(root);
        while ((node = (String)queue.pollFirst()) != null) {
            List<String> children = this.listData(node);
            for (String child : children) {
                String childPath = String.valueOf(node) + (node.equals("/") ? "" : "/") + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }

    default public PerReplicaStates getReplicaStates(String path) throws KeeperException, InterruptedException {
        throw new UnsupportedOperationException("Not implemented");
    }

    default public void removeRecursively(String root, boolean ignoreMissing, boolean includeRoot) throws NoSuchElementException, IOException, NotEmptyException, KeeperException, InterruptedException, BadVersionException {
        List<String> tree;
        try {
            tree = this.listTree(root);
        }
        catch (NoSuchElementException e) {
            if (ignoreMissing) {
                return;
            }
            throw e;
        }
        Collections.reverse(tree);
        for (String p : tree) {
            if (p.equals("/") || p.equals(root) && !includeRoot) continue;
            try {
                this.removeData(p, -1);
            }
            catch (NoSuchElementException e) {
                if (ignoreMissing) continue;
                throw e;
            }
        }
    }
}

