package com.pdftools.pdfvalidator;

/**
 * The purpose of the PDF error class is to provide detailed information about the error, warning, or information reported by the PDF validator.
 */
public class PdfError
{
    /**
    * Returns the name of the (embedded) file in which the error occurred.
    */
    public native String getFileName();

    /**
    * Returns the latest error code.
    * @see com.pdftools.NativeLibrary.ERRORCODE
    */
    public native int getErrorCode();

    /**
    * Returns an explaining error message.
    */
    public native String getMessage();

	/**
	 * Returns the page number on which an error occurred. If the error is not
	 * related to a particular page number, 0 is returned.
	 */
    public native int getPageNo();

	/**
	 * Returns the object number at which the error occurs. If the error is not
	 * related to a particular object, 0 is returned.
	 */
    public native int getObjectNo();

    /**
    * Returns how many times the error occurs on the page.
    */
    public native int getCount();

    protected long _handle;
}
