/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.pluginstatistiken.config;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.Extensions;
import com.hilotec.elexis.pluginstatistiken.config.KonfigurationQuery;
import com.hilotec.elexis.pluginstatistiken.config.KonfigurationWhere;
import com.hilotec.elexis.pluginstatistiken.schnittstelle.IDatenquelle;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Konfiguration {
    public static final String STATISTIKEN_FILENAME = "statistiken.xml";
    public static final String ELEM_QUERY = "query";
    public static final String ELEM_FROM = "from";
    public static final String ELEM_COLS = "cols";
    public static final String ELEM_WHERE = "where";
    public static final String ELEM_JOIN = "join";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_SOURCE = "source";
    public static final String ATTR_TABLE = "table";
    public static final String ATTR_AS = "as";
    public static final String ATTR_TYPE = "type";
    public static final String DATASOURCE_EXT = "com.hilotec.elexis.pluginstatistiken.Datenquelle";
    Logger log = LoggerFactory.getLogger(this.getClass());
    ArrayList<KonfigurationQuery> queries = new ArrayList();
    HashMap<String, IDatenquelle> datenquellen = new HashMap();
    private static Konfiguration the_one_and_only_instance = null;

    public static Konfiguration getInstance() {
        if (the_one_and_only_instance == null) {
            the_one_and_only_instance = new Konfiguration();
        }
        return the_one_and_only_instance;
    }

    private Konfiguration() {
        this.datenquellenInitialisieren();
        this.readFromXML(CoreHub.getWritableUserDir() + File.separator + STATISTIKEN_FILENAME);
    }

    private void readFromXML(String path) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new FileInputStream(path));
            Element rootel = doc.getDocumentElement();
            NodeList ql = rootel.getElementsByTagName(ELEM_QUERY);
            int i = 0;
            while (i < ql.getLength()) {
                Node qn = ql.item(i);
                if (qn.getNodeType() == 1) {
                    Element qe = (Element)qn;
                    KonfigurationQuery kq = new KonfigurationQuery(qe.getAttribute(ATTR_TITLE));
                    Element frome = (Element)qe.getElementsByTagName(ELEM_FROM).item(0);
                    kq.setFrom(frome.getAttribute(ATTR_TABLE), frome.getAttribute(ATTR_AS));
                    NodeList jl = qe.getElementsByTagName(ELEM_JOIN);
                    int j = 0;
                    while (j < jl.getLength()) {
                        Element je = (Element)jl.item(j);
                        KonfigurationWhere where = null;
                        NodeList jchildren = je.getChildNodes();
                        int k = 0;
                        while (k < jchildren.getLength()) {
                            if (jchildren.item(k).getNodeType() == 1) {
                                where = new KonfigurationWhere((Element)jchildren.item(k));
                                break;
                            }
                            ++k;
                        }
                        kq.addJoin(new KonfigurationQuery.Join(je.getAttribute(ATTR_TABLE), je.getAttribute(ATTR_AS), where, KonfigurationQuery.Join.JType.JOIN_INNER));
                        ++j;
                    }
                    Element colse = (Element)qe.getElementsByTagName(ELEM_COLS).item(0);
                    NodeList wel = qe.getElementsByTagName(ELEM_WHERE);
                    Element wheree = wel == null || wel.getLength() == 0 ? null : (Element)wel.item(0);
                    NodeList colsList = colse.getChildNodes();
                    int j2 = 0;
                    while (j2 < colsList.getLength()) {
                        Node cn = colsList.item(j2);
                        if (cn.getNodeType() == 1) {
                            Element ce = (Element)cn;
                            kq.addCol(ce.getAttribute(ATTR_NAME), ce.getAttribute(ATTR_SOURCE));
                        }
                        ++j2;
                    }
                    if (wheree != null) {
                        Element whereOp = null;
                        NodeList wl = wheree.getChildNodes();
                        int j3 = 0;
                        while (j3 < wl.getLength()) {
                            if (wl.item(j3).getNodeType() == 1) {
                                whereOp = (Element)wl.item(j3);
                                break;
                            }
                            ++j3;
                        }
                        KonfigurationWhere where = new KonfigurationWhere(whereOp);
                        kq.setWhere(where);
                    }
                    this.queries.add(kq);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("Einlesen der XML-Datei felgeschlagen: " + e.getMessage());
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Hilotec Pluginstatistiken Fehler", (String)("Einlesen der XML-Datei felgeschlagen: " + e.getMessage()));
        }
    }

    private void datenquellenInitialisieren() {
        for (IConfigurationElement ic : Extensions.getExtensions((String)DATASOURCE_EXT)) {
            try {
                IDatenquelle dq = (IDatenquelle)ic.createExecutableExtension("class");
                this.datenquellen.put(dq.getName(), dq);
            }
            catch (CoreException ce) {
                this.log.error("Initialisieren der Datenquelle " + ic.getAttribute(ATTR_NAME) + " fehlgeschlagen: " + ce.getMessage());
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Hilotec Pluginstatistiken Fehler", (String)("Initialisieren der Datenquelle " + ic.getAttribute(ATTR_NAME) + " fehlgeschlagen: " + ce.getMessage()));
            }
        }
    }

    public List<KonfigurationQuery> getQueries() {
        return this.queries;
    }

    public IDatenquelle getDatenquelle(String name) {
        return this.datenquellen.get(name);
    }
}

