/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.messwerte.v2.views;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.PlatformHelper;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import com.equo.chromium.swt.Browser;
import com.hilotec.elexis.messwerte.v2.data.Messung;
import com.hilotec.elexis.messwerte.v2.data.MessungTyp;
import com.hilotec.elexis.messwerte.v2.data.Messwert;
import com.hilotec.elexis.messwerte.v2.data.MesswertBase;
import com.hilotec.elexis.messwerte.v2.data.Panel;
import com.hilotec.elexis.messwerte.v2.data.typen.IMesswertTyp;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypCalc;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypDate;
import com.hilotec.elexis.messwerte.v2.views.Messages;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class MessungBearbeiten
extends TitleAreaDialog {
    private final Messung messung;
    private List<Messwert> messwerte;
    private final List<Messwert> shownMesswerte;
    private final List<Messwert> calcFields;
    private DatePickerCombo dateWidget;
    private String tabtitle;
    private final Listener listener = new Listener(){

        public void handleEvent(Event event) {
            Boolean validValues = true;
            for (Messwert mw : MessungBearbeiten.this.shownMesswerte) {
                IMesswertTyp typ = mw.getTyp();
                if (typ.checkInput(mw, typ.getValidpattern())) continue;
                MessungBearbeiten.this.setErrorMessage(String.valueOf(typ.getTitle()) + ": " + typ.getInvalidmessage());
                validValues = false;
                break;
            }
            if (validValues.booleanValue()) {
                MessungBearbeiten.this.setErrorMessage(null);
                for (Messwert mw : MessungBearbeiten.this.calcFields) {
                    ((MesswertTypCalc)mw.getTyp()).calcNewValue(mw);
                }
            }
        }
    };

    public MessungBearbeiten(Shell parent, Messung m) {
        super(parent);
        this.messung = m;
        this.shownMesswerte = new ArrayList<Messwert>();
        this.calcFields = new ArrayList<Messwert>();
    }

    public MessungBearbeiten(Shell shell, Messung m, String text) {
        this(shell, m);
        this.tabtitle = text;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = null;
        Composite row = null;
        Label lbl = null;
        ScrolledComposite scroll = new ScrolledComposite(parent, 2816);
        scroll.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        comp = new Composite((Composite)scroll, 0);
        scroll.setContent((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        row = new Composite(comp, 0);
        row.setLayout((Layout)new RowLayout(256));
        Patient pat = ElexisEventDispatcher.getSelectedPatient();
        lbl = new Label(row, 0);
        lbl.setText(Messages.MessungBearbeiten_PatientLabel);
        lbl.setLayoutData((Object)new RowData(90, -1));
        lbl = new Label(row, 0);
        if (pat != null) {
            lbl.setText(String.valueOf(pat.getLabel()) + " (" + pat.getAlter() + ") - [" + pat.get("PatientNr").toString() + "]");
        } else {
            lbl.setText("Patient is null");
        }
        row = new Composite(comp, 0);
        row.setLayout((Layout)new RowLayout(256));
        lbl = new Label(row, 0);
        lbl.setText(Messages.MessungBearbeiten_MessungLabel);
        lbl.setLayoutData((Object)new RowData(90, -1));
        this.dateWidget = new DatePickerCombo(row, 0);
        this.dateWidget.setFormat((DateFormat)new SimpleDateFormat(MesswertTypDate.DATE_FORMAT));
        this.dateWidget.setDate(new TimeTool(this.messung.getDatum()).getTime());
        this.dateWidget.setLayoutData((Object)new RowData(60, -1));
        Label shadow_sep_h = new Label(comp, 266);
        shadow_sep_h.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.messwerte = this.messung.getMesswerte();
        MessungTyp typ = this.messung.getTyp();
        Panel p = typ.getPanel();
        if (p != null) {
            this.createCompositeWithLayout(typ.getPanel(), comp);
        } else {
            this.createCompositeWithoutLayout(comp);
        }
        comp.setSize(comp.computeSize(-1, -1));
        return scroll;
    }

    private Composite createCompositeWithoutLayout(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout());
        for (Messwert messwert : this.messung.getMesswerte()) {
            Label l = new Label(c, 0);
            IMesswertTyp dft = messwert.getTyp();
            String labelText = dft.getTitle();
            if (!dft.getUnit().equals("")) {
                labelText = String.valueOf(labelText) + " [" + dft.getUnit() + "]";
            }
            l.setText(labelText);
            dft.createWidget(c, messwert);
        }
        return c;
    }

    private Composite createCompositeWithLayout(Panel p, Composite parent) {
        String fieldref;
        Messwert mw;
        Composite c = new Composite(parent, 0);
        String panelType = "plain";
        if (p != null) {
            panelType = p.getType();
        }
        if (panelType.equals("plain")) {
            c.setLayout((Layout)new GridLayout());
        } else if (panelType.equals("display")) {
            String[] coord;
            String bounds;
            c.setLayout((Layout)new GridLayout());
            Browser browser = new Browser(c, 0);
            String url = p != null ? p.getAttribute("url") : null;
            browser.setUrl(url == null ? "" : url);
            GridData gd = SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true);
            String string = bounds = p != null ? p.getAttribute("size") : null;
            if (bounds != null && (coord = bounds.trim().split("\\s*,\\s*")).length == 2) {
                gd = new GridData(Integer.parseInt(coord[0]), Integer.parseInt(coord[1]));
                gd.grabExcessHorizontalSpace = true;
                gd.grabExcessVerticalSpace = true;
            }
            browser.setLayoutData((Object)gd);
        } else if (panelType.equals("label")) {
            c.setLayout((Layout)new GridLayout());
            Label l = new Label(c, 64);
            if (p != null) {
                l.setText(p.getAttribute("text"));
            }
        } else if (panelType.equals("grid")) {
            String cols;
            String string = cols = p != null ? p.getAttribute("columns") : null;
            if (cols == null) {
                c.setLayout((Layout)new GridLayout());
            } else {
                c.setLayout((Layout)new GridLayout(Integer.parseInt(cols), false));
            }
        } else if (panelType.equals("field") && (mw = this.getMesswert(fieldref = p != null ? p.getAttribute("ref") : null)) != null) {
            String invalidMsg;
            String validpattern;
            String attr;
            IMesswertTyp dft = mw.getTyp();
            boolean bEditable = true;
            String string = attr = p != null ? p.getAttribute("editable") : null;
            if (attr != null && attr.equals("false")) {
                bEditable = false;
            }
            dft.setEditable(bEditable);
            String string2 = validpattern = p != null ? p.getAttribute("validpattern") : null;
            if (validpattern == null) {
                validpattern = "[\u0000-\uffff]*";
            }
            dft.setValidpattern(validpattern);
            String string3 = invalidMsg = p != null ? p.getAttribute("invalidmessage") : null;
            if (invalidMsg == null) {
                invalidMsg = Messages.MessungBearbeiten_InvalidValue;
            }
            dft.setInvalidmessage(invalidMsg);
            c.setLayout((Layout)new GridLayout());
            String labelText = dft.getTitle();
            if (!dft.getUnit().equals("")) {
                labelText = String.valueOf(labelText) + " [" + dft.getUnit() + "]";
            }
            Composite labelRow = new Composite(c, 0);
            labelRow.setLayout((Layout)new GridLayout(2, false));
            labelRow.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            Label tl = new Label(labelRow, 0);
            tl.setText(labelText);
            tl.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false));
            Image image = new Image((Device)c.getDisplay(), String.valueOf(PlatformHelper.getBasePath((String)"com.hilotec.elexis.messwerte.v2")) + File.separator + "rsc" + File.separator + MesswertBase.ICON_TRANSPARENT);
            Label il = new Label(labelRow, 0);
            il.setImage(image);
            il.setLayoutData((Object)new GridData(131072, 4, true, true, 1, 1));
            mw.setIconLabel(il);
            Widget w = dft.createWidget(c, mw);
            if (dft instanceof MesswertTypCalc) {
                this.calcFields.add(mw);
            } else {
                w.addListener(13, this.listener);
                w.addListener(24, this.listener);
            }
            IMesswertTyp typ = mw.getTyp();
            typ.checkInput(mw, typ.getValidpattern());
            this.shownMesswerte.add(mw);
            this.setLayoutData(c);
        }
        if (p != null) {
            Panel[] panelArray = p.getPanels();
            int n = panelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Panel panel = panelArray[n2];
                this.setLayoutData(this.createCompositeWithLayout(panel, c));
                ++n2;
            }
        }
        return c;
    }

    private void setLayoutData(Composite c) {
        if (c.getParent().getLayout() instanceof GridLayout) {
            c.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        }
        c.pack();
    }

    public Messwert getMesswert(String name) {
        for (Messwert m : this.messwerte) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.MessungBearbeiten_EditMessung);
        String title = this.messung.getTyp().getTitle();
        String descr = this.messung.getTyp().getDescription();
        if (!"".equals(descr)) {
            title = String.valueOf(title) + ": " + descr;
        }
        this.setTitle(title);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.tabtitle);
        return contents;
    }

    public void okPressed() {
        boolean validValues = true;
        TimeTool tt = new TimeTool(this.dateWidget.getDate().getTime());
        this.messung.setDatum(tt.toString(4));
        for (Messwert mw : this.shownMesswerte) {
            IMesswertTyp typ = mw.getTyp();
            if (!typ.checkInput(mw, typ.getValidpattern())) {
                this.setErrorMessage(String.valueOf(typ.getTitle()) + ": " + typ.getInvalidmessage());
                validValues = false;
                break;
            }
            typ.saveInput(mw);
        }
        if (validValues) {
            this.messung.set("deleted", "0");
            this.close();
        }
    }

    public boolean close() {
        for (Messwert mw : this.shownMesswerte) {
            mw.getTyp().setShown(false);
        }
        return super.close();
    }

    protected boolean isResizable() {
        return true;
    }
}

