/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.messwerte.v2.data.typen;

import ch.elexis.core.ui.selectors.ActiveControl;
import ch.elexis.core.ui.selectors.SpinnerField;
import ch.elexis.core.ui.util.SWTHelper;
import com.hilotec.elexis.messwerte.v2.data.Messwert;
import com.hilotec.elexis.messwerte.v2.data.MesswertBase;
import com.hilotec.elexis.messwerte.v2.data.typen.IMesswertTyp;
import com.hilotec.elexis.messwerte.v2.data.typen.Messages;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class MesswertTypScale
extends MesswertBase
implements IMesswertTyp {
    int defVal = 0;
    int min = 0;
    int max = 0;

    public MesswertTypScale(String n, String t, String u) {
        super(n, t, u);
    }

    @Override
    public String erstelleDarstellungswert(Messwert messwert) {
        return messwert.getWert();
    }

    @Override
    public String getDefault(Messwert messwert) {
        Integer retVal = this.defVal;
        if (this.formula != null) {
            String sWert = this.evalateFormula(this.formula, messwert, retVal.toString());
            try {
                retVal = Integer.parseInt(sWert);
            }
            catch (Exception e) {
                this.log.log(MessageFormat.format(Messages.MesswertTypScale_CastFailure, sWert), 2);
            }
        }
        return retVal.toString();
    }

    @Override
    public void setDefault(String str) {
        this.defVal = Integer.parseInt(str);
    }

    public void setMax(int m) {
        this.max = m;
    }

    public void setMin(int m) {
        this.min = m;
    }

    @Override
    public Widget createWidget(Composite parent, Messwert messwert) {
        this.widget = new Spinner(parent, 0);
        ((Spinner)this.widget).setMinimum(this.min);
        ((Spinner)this.widget).setMaximum(this.max);
        ((Spinner)this.widget).setSelection(Integer.parseInt(messwert.getWert()));
        ((Spinner)this.widget).setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.setShown(true);
        return this.widget;
    }

    @Override
    public String getDarstellungswert(String wert) {
        return wert;
    }

    @Override
    public void saveInput(Messwert messwert) {
        messwert.setWert(Integer.toString(((Spinner)this.widget).getSelection()));
    }

    @Override
    public boolean checkInput(Messwert messwert, String pattern) {
        super.checkInput(messwert, pattern);
        String value = ((Spinner)this.widget).getText();
        return value.matches(pattern) || pattern == null;
    }

    @Override
    public ActiveControl createControl(Composite parent, Messwert messwert, boolean bEditable) {
        IMesswertTyp dft = messwert.getTyp();
        String labelText = dft.getTitle();
        if (!dft.getUnit().equals("")) {
            labelText = String.valueOf(labelText) + " [" + dft.getUnit() + "]";
        }
        SpinnerField sf = new SpinnerField(parent, 0, labelText, this.min, this.max);
        sf.setText(messwert.getDarstellungswert());
        return sf;
    }

    @Override
    public String getActualValue() {
        return ((Spinner)this.widget).getText();
    }
}

