/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview.medikarte;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.PersistentObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.TextView;
import ch.elexis.data.Artikel;
import ch.elexis.data.Brief;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import com.hilotec.elexis.kgview.data.FavMedikament;
import com.hilotec.elexis.kgview.medikarte.MedikarteEintragComparator;
import com.hilotec.elexis.kgview.medikarte.MedikarteEintragDialog;
import com.hilotec.elexis.kgview.medikarte.MedikarteHelpers;
import com.hilotec.elexis.kgview.medikarte.MedikarteStopDialog;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class MedikarteView
extends ViewPart
implements IRefreshable {
    public static final String ID = "com.hilotec.elexis.kgview.MedikarteView";
    private Table table;
    private boolean alle = false;
    private boolean geloescht = false;
    private boolean sortAlph = false;
    private Patient patient;
    private Action actEdit;
    private Action actStop;
    private Action actDelete;
    private Action actFilter;
    private Action actShowDel;
    private Action actDrucken;
    private Action actSortAlph;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    public void createPartControl(Composite parent) {
        this.table = new Table(parent, 66052);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        String[] ueberschriften = new String[]{"Ordnungszahl", "Medikament", "Mo", "Mi", "Ab", "Na", "Einh", "Zweck", "Einnahmevorschrift", "Von", "Bis"};
        int[] breiten = new int[]{30, 140, 40, 40, 40, 40, 40, 200, 70, 70, 70};
        int i = 0;
        while (i < breiten.length) {
            TableColumn tc = new TableColumn(this.table, 0);
            tc.setText(ueberschriften[i]);
            tc.setWidth(breiten[i]);
            ++i;
        }
        this.makeActions();
        new PersistentObjectDropTarget((Control)this.table, new PersistentObjectDropTarget.IReceiver(){

            public void dropped(PersistentObject o, DropTargetEvent e) {
                if (MedikarteView.this.patient == null) {
                    return;
                }
                FavMedikament fm = FavMedikament.load((Artikel)o);
                new MedikarteEintragDialog(MedikarteView.this.getSite().getShell(), MedikarteView.this.patient, fm).open();
                MedikarteView.this.refresh();
            }

            public boolean accept(PersistentObject o) {
                if (!(o instanceof Artikel) || MedikarteView.this.patient == null) {
                    return false;
                }
                return FavMedikament.load((Artikel)o) != null;
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                MedikarteView.this.actEdit.run();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode != 127) {
                    return;
                }
                MedikarteView.this.actStop.run();
            }
        });
        ViewMenus menus = new ViewMenus(this.getViewSite());
        menus.createToolbar(new IAction[]{this.actFilter, this.actShowDel, this.actDrucken, this.actSortAlph});
        menus.createControlContextMenu((Control)this.table, new IAction[]{this.actEdit, this.actStop, this.actDelete});
        this.patient = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
        this.refresh();
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    private void makeActions() {
        this.actEdit = new Action("Bearbeiten", 1){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
            }

            public void run() {
                TableItem[] sel = MedikarteView.this.table.getSelection();
                if (sel == null || sel.length != 1) {
                    return;
                }
                Prescription presc = (Prescription)sel[0].getData();
                new MedikarteEintragDialog(MedikarteView.this.getSite().getShell(), MedikarteView.this.patient, presc).open();
                MedikarteView.this.refresh();
            }
        };
        this.actStop = new Action("Stoppen", 1){
            {
                this.setImageDescriptor(Images.IMG_AUSRUFEZ_ROT.getImageDescriptor());
            }

            public void run() {
                TableItem[] tis = MedikarteView.this.table.getSelection();
                if (tis == null || tis.length != 1) {
                    return;
                }
                Prescription presc = (Prescription)tis[0].getData();
                if (presc.isDeleted() || !presc.getEndDate().equals("")) {
                    return;
                }
                new MedikarteStopDialog(MedikarteView.this.getSite().getShell(), presc).open();
                MedikarteView.this.refresh();
            }
        };
        this.actDelete = new Action("L\u00f6schen", 1){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            }

            public void run() {
                TableItem[] tis = MedikarteView.this.table.getSelection();
                if (tis == null || tis.length != 1) {
                    return;
                }
                Prescription presc = (Prescription)tis[0].getData();
                if (presc.isDeleted()) {
                    return;
                }
                if (!SWTHelper.askYesNo((String)"Verschreibung loeschen", (String)"Soll der markierte Eintrag wirklich permanent gel\u00f6scht werden?")) {
                    return;
                }
                presc.remove();
                MedikarteView.this.refresh();
            }
        };
        this.actFilter = new Action("Alle anzeigen", 2){
            {
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
                this.setChecked(true);
            }

            public void run() {
                MedikarteView.this.alle = !this.isChecked();
                MedikarteView.this.refresh();
            }
        };
        this.actShowDel = new Action("Gel\u00f6schte anzeigen", 2){
            {
                this.setImageDescriptor(Images.IMG_BOOK.getImageDescriptor());
            }

            public void run() {
                MedikarteView.this.geloescht = this.isChecked();
                MedikarteView.this.refresh();
            }
        };
        this.actDrucken = new Action("Drucken", 1){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
            }

            public void run() {
                TextView tv;
                Konsultation kons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
                Patient patient = ElexisEventDispatcher.getSelectedPatient();
                if (patient == null || kons == null) {
                    SWTHelper.alert((String)"Keine Konsultation ausgew\u00e4hlt", (String)"Eine Konsutlation muss ausgew\u00e4hlt sein in der die Medikamentenkarte erstellt werden soll.");
                    return;
                }
                try {
                    tv = (TextView)MedikarteView.this.getSite().getPage().showView("ch.elexis.TextView");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                    return;
                }
                Brief doc = tv.getTextContainer().createFromTemplateName(kons, "Medikarte", "Allg.", (Kontakt)patient, "Medikamentenkarte");
                tv.openDocument(doc);
            }
        };
        this.actSortAlph = new Action("Alphabetisch sortieren", 2){
            {
                this.setImageDescriptor(Images.IMG_ARROWDOWN.getImageDescriptor());
            }

            public void run() {
                MedikarteView.this.sortAlph = this.isChecked();
                MedikarteView.this.refresh();
            }
        };
    }

    private String fmtVolltext(String text) {
        return text.replaceAll("[\\n\\r]+", ", ");
    }

    public void refresh() {
        this.patient = (Patient)NoPoUtil.loadAsPersistentObject((Identifiable)ContextServiceHolder.get().getActivePatient().orElse(null));
        this.table.removeAll();
        if (this.patient == null) {
            return;
        }
        List<Prescription> l = MedikarteHelpers.medikarteMedikation(this.patient, this.alle, this.geloescht);
        MedikarteEintragComparator.Sortierung s = MedikarteEintragComparator.Sortierung.CHRONOLOGISCH;
        if (this.sortAlph) {
            s = MedikarteEintragComparator.Sortierung.ALPHABETISCH;
        }
        Collections.sort(l, new MedikarteEintragComparator(s));
        for (Prescription p : l) {
            FavMedikament fm = FavMedikament.load(p.getArtikel());
            String[] dosierung = p.getDosis().split("-");
            if (dosierung.length != 4 || fm == null) continue;
            TableItem ti = new TableItem(this.table, 0);
            ti.setData((Object)p);
            if (p.isDeleted()) {
                Color red = new Color((Device)Display.getCurrent(), 255, 0, 0);
                ti.setForeground(red);
            }
            int i = 0;
            int ord = MedikarteHelpers.getOrdnungszahl(p);
            ti.setText(i++, Integer.toString(ord));
            ti.setText(i++, fm.getBezeichnung());
            ti.setText(i++, dosierung[0]);
            ti.setText(i++, dosierung[1]);
            ti.setText(i++, dosierung[2]);
            ti.setText(i++, dosierung[3]);
            ti.setText(i++, fm.getEinheit());
            String z = MedikarteHelpers.getPZweck(p);
            ti.setText(i++, this.fmtVolltext(z));
            ti.setText(i++, p.getBemerkung());
            ti.setText(i++, p.getBeginDate());
            ti.setText(i++, p.getEndDate());
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    @Inject
    void activePatient(@Optional IPatient pat) {
        CoreUiUtil.runAsyncIfActive(() -> {
            this.patient = (Patient)NoPoUtil.loadAsPersistentObject((Identifiable)pat);
            this.refresh();
        }, (Object)this.table);
    }

    @Optional
    @Inject
    void crudPrescription(@UIEventTopic(value="info/elexis/model/*") IPrescription prescription) {
        CoreUiUtil.runAsyncIfActive(() -> this.refresh(), (Object)this.table);
    }
}

