/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview.diagnoseliste;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.core.ui.util.PersistentObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.icpc.model.icpc.IcpcCode;
import ch.rgw.tools.StringTool;
import com.hilotec.elexis.kgview.data.KonsData;
import com.hilotec.elexis.kgview.diagnoseliste.DLDialog;
import com.hilotec.elexis.kgview.diagnoseliste.DLParser;
import com.hilotec.elexis.kgview.diagnoseliste.DNode;
import com.hilotec.elexis.kgview.diagnoseliste.DiagnoseDialog;
import com.hilotec.elexis.kgview.diagnoseliste.DiagnoselisteItem;
import com.hilotec.elexis.kgview.diagnoseliste.MultilinePaintListener;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;

public abstract class DiagnoselisteBaseView
extends ViewPart
implements IRefreshable {
    protected final int typ;
    protected boolean canAdd = true;
    protected boolean canClear = false;
    protected boolean showDate = true;
    protected boolean allowImport = false;
    protected boolean allowImportDL = true;
    protected boolean allowImportCB = true;
    protected boolean allowICPC = true;
    private Tree tree;
    Action actAdd;
    Action actEdit;
    Action actAddChild;
    Action actDel;
    Action actDelICPC;
    Action actClear;
    Action actMoveUp;
    Action actMoveDown;
    Action actImportPA;
    Action actImportSA;
    Action actImportDL;
    Action actImportCB;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    public DiagnoselisteBaseView(int typ) {
        this.typ = typ;
    }

    private void setupTI(TreeItem ti, DiagnoselisteItem di) {
        String text = di.getText();
        if (this.showDate) {
            text = String.valueOf(text) + " (" + di.getDatum() + ")";
        }
        if (this.allowICPC) {
            text = "[" + di.getICPC() + "] " + text;
        }
        ti.setText(text);
        ti.setData((Object)di);
    }

    private TreeItem createTI(DiagnoselisteItem di, TreeItem tip, int index) {
        TreeItem ti = tip == null ? new TreeItem(this.tree, 0, index) : new TreeItem(tip, 0, index);
        this.setupTI(ti, di);
        return ti;
    }

    private void insertSubtree(DiagnoselisteItem dip, TreeItem tip) {
        for (DiagnoselisteItem di : dip.getChildren()) {
            TreeItem ti = this.createTI(di, tip, di.getPosition());
            this.insertSubtree(di, ti);
        }
    }

    private void updateTree() {
        this.updateTree(ElexisEventDispatcher.getSelectedPatient());
    }

    private void updateTree(Patient pat) {
        this.tree.removeAll();
        boolean en = pat != null;
        this.actAdd.setEnabled(en && this.canAdd);
        this.actAddChild.setEnabled(en && this.canAdd);
        this.actEdit.setEnabled(en);
        this.actDel.setEnabled(en);
        this.actDelICPC.setEnabled(en && this.allowICPC);
        this.actMoveUp.setEnabled(en);
        this.actMoveDown.setEnabled(en);
        this.actImportPA.setEnabled(en && this.allowImport);
        this.actImportSA.setEnabled(en && this.allowImport);
        this.actImportDL.setEnabled(en && this.allowImportDL);
        this.actImportCB.setEnabled(en && this.allowImportCB);
        this.actClear.setEnabled(en && this.canClear);
        if (pat == null) {
            return;
        }
        this.insertSubtree(DiagnoselisteItem.getRoot(pat, this.typ), null);
    }

    private static DiagnoselisteItem getRoot(int typ) {
        Patient pat = ElexisEventDispatcher.getSelectedPatient();
        return DiagnoselisteItem.getRoot(pat, typ);
    }

    public void createPartControl(Composite parent) {
        this.tree = new Tree(parent, 0);
        TreeEditor editor = new TreeEditor(this.tree);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        MultilinePaintListener mlListener = new MultilinePaintListener();
        this.tree.addListener(41, (Listener)mlListener);
        this.tree.addListener(42, (Listener)mlListener);
        this.tree.addListener(40, (Listener)mlListener);
        new PersistentObjectDropTarget((Control)this.tree, new PersistentObjectDropTarget.IReceiver(){

            public void dropped(PersistentObject o, DropTargetEvent e) {
                TreeItem selTi = DiagnoselisteBaseView.this.tree.getItem(DiagnoselisteBaseView.this.tree.toControl(e.x, e.y));
                DiagnoselisteItem it = null;
                it = selTi != null ? (DiagnoselisteItem)((Object)selTi.getData()) : DiagnoselisteBaseView.getRoot(DiagnoselisteBaseView.this.typ);
                if (o instanceof IcpcCode && selTi != null) {
                    IcpcCode i = (IcpcCode)o;
                    it.setICPC(i.getCode());
                    DiagnoselisteBaseView.this.setupTI(selTi, it);
                } else if (o instanceof KonsData) {
                    KonsData kd = (KonsData)o;
                    DiagnoselisteItem di = it.createChild();
                    di.setText(kd.getDiagnose());
                    di.setDatum(kd.getKonsultation().getDatum());
                    DiagnoselisteBaseView.this.createTI(di, selTi, di.getPosition());
                } else if (o instanceof DiagnoselisteItem) {
                    DiagnoselisteItem d = (DiagnoselisteItem)o;
                    if (d.getTyp() != DiagnoselisteBaseView.this.typ) {
                        DiagnoselisteBaseView.this.importItemTo(d, it);
                    } else {
                        DiagnoselisteItem par = d.getParent();
                        if (par == null) {
                            return;
                        }
                        if (it.isDescendantOf(d)) {
                            return;
                        }
                        par.removeChild(d);
                        if (!par.equals((Object)it)) {
                            d.setPosition(it.nextChildPos());
                            d.setParent(it);
                        }
                    }
                    DiagnoselisteBaseView.this.updateTree();
                }
            }

            public boolean accept(PersistentObject o) {
                if (o instanceof IcpcCode) {
                    return DiagnoselisteBaseView.this.allowICPC;
                }
                if (o instanceof KonsData) {
                    return true;
                }
                if (!(o instanceof DiagnoselisteItem)) {
                    return false;
                }
                DiagnoselisteItem d = (DiagnoselisteItem)o;
                int t = d.getTyp();
                if (t == 0 && DiagnoselisteBaseView.this.allowImportDL) {
                    return true;
                }
                if (DiagnoselisteBaseView.this.allowImport && (t == 1 || t == 2)) {
                    return true;
                }
                return DiagnoselisteBaseView.this.typ == t;
            }
        });
        new PersistentObjectDragSource((Control)this.tree, new PersistentObjectDragSource.ISelectionRenderer(){

            public List<PersistentObject> getSelection() {
                TreeItem[] tis = DiagnoselisteBaseView.this.tree.getSelection();
                if (tis == null) {
                    return null;
                }
                ArrayList<PersistentObject> res = new ArrayList<PersistentObject>(tis.length);
                TreeItem[] treeItemArray = tis;
                int n = tis.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem ti = treeItemArray[n2];
                    DiagnoselisteItem di = (DiagnoselisteItem)((Object)ti.getData());
                    res.add(di);
                    ++n2;
                }
                return res;
            }
        });
        this.makeActions();
        this.tree.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                DiagnoselisteBaseView.this.actEdit.run();
            }
        });
        this.tree.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode != 127) {
                    return;
                }
                if (DiagnoselisteBaseView.this.actDel.isEnabled()) {
                    DiagnoselisteBaseView.this.actDel.run();
                }
            }
        });
        ViewMenus menus = new ViewMenus(this.getViewSite());
        ArrayList<Action> m = new ArrayList<Action>(5);
        IAction[] a = new IAction[1];
        if (this.canAdd) {
            m.add(this.actAdd);
        }
        m.add(this.actMoveUp);
        m.add(this.actMoveDown);
        menus.createToolbar(m.toArray(a));
        m.clear();
        if (this.allowImport) {
            m.add(this.actImportPA);
        }
        if (this.allowImport) {
            m.add(this.actImportSA);
        }
        if (this.allowImportDL) {
            m.add(this.actImportDL);
        }
        if (this.allowImportCB) {
            m.add(this.actImportCB);
        }
        if (this.canClear) {
            m.add(this.actClear);
        }
        menus.createMenu(m.toArray(a));
        m.clear();
        if (this.canAdd) {
            m.add(this.actAddChild);
        }
        m.add(this.actDel);
        if (this.allowICPC) {
            m.add(this.actDelICPC);
        }
        menus.createControlContextMenu((Control)this.tree, m.toArray(a));
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
        this.updateTree();
    }

    private void importFrom(DiagnoselisteItem sp, DiagnoselisteItem dp) {
        for (DiagnoselisteItem si : sp.getChildren()) {
            this.importItemTo(si, dp);
        }
    }

    private void importItemTo(DiagnoselisteItem item, DiagnoselisteItem newParent) {
        DiagnoselisteItem di = newParent.getBySrc(item);
        if (di == null) {
            di = newParent.createChildFrom(item);
        }
        this.importFrom(item, di);
    }

    private void makeActions() {
        this.actEdit = new Action("Bearbeiten"){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
            }

            public void run() {
                if (DiagnoselisteBaseView.this.tree.getSelectionCount() == 0) {
                    return;
                }
                TreeItem ti = DiagnoselisteBaseView.this.tree.getSelection()[0];
                DiagnoselisteItem di = (DiagnoselisteItem)((Object)ti.getData());
                new DiagnoseDialog(DiagnoselisteBaseView.this.getSite().getShell(), di, DiagnoselisteBaseView.this.showDate, DiagnoselisteBaseView.this.allowICPC).open();
                DiagnoselisteBaseView.this.setupTI(ti, di);
            }
        };
        this.actAdd = new Action("Neue Kategorie"){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
            }

            public void run() {
                Patient p = ElexisEventDispatcher.getSelectedPatient();
                DiagnoselisteItem root = DiagnoselisteItem.getRoot(p, DiagnoselisteBaseView.this.typ);
                DiagnoselisteItem di = root.createChild();
                new DiagnoseDialog(DiagnoselisteBaseView.this.getSite().getShell(), di, DiagnoselisteBaseView.this.showDate, false).open();
                DiagnoselisteBaseView.this.createTI(di, null, di.getPosition());
            }
        };
        this.actAddChild = new Action("Neue Unterdiagnose"){
            {
                this.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
            }

            public void run() {
                TreeItem[] tis = DiagnoselisteBaseView.this.tree.getSelection();
                if (tis.length > 0) {
                    DiagnoselisteItem di = (DiagnoselisteItem)((Object)tis[0].getData());
                    DiagnoselisteItem ndi = di.createChild();
                    DiagnoseDialog dd = new DiagnoseDialog(DiagnoselisteBaseView.this.getSite().getShell(), ndi, DiagnoselisteBaseView.this.showDate, false);
                    if (dd.open() == 0) {
                        DiagnoselisteBaseView.this.createTI(ndi, tis[0], ndi.getPosition());
                        tis[0].setExpanded(true);
                    } else {
                        ndi.delete();
                    }
                }
            }
        };
        this.actDel = new Action("L\u00f6schen"){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            }

            public void run() {
                TreeItem[] tis = DiagnoselisteBaseView.this.tree.getSelection();
                if (tis.length > 0) {
                    DiagnoselisteItem di = (DiagnoselisteItem)((Object)tis[0].getData());
                    if (!di.getChildren().isEmpty()) {
                        SWTHelper.alert((String)"Es existieren noch Unterdiagnosen", (String)"Bitte zuerst alle Unterdiagnosen der zu l\u00f6schenden Diagnose entfernen.");
                        return;
                    }
                    if (!SWTHelper.askYesNo((String)"L\u00f6schen", (String)"Soll die ausgew\u00e4hlte Diagnose unwiderrufbar gel\u00f6scht werden?")) {
                        return;
                    }
                    di.delete();
                    tis[0].dispose();
                }
            }
        };
        this.actDelICPC = new Action("ICPC Code l\u00f6schen"){
            {
                this.setImageDescriptor(Images.IMG_REMOVEITEM.getImageDescriptor());
            }

            public void run() {
                TreeItem[] tis = DiagnoselisteBaseView.this.tree.getSelection();
                if (tis.length != 1) {
                    return;
                }
                DiagnoselisteItem di = (DiagnoselisteItem)((Object)tis[0].getData());
                if (StringTool.isNothing((Object)di.getICPC())) {
                    return;
                }
                di.setICPC("");
                DiagnoselisteBaseView.this.setupTI(tis[0], di);
            }
        };
        this.actClear = new Action("Alle L\u00f6schen"){

            public void run() {
                if (SWTHelper.askYesNo((String)"Alle Eintraege loeschen", (String)"Sollen alle Eintraege unweiderruflich gel\u00f6scht werden?")) {
                    Patient pat = ElexisEventDispatcher.getSelectedPatient();
                    DiagnoselisteItem.getRoot(pat, DiagnoselisteBaseView.this.typ).deleteChildren();
                    DiagnoselisteBaseView.this.updateTree();
                }
            }
        };
        this.actMoveUp = new Action("Hoch"){
            {
                this.setImageDescriptor(Images.IMG_ARROWUP.getImageDescriptor());
            }

            public void run() {
                TreeItem[] tis = DiagnoselisteBaseView.this.tree.getSelection();
                if (tis.length > 0) {
                    DiagnoselisteItem di = (DiagnoselisteItem)((Object)tis[0].getData());
                    di.moveUp();
                    TreeItem parent = tis[0].getParentItem();
                    tis[0].dispose();
                    TreeItem ti = DiagnoselisteBaseView.this.createTI(di, parent, di.getPosition());
                    DiagnoselisteBaseView.this.insertSubtree(di, ti);
                    DiagnoselisteBaseView.this.tree.select(ti);
                }
            }
        };
        this.actMoveDown = new Action("Runter"){
            {
                this.setImageDescriptor(Images.IMG_ARROWDOWN.getImageDescriptor());
            }

            public void run() {
                TreeItem[] tis = DiagnoselisteBaseView.this.tree.getSelection();
                if (tis.length > 0) {
                    DiagnoselisteItem di = (DiagnoselisteItem)((Object)tis[0].getData());
                    di.moveDown();
                    TreeItem parent = tis[0].getParentItem();
                    tis[0].dispose();
                    TreeItem ti = DiagnoselisteBaseView.this.createTI(di, parent, di.getPosition());
                    DiagnoselisteBaseView.this.insertSubtree(di, ti);
                    DiagnoselisteBaseView.this.tree.select(ti);
                }
            }
        };
        this.actImportPA = new ImportAction(1);
        this.actImportSA = new ImportAction(2);
        this.actImportDL = new ImportAction(0);
        this.actImportCB = new Action("Import Zwischenablage"){
            {
                this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
                this.setToolTipText("Aus Zwischenablage importieren");
                this.setDescription("Sollen die Diagnosen wie unten angegeben importiert werden?");
            }

            public void run() {
                Clipboard cb = new Clipboard(UiDesk.getDisplay());
                String s = (String)cb.getContents((Transfer)HTMLTransfer.getInstance());
                if (s == null) {
                    return;
                }
                Patient p = ElexisEventDispatcher.getSelectedPatient();
                DiagnoselisteItem root = DiagnoselisteItem.getRoot(p, DiagnoselisteBaseView.this.typ);
                DNode dn = new DLParser().parse(s);
                if (dn == null) {
                    return;
                }
                DLDialog di = new DLDialog(UiDesk.getTopShell(), dn);
                if (di.open() == 0) {
                    dn.storeChildren(root);
                    DiagnoselisteBaseView.this.updateTree(p);
                }
            }
        };
    }

    public void setFocus() {
    }

    public void refresh() {
        this.activePatient(ContextServiceHolder.get().getActivePatient().orElse(null));
    }

    @Inject
    void activePatient(@Optional IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> {
            Patient p = (Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient);
            this.updateTree(p);
        }, (Object)this.tree);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    private class ImportAction
    extends Action {
        int fromTyp;

        public ImportAction(int typ) {
            if (typ == 1) {
                this.setText("Import Pers. Anamnese");
            } else if (typ == 2) {
                this.setText("Import Systemanamnese");
            } else if (typ == 0) {
                this.setText("Import Diagnoseliste");
            }
            this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
            this.fromTyp = typ;
        }

        public void run() {
            Patient pat = ElexisEventDispatcher.getSelectedPatient();
            DiagnoselisteBaseView.this.importFrom(DiagnoselisteItem.getRoot(pat, this.fromTyp), DiagnoselisteItem.getRoot(pat, DiagnoselisteBaseView.this.typ));
            DiagnoselisteBaseView.this.updateTree(pat);
        }
    }
}

