/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Patient;
import ch.rgw.tools.StringTool;
import com.hilotec.elexis.kgview.SimpleTextFView;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;

public abstract class PatientTextFView
extends SimpleTextFView
implements IRefreshable {
    protected final String dbfield;
    private Patient actPatient;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    protected PatientTextFView(String field) {
        this.dbfield = field;
    }

    @Override
    protected void initialize() {
        Patient p = ElexisEventDispatcher.getSelectedPatient();
        if (p != null) {
            this.patientChanged(p);
        }
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    @Override
    protected void fieldChanged() {
        Patient p = ElexisEventDispatcher.getSelectedPatient();
        if (p != null) {
            p.set(this.dbfield, this.getText());
        }
    }

    private void patientChanged(Patient p) {
        this.setEnabled(true);
        this.setText(StringTool.unNull((String)p.get(this.dbfield)));
    }

    @Inject
    void activePatient(@Optional IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> {
            Patient p = (Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient);
            if (!(this.actPatient == null || p != null && this.actPatient.getId().equals(p.getId()))) {
                this.actPatient.set(this.dbfield, this.getText());
            }
            if (p != null) {
                this.patientChanged(p);
            } else {
                this.setEnabled(false);
            }
            this.actPatient = p;
        }, (Object)this.area);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    public void refresh() {
        this.activePatient(ContextServiceHolder.get().getActivePatient().orElse(null));
    }
}

