/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Konsultation;
import com.hilotec.elexis.kgview.data.KonsData;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;

public class KonsTimeView
extends ViewPart
implements IRefreshable {
    public static final String ID = "com.hilotec.elexis.kgview.KonsTimeView";
    Label timerLbl;
    KonsData konsData;
    long time;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.timerLbl = new Label(comp, 0);
        this.createButtonControl(comp);
        this.setEnabled(false);
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void setFocus() {
    }

    protected void createButtonControl(Composite parent) {
    }

    protected void setEnabled(boolean en) {
    }

    protected void stopTimer() {
    }

    private void konsDeselected() {
        this.stopTimer();
        this.konsData.setKonsZeit(this.time);
        this.setEnabled(false);
        this.konsData = null;
        this.time = 0L;
        this.updateLabel();
    }

    private void konsSelected(Konsultation kons) {
        this.konsData = new KonsData(kons);
        this.time = this.konsData.getKonsZeit();
        this.setEnabled(true);
        this.updateLabel();
    }

    protected void updateLabel() {
        if (this.timerLbl.isDisposed()) {
            return;
        }
        long secs = this.time / 1000L;
        String text = String.format("%02d:%02d:%02d", secs / 3600L, secs % 3600L / 60L, secs % 60L);
        this.timerLbl.setText(text);
        this.timerLbl.pack();
        this.timerLbl.update();
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    @Inject
    void activeEncounter(@Optional IEncounter encounter) {
        CoreUiUtil.runAsyncIfActive(() -> {
            Konsultation k = (Konsultation)NoPoUtil.loadAsPersistentObject((Identifiable)encounter);
            if (k != null) {
                this.konsSelected(k);
            } else {
                this.konsDeselected();
            }
        }, (Object)this.timerLbl);
    }

    public void refresh() {
        this.activeEncounter(ContextServiceHolder.get().getTyped(IEncounter.class).orElse(null));
    }
}

