/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.util.model.TransientCoding;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import com.hilotec.elexis.kgview.diagnoseliste.DiagnoselisteItem;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;

public class DiagnosisMigrator {
    @Inject
    private IFindingsService findingsService;

    public DiagnosisMigrator() {
        CoreUiUtil.injectServices((Object)this);
    }

    public void migrate(IProgressMonitor monitor) {
        List allPatients = new Query(Patient.class).execute();
        monitor.beginTask("Hilotec Diagnosen/Anamnese Migration", allPatients.size());
        ConfigServiceHolder.get().set("diagnose/settings/useStructured", true);
        ConfigServiceHolder.get().set("persanamnese/settings/useStructured", true);
        for (Patient patient : allPatients) {
            DiagnoselisteItem rootSysAnamnesis = DiagnoselisteItem.getRoot(patient, 2);
            LocalDate dateRecorded = new TimeTool(rootSysAnamnesis.getDatum()).toLocalDate();
            for (DiagnoselisteItem di : this.getSortedChildren(rootSysAnamnesis)) {
                LocalDate itemDate = new TimeTool(di.getDatum()).toLocalDate();
                ICondition condition = (ICondition)this.findingsService.create(ICondition.class);
                condition.setPatientId(patient.getId());
                condition.setCategory(ICondition.ConditionCategory.PROBLEMLISTITEM);
                condition.setStart(String.valueOf(di.getText()) + " (" + itemDate.format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) + ")");
                condition.setStatus(ICondition.ConditionStatus.ACTIVE);
                dateRecorded = dateRecorded.minusDays(1L);
                condition.setDateRecorded(dateRecorded);
                StringJoiner textJoiner = new StringJoiner("\n");
                this.addSubItems(textJoiner, this.getSortedChildren(di), 0, true);
                condition.setText(textJoiner.toString());
                this.findingsService.saveFinding((IFinding)condition);
            }
            DiagnoselisteItem rootPersAnamnesis = DiagnoselisteItem.getRoot(patient, 1);
            for (DiagnoselisteItem di : this.getSortedChildren(rootPersAnamnesis)) {
                LocalDate itemDate = new TimeTool(di.getDatum()).toLocalDate();
                IObservation observation = this.getOrCreatePersonalAnamnesis(patient.getId());
                StringJoiner textJoiner = new StringJoiner("\n");
                observation.getText().ifPresent(text -> {
                    StringJoiner stringJoiner2 = textJoiner.add((CharSequence)text);
                });
                textJoiner.add(String.valueOf(di.getText()) + " (" + itemDate.format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) + ")");
                this.addSubItems(textJoiner, this.getSortedChildren(di), 2, true);
                observation.setText(textJoiner.toString());
                this.findingsService.saveFinding((IFinding)observation);
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    private IObservation getOrCreatePersonalAnamnesis(String patientId) {
        List observations = this.findingsService.getPatientsFindings(patientId, IObservation.class);
        if ((observations = observations.parallelStream().filter(iFinding -> this.isPersAnamnese((IObservation)iFinding)).collect(Collectors.toList())).isEmpty()) {
            IObservation observation = (IObservation)this.findingsService.create(IObservation.class);
            observation.setPatientId(patientId);
            observation.setCategory(IObservation.ObservationCategory.SOCIALHISTORY);
            observation.setCoding(Collections.singletonList(new TransientCoding(IObservation.ObservationCode.ANAM_PERSONAL)));
            this.findingsService.saveFinding((IFinding)observation);
            return observation;
        }
        return (IObservation)observations.get(0);
    }

    private boolean isPersAnamnese(IObservation iFinding) {
        if (iFinding instanceof IObservation && iFinding.getCategory() == IObservation.ObservationCategory.SOCIALHISTORY) {
            for (ICoding code : iFinding.getCoding()) {
                if (!IObservation.ObservationCode.ANAM_PERSONAL.isSame(code)) continue;
                return true;
            }
        }
        return false;
    }

    private void addSubItems(StringJoiner textJoiner, List<DiagnoselisteItem> sortedChildren, int depth, boolean addDate) {
        String postfix = " ".repeat(depth);
        for (DiagnoselisteItem sub : sortedChildren) {
            LocalDate dateRecorded = new TimeTool(sub.getDatum()).toLocalDate();
            if (addDate) {
                textJoiner.add(String.valueOf(postfix) + sub.getText() + " (" + dateRecorded.format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) + ")");
            } else {
                textJoiner.add(String.valueOf(postfix) + sub.getText());
            }
            if (this.getSortedChildren(sub).size() <= 0) continue;
            this.addSubItems(textJoiner, this.getSortedChildren(sub), depth + 2, addDate);
        }
    }

    private List<DiagnoselisteItem> getSortedChildren(DiagnoselisteItem item) {
        List<DiagnoselisteItem> sortedChildren = item.getChildren();
        Collections.sort(sortedChildren, new DiagnoselisteItemComparator());
        return sortedChildren;
    }

    private class DiagnoselisteItemComparator
    implements Comparator<DiagnoselisteItem> {
        private DiagnoselisteItemComparator() {
        }

        @Override
        public int compare(DiagnoselisteItem o1, DiagnoselisteItem o2) {
            return Integer.compare(o1.getPosition(), o2.getPosition());
        }
    }
}

