/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.data.Anwender;
import ch.elexis.data.Brief;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.rgw.tools.StringTool;
import com.hilotec.elexis.kgview.ArchivKG;
import com.hilotec.elexis.kgview.data.KonsData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class ArchivKGPrintView
extends ViewPart {
    public static final String ID = "com.hilotec.elexis.kgview.ArvchivKGPrintView";
    Brief brief;
    TextContainer text;

    public void createPartControl(Composite parent) {
        this.text = new TextContainer(this.getViewSite());
        this.text.getPlugin().createContainer(parent, new ITextPlugin.ICallback(){

            public void save() {
            }

            public boolean saveAs() {
                return false;
            }
        });
    }

    public void setFocus() {
    }

    private Object processKonsultation(Konsultation k, ITextPlugin tp, Object pos) {
        KonsData kd = KonsData.load(k);
        int typ = kd.getKonsTyp();
        String styp = typ == 1 ? "Telefon" : (typ == 2 ? "Hausbesuch" : "Konsultation");
        tp.setStyle(1);
        pos = tp.insertText(pos, styp, 16384);
        pos = tp.insertText(pos, " " + k.getDatum() + " " + kd.getKonsBeginn(), 16384);
        tp.setStyle(0);
        if (k.getFall() != null) {
            pos = tp.insertText(pos, " " + k.getFall().getAbrechnungsSystem(), 16384);
        }
        String sAutor = "";
        Anwender autor = kd.getAutor();
        if (autor != null && StringTool.isNothing((Object)(sAutor = autor.getKuerzel()))) {
            sAutor = autor.getLabel();
        }
        pos = tp.insertText(pos, " (" + sAutor + ")\n", 16384);
        pos = this.addParagraph("Jetziges Leiden", kd.getJetzigesLeiden(), kd.getJetzigesLeidenICPC(), tp, pos);
        pos = this.addParagraph("Status", kd.getLokalstatus(), tp, pos);
        pos = this.addParagraph("R\u00f6ntgen", kd.getRoentgen(), tp, pos);
        pos = this.addParagraph("EKG", kd.getEKG(), tp, pos);
        pos = this.addParagraph("Diagnose", kd.getDiagnose(), kd.getDiagnoseICPC(), tp, pos);
        pos = this.addParagraph("Therapie", kd.getTherapie(), tp, pos);
        pos = this.addParagraph("Verlauf", kd.getVerlauf(), tp, pos);
        pos = this.addParagraph("Procedere", kd.getProzedere(), kd.getProzedereICPC(), tp, pos);
        pos = tp.insertText(pos, "\n", 0);
        return pos;
    }

    private Object addParagraph(String titel, String text, ITextPlugin tp, Object pos) {
        return this.addParagraph(titel, text, null, tp, pos);
    }

    private Object addParagraph(String titel, String text, String icpc, ITextPlugin tp, Object pos) {
        if ((text == null || text.isEmpty()) && (icpc == null || icpc.isEmpty())) {
            return pos;
        }
        tp.setStyle(1);
        pos = tp.insertText(pos, titel, 16384);
        tp.setStyle(0);
        pos = tp.insertText(pos, "\n", 16384);
        if (icpc != null && !icpc.isEmpty()) {
            pos = tp.insertText(pos, "ICPC: " + icpc.replace(",", ", ") + "\n", 16384);
        }
        pos = tp.insertText(pos, String.valueOf(text) + "\n\n", 16384);
        return pos;
    }

    public void doPrint(Konsultation kons, Kontakt adressat, boolean reversed) {
        this.brief = this.text.createFromTemplateName(kons, "ArchivKG", "Allg.", adressat, "Archiv-KG");
        ITextPlugin tp = this.text.getPlugin();
        Patient pat = kons.getFall().getPatient();
        Object pos = tp.insertText("[ArchivKG]", "", 16384);
        for (Konsultation k : ArchivKG.getKonsultationen(pat, reversed)) {
            pos = this.processKonsultation(k, tp, pos);
        }
        this.brief.save(tp.storeToByteArray(), tp.getMimeType());
        tp.print(null, null, true);
    }
}

