/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import com.hilotec.elexis.kgview.data.KonsData;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class ArchivKGMigrator {
    public static final String DOMAIN_HILOTEC_MIGRATION_ARCHIVKG = "www.hilotec.com/migration/archivkg/xid";

    public ArchivKGMigrator() {
        XidServiceHolder.get().localRegisterXIDDomainIfNotExists(DOMAIN_HILOTEC_MIGRATION_ARCHIVKG, "hilotec archivkg migration", 1);
    }

    public void migrate(IProgressMonitor monitor) {
        List allPatients = new Query(Patient.class).execute();
        monitor.beginTask("Hilotec ArchivKG Migration", allPatients.size());
        for (Patient patient : allPatients) {
            Fall[] fallArray = patient.getFaelle();
            int n = fallArray.length;
            int n2 = 0;
            while (n2 < n) {
                Fall fall = fallArray[n2];
                Konsultation[] konsultationArray = fall.getBehandlungen(false);
                int n3 = konsultationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    KonsData archivKg;
                    IXid migrated;
                    Konsultation kons = konsultationArray[n4];
                    IEncounter encounter = CoreModelServiceHolder.get().load(kons.getId(), IEncounter.class).orElse(null);
                    if (encounter != null && (migrated = XidServiceHolder.get().getXid((Identifiable)encounter, DOMAIN_HILOTEC_MIGRATION_ARCHIVKG)) == null && (archivKg = KonsData.load(kons)).exists()) {
                        StringBuilder sb = new StringBuilder();
                        this.addParagraph("JetzigesLeiden", archivKg.getJetzigesLeiden(), archivKg.getJetzigesLeidenICPC(), sb);
                        this.addParagraph("Status", archivKg.getLokalstatus(), sb);
                        this.addParagraph("R\u00f6ntgen", archivKg.getRoentgen(), sb);
                        this.addParagraph("EKG", archivKg.getEKG(), sb);
                        this.addParagraph("Diagnose", archivKg.getDiagnose(), archivKg.getDiagnoseICPC(), sb);
                        this.addParagraph("Therapie", archivKg.getTherapie(), sb);
                        this.addParagraph("Verlauf", archivKg.getVerlauf(), sb);
                        this.addParagraph("Procedere", archivKg.getProzedere(), archivKg.getProzedereICPC(), sb);
                        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                            this.appendKonsText(encounter, sb);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    private void appendKonsText(IEncounter encounter, StringBuilder sb) {
        Samdas samdas = new Samdas(encounter.getVersionedEntry().getHead());
        Samdas.Record rec = samdas.getRecord();
        String recText = rec.getText();
        recText = StringUtils.isNotBlank((CharSequence)recText) ? String.valueOf(recText) + "\n\n" + sb.toString() : String.valueOf(recText) + sb.toString();
        rec.setText(recText);
        EncounterServiceHolder.get().updateVersionedEntry(encounter, samdas);
        XidServiceHolder.get().addXid((Identifiable)encounter, DOMAIN_HILOTEC_MIGRATION_ARCHIVKG, encounter.getId(), true);
    }

    private void addParagraph(String titel, String text, StringBuilder sb) {
        this.addParagraph(titel, text, null, sb);
    }

    private void addParagraph(String titel, String text, String icpc, StringBuilder sb) {
        if ((text == null || text.isEmpty()) && (icpc == null || icpc.isEmpty())) {
            return;
        }
        sb.append(String.valueOf(titel) + ":\n");
        if (icpc != null && !icpc.isEmpty()) {
            sb.append("ICPC: " + icpc.replace(",", ", ") + "\n");
        }
        sb.append(text);
        sb.append("\n\n");
    }
}

