/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.widgets;

import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.model.RegexValidation;
import ch.unibe.iam.scg.archie.ui.Decorators;
import ch.unibe.iam.scg.archie.ui.widgets.AbstractWidget;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class TextWidget
extends AbstractWidget {
    protected static final int DECORATION_HORIZONTAL_MARGIN = 3;
    protected ControlDecoration controlDecoration;
    protected SmartField smartField;

    public TextWidget(Composite parent, int style, String labelText, RegexValidation regex) {
        super(parent, style, labelText, regex);
        this.label = new Label((Composite)this, 0);
        this.label.setText(labelText);
        this.layout.horizontalSpacing = 20;
        this.control = new Text((Composite)this, 2048);
        GridData layoutData = new GridData(512);
        layoutData.widthHint = 100;
        this.control.setLayoutData((Object)layoutData);
        this.createSmartField();
        ((Text)this.control).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TextWidget.this.handleModify(TextWidget.this.smartField);
            }
        });
        this.controlDecoration = new ControlDecoration(this.control, 0x1020000);
        this.controlDecoration.setShowOnlyOnFocus(false);
        this.controlDecoration.setMarginWidth(3);
    }

    protected void createSmartField() {
        this.smartField = new SmartField();
    }

    @Override
    public Object getValue() {
        return this.smartField.getContents();
    }

    @Override
    public void setValue(Object value) {
        this.smartField.setContents(value.toString());
    }

    @Override
    public boolean isValid() {
        return this.smartField.isValid();
    }

    public void addListener(int eventType, Listener listener) {
        super.addListener(eventType, listener);
        this.control.addListener(eventType, listener);
    }

    protected void handleModify(SmartField smartField) {
        this.hideQuickfix(smartField);
        this.hideError(smartField);
        this.hideValid(smartField);
        this.hideWarning(smartField);
        if (!smartField.isValid()) {
            if (smartField.hasQuickFix()) {
                this.showQuickfix(smartField);
            } else {
                this.showError(smartField);
            }
        } else if (smartField.isWarning()) {
            this.showWarning(smartField);
        } else {
            this.showValid(smartField);
        }
    }

    protected void showError(SmartField smartField) {
        this.showDecoration(smartField, 0, true);
    }

    protected void hideError(SmartField smartField) {
        this.showDecoration(smartField, 0, false);
    }

    protected void showQuickfix(SmartField smartField) {
        this.showDecoration(smartField, 3, true);
    }

    protected void hideQuickfix(SmartField smartField) {
        this.showDecoration(smartField, 3, false);
    }

    protected void showWarning(SmartField smartField) {
        this.showDecoration(smartField, 1, true);
    }

    protected void hideWarning(SmartField smartField) {
        this.showDecoration(smartField, 1, false);
    }

    protected void showValid(SmartField smartField) {
        this.showDecoration(smartField, 2, true);
    }

    protected void hideValid(SmartField smartField) {
        this.showDecoration(smartField, 2, false);
    }

    private void showDecoration(SmartField smartField, int type, boolean show) {
        smartField.setFieldDecoration(Decorators.getFieldDecoration(type, smartField.getDecorationMessage(type)));
        if (show) {
            this.controlDecoration.setImage(smartField.getFieldDecoration().getImage());
            this.controlDecoration.setDescriptionText(smartField.getFieldDecoration().getDescription());
            this.controlDecoration.show();
        } else {
            this.controlDecoration.hide();
        }
    }

    @Override
    public void setDescription(String description) {
        this.label.setToolTipText(description);
        this.control.setToolTipText(description);
    }

    protected class SmartField {
        protected IControlContentAdapter contentAdapter = new TextContentAdapter();
        protected FieldDecoration fieldDecoration;
        protected Menu quickFixMenu;

        public boolean isValid() {
            if (this.getContents().equals("")) {
                return false;
            }
            return !TextWidget.this.hasRegexValidation() || !this.getContents().matches(TextWidget.this.regexValidation.getPattern());
        }

        public boolean isWarning() {
            return false;
        }

        public boolean hasQuickFix() {
            return false;
        }

        public String getContents() {
            return this.contentAdapter.getControlContents(TextWidget.this.control);
        }

        public void setContents(String contents) {
            this.contentAdapter.setControlContents(TextWidget.this.control, contents, contents.length());
        }

        public FieldDecoration getFieldDecoration() {
            return this.fieldDecoration;
        }

        public void setFieldDecoration(FieldDecoration fieldDecoration) {
            this.fieldDecoration = fieldDecoration;
        }

        protected String getDecorationMessage(int type) {
            switch (type) {
                case 0: {
                    return this.getErrorMessage();
                }
                case 3: {
                    return this.getQuickfixMessage();
                }
                case 1: {
                    return this.getWarningMessage();
                }
                case 2: {
                    return this.getValidMessage();
                }
            }
            return "";
        }

        protected String getErrorMessage() {
            String error = Messages.FIELD_GENERAL_ERROR;
            if (TextWidget.this.hasRegexValidation()) {
                error = String.valueOf(error) + " " + TextWidget.this.regexValidation.getMessage();
            }
            return error;
        }

        protected String getQuickfixMessage() {
            return Messages.FIELD_GENERAL_ERROR_QUICKFIX;
        }

        protected String getWarningMessage() {
            return Messages.FIELD_GENERAL_WARNING;
        }

        protected String getValidMessage() {
            return Messages.FIELD_GENERAL_VALID;
        }
    }
}

