/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.widgets;

import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.model.RegexValidation;
import ch.unibe.iam.scg.archie.ui.widgets.TextWidget;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class NumericWidget
extends TextWidget {
    public NumericWidget(Composite parent, int style, String labelText, RegexValidation regex) {
        super(parent, style, labelText, regex);
        this.controlDecoration.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                if (NumericWidget.this.smartField.isValid()) {
                    return;
                }
                if (NumericWidget.this.smartField.quickFixMenu == null) {
                    NumericWidget.this.smartField.quickFixMenu = NumericWidget.this.createQuickFixMenu((SmartNumericField)NumericWidget.this.smartField);
                }
                NumericWidget.this.smartField.quickFixMenu.setLocation(event.x, event.y);
                NumericWidget.this.smartField.quickFixMenu.setVisible(true);
            }
        });
    }

    @Override
    protected void createSmartField() {
        this.smartField = new SmartNumericField();
    }

    protected Menu createQuickFixMenu(final SmartNumericField field) {
        Menu newMenu = new Menu(this.control);
        MenuItem item = new MenuItem(newMenu, 8);
        item.setText(Messages.FIELD_NUMERIC_QUICKFIX);
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                field.quickFix();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        return newMenu;
    }

    @Override
    public Object getValue() {
        int value = 0;
        try {
            value = Integer.parseInt(this.smartField.getContents());
        }
        catch (Exception e) {
            ArchieActivator.LOG.log(e.getLocalizedMessage(), 2);
        }
        return value;
    }

    private class SmartNumericField
    extends TextWidget.SmartField {
        public SmartNumericField() {
            super(NumericWidget.this);
        }

        @Override
        public boolean isValid() {
            String contents = this.getContents();
            int i = 0;
            while (i < contents.length()) {
                if (!Character.isDigit(contents.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return !NumericWidget.this.hasRegexValidation() || this.getContents().matches(NumericWidget.this.regexValidation.getPattern());
        }

        @Override
        public boolean hasQuickFix() {
            return true;
        }

        @Override
        protected String getQuickfixMessage() {
            return this.getErrorMessage();
        }

        @Override
        protected String getErrorMessage() {
            String error = Messages.FIELD_NUMERIC_ERROR;
            if (NumericWidget.this.hasRegexValidation()) {
                error = String.valueOf(error) + "\n" + NumericWidget.this.regexValidation.getMessage();
            }
            return error;
        }

        protected void quickFix() {
            String contents = this.getContents();
            StringBuffer digitsOnly = new StringBuffer();
            int length = contents.length();
            int i = 0;
            while (i < length) {
                char ch;
                if (!Character.isDigit(ch = contents.charAt(i++))) continue;
                digitsOnly.append(ch);
            }
            this.setContents(digitsOnly.toString());
        }
    }
}

