/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.widgets;

import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.model.RegexValidation;
import ch.unibe.iam.scg.archie.ui.widgets.TextWidget;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class DateWidget
extends TextWidget {
    public static final String VALID_DATE_FORMAT = "dd.MM.yyyy";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    private DateTime datePicker;
    private Shell datePickerShell;

    public DateWidget(Composite parent, int style, String labelText, RegexValidation regex) {
        super(parent, style, labelText, regex);
        Label datePickerPopupButton = new Label((Composite)this, 0x800000);
        Image image = ArchieActivator.getInstance().getImageRegistry().get("buttoCalendar");
        datePickerPopupButton.setImage(image);
        datePickerPopupButton.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent event) {
                DateWidget.this.popUpCalendar();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.datePickerShell = new Shell(this.getDisplay(), 65536);
        GridLayout shellLayout = new GridLayout();
        shellLayout.numColumns = 1;
        this.datePickerShell.setLayout((Layout)shellLayout);
        this.datePicker = new DateTime((Composite)this.datePickerShell, 1024);
        Button button = new Button((Composite)this.datePickerShell, 0);
        button.setText(Messages.BUTTON_DATE_SELECT);
        button.setLayoutData((Object)new GridData(768));
        button.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                Calendar cal = Calendar.getInstance();
                cal.set(1, DateWidget.this.datePicker.getYear());
                cal.set(2, DateWidget.this.datePicker.getMonth());
                cal.set(5, DateWidget.this.datePicker.getDay());
                DateWidget.this.smartField.setContents(DATE_FORMAT.format(cal.getTime()));
                DateWidget.this.popDownCalendar();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.datePickerShell.pack();
        this.datePickerShell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: 
                    case 4: {
                        DateWidget.this.popDownCalendar();
                        event.detail = 0;
                        event.doit = false;
                    }
                }
            }
        });
        this.datePicker.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                Calendar cal = Calendar.getInstance();
                cal.set(1, DateWidget.this.datePicker.getYear());
                cal.set(2, DateWidget.this.datePicker.getMonth());
                cal.set(5, DateWidget.this.datePicker.getDay());
                DateWidget.this.smartField.setContents(DATE_FORMAT.format(cal.getTime()));
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.controlDecoration.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                if (DateWidget.this.smartField.isValid()) {
                    return;
                }
                if (DateWidget.this.smartField.quickFixMenu == null) {
                    DateWidget.this.smartField.quickFixMenu = DateWidget.this.createQuickFixMenu((SmartDateField)DateWidget.this.smartField);
                }
                DateWidget.this.smartField.quickFixMenu.setLocation(event.x, event.y);
                DateWidget.this.smartField.quickFixMenu.setVisible(true);
            }
        });
    }

    @Override
    protected void createLayout() {
        this.layout = new GridLayout();
        this.layout.numColumns = 3;
        this.layout.marginWidth = 2;
        this.setLayout((Layout)this.layout);
    }

    @Override
    protected void createSmartField() {
        this.smartField = new SmartDateField();
    }

    protected void popUpCalendar() {
        this.updateCalendarPopup();
        Point pt = this.getDisplay().getCursorLocation();
        this.datePickerShell.setLocation(pt.x - this.datePicker.getSize().x, pt.y);
        this.datePickerShell.setVisible(true);
        this.datePickerShell.setFocus();
    }

    protected void popDownCalendar() {
        this.datePickerShell.setVisible(false);
    }

    private void updateCalendarPopup() {
        if (this.smartField.isValid()) {
            try {
                Date date = DATE_FORMAT.parse(this.smartField.getContents());
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                this.datePicker.setDate(cal.get(1), cal.get(2), cal.get(5));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    protected Menu createQuickFixMenu(final SmartDateField field) {
        Menu newMenu = new Menu(this.control);
        MenuItem item = new MenuItem(newMenu, 8);
        item.setText("You can set this field to the value of today's date.");
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                field.quickFix();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        return newMenu;
    }

    private class SmartDateField
    extends TextWidget.SmartField {
        @Override
        protected String getErrorMessage() {
            String format = DateWidget.VALID_DATE_FORMAT;
            String error = NLS.bind((String)Messages.ERROR_DATE_FORMAT, (Object)format.toUpperCase());
            if (DateWidget.this.hasRegexValidation()) {
                error = String.valueOf(error) + " " + DateWidget.this.regexValidation.getMessage();
            }
            return error;
        }

        @Override
        public boolean isValid() {
            if (this.getContents().equals("")) {
                return false;
            }
            Date testDate = null;
            try {
                testDate = DATE_FORMAT.parse(this.getContents());
            }
            catch (ParseException e) {
                return false;
            }
            if (!DATE_FORMAT.format(testDate).equals(this.getContents())) {
                return false;
            }
            return !DateWidget.this.hasRegexValidation() || this.getContents().matches(DateWidget.this.regexValidation.getPattern());
        }

        @Override
        public boolean hasQuickFix() {
            return true;
        }

        @Override
        protected String getQuickfixMessage() {
            return this.getErrorMessage();
        }

        protected void quickFix() {
            Calendar cal = Calendar.getInstance();
            this.setContents(DATE_FORMAT.format(cal.getTime()));
        }
    }
}

