/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui;

import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.utils.DatabaseHelper;
import java.math.BigDecimal;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DashboardOverview
extends Composite {
    private Label patients;
    private Label invoices;
    private Label consultations;

    public DashboardOverview(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData layoutData = new GridData(4, 4, true, true);
        Group overview = new Group((Composite)this, 0);
        overview.setText("Statistics");
        overview.setLayout((Layout)layout);
        overview.setLayoutData((Object)layoutData);
        this.createDescriptionPanel((Composite)overview);
        this.createStatsPanel((Composite)overview);
    }

    public void refresh() {
        this.setValues();
    }

    private Composite createDescriptionPanel(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        GridData layoutData = new GridData(4, 4, true, true);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)layoutData);
        Label introduction = new Label(container, 64);
        introduction.setText(Messages.DASHBOARD_WELCOME);
        introduction.setLayoutData((Object)layoutData);
        return container;
    }

    private Composite createStatsPanel(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        GridData layoutData = new GridData(4, 4, true, true);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)layoutData);
        this.patients = new Label(container, 64);
        this.invoices = new Label(container, 64);
        this.consultations = new Label(container, 64);
        this.consultations.setLayoutData((Object)layoutData);
        this.setValues();
        return container;
    }

    private void setValues() {
        int patientsTotal = DatabaseHelper.getNumberOfPatients();
        int patientsMale = DatabaseHelper.getNumberGenderPatients("m");
        int patientsFemale = DatabaseHelper.getNumberGenderPatients("w");
        int invoicesTotal = DatabaseHelper.getTotalNumberOfInvoices();
        int invoicesPaid = DatabaseHelper.getNumberOfInvoices(16);
        int invoicesOpen = DatabaseHelper.getNumberOfInvoices(4) + DatabaseHelper.getNumberOfInvoices(5);
        int consultationsTotal = DatabaseHelper.getNumberOfConsultations();
        this.patients.setText(String.valueOf(Messages.PATIENTS) + ": " + patientsTotal + "\n" + Messages.MALE + ": " + this.writePercent(patientsMale, patientsTotal) + "\n" + Messages.FEMALE + ": " + this.writePercent(patientsFemale, patientsTotal) + "\n" + Messages.UNKNOWN + ": " + this.writePercent(patientsTotal - patientsFemale - patientsMale, patientsTotal));
        this.invoices.setText(String.valueOf(Messages.INVOICES) + ": " + invoicesTotal + "\n" + Messages.PAID + ": " + this.writePercent(invoicesPaid, invoicesTotal) + "\n" + Messages.OPEN + ": " + this.writePercent(invoicesOpen, invoicesTotal) + "\n" + Messages.OTHER + ": " + this.writePercent(invoicesTotal - invoicesOpen - invoicesPaid, invoicesTotal));
        this.consultations.setText(String.valueOf(Messages.CONSULTATIONS) + ": " + consultationsTotal + "\n");
    }

    private float calculatePercent(float givenAmount, float totalAmount) {
        if (totalAmount <= 0.0f) {
            return 0.0f;
        }
        return givenAmount / totalAmount * 100.0f;
    }

    private String writePercent(float givenAmount, float totalAmount) {
        BigDecimal percent = new BigDecimal(this.calculatePercent(givenAmount, totalAmount));
        percent = percent.setScale(1, 4);
        return String.valueOf(percent.doubleValue()) + " %";
    }
}

