/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.handlers;

import ch.elexis.core.ui.util.SWTHelper;
import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.controller.ProviderManager;
import ch.unibe.iam.scg.archie.export.CSVWriter;
import ch.unibe.iam.scg.archie.export.PDFWriter;
import ch.unibe.iam.scg.archie.model.AbstractDataProvider;
import ch.unibe.iam.scg.archie.ui.views.StatisticsView;
import ch.unibe.iam.scg.archie.utils.StringHelper;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportHandler
extends AbstractHandler {
    private StatisticsView view;
    private static boolean SINGLE_SPACED_FILES = false;
    private static String EXTENSION;
    private static String viewURI;
    private static Logger log;

    static {
        viewURI = "ch.unibe.iam.scg.archie.ui.views.StatisticsView";
        log = LoggerFactory.getLogger(ExportHandler.class);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = activePage.findView(viewURI);
        if (!(viewPart instanceof StatisticsView)) {
            log.error("ExportHandler - StatisticsView not found.");
            return null;
        }
        this.view = (StatisticsView)viewPart;
        if (ProviderManager.getInstance().getProvider() == null || ProviderManager.getInstance().getProvider().getResult() == null) {
            SWTHelper.showError((String)Messages.ERROR_WRITING_FILE_TITLE, (String)(String.valueOf(Messages.ERROR_EXPORT_DATA_NOT_EXIST) + Messages.ERROR_SELECT_DATA));
        } else {
            String exportType = event.getParameter("ch.unibe.iam.scg.archie.commandParameter.export.format");
            if ("pdf".equals(exportType)) {
                this.exportAction(exportType);
            } else if ("csv".equals(exportType)) {
                this.exportAction(exportType);
            }
        }
        return null;
    }

    public void exportAction(String format) {
        EXTENSION = format;
        FileDialog chooser = new FileDialog(this.view.getSite().getShell(), 8192);
        chooser.setFilterExtensions(new String[]{"*." + EXTENSION, "*.*"});
        chooser.setFilterNames(new String[]{String.valueOf(format.toUpperCase()) + " Files", "All Files"});
        String name = String.valueOf(this.getNameSuggestion().toLowerCase()) + "." + EXTENSION;
        chooser.setFileName(name);
        String fileName = chooser.open();
        if (fileName != null) {
            try {
                if (format.equals("pdf")) {
                    PDFWriter.saveFile(fileName, ProviderManager.getInstance().getProvider());
                    SWTHelper.showInfo((String)(String.valueOf(format.toUpperCase()) + " " + Messages.ACTION_EXPORT_TITLE), (String)Messages.ACTION_EXPORT_SUCCESS);
                } else if (format.equals("csv")) {
                    CSVWriter.writeFile(ProviderManager.getInstance().getProvider(), fileName);
                    SWTHelper.showInfo((String)(String.valueOf(format.toUpperCase()) + " " + Messages.ACTION_EXPORT_TITLE), (String)Messages.ACTION_EXPORT_SUCCESS);
                }
            }
            catch (IOException e) {
                log.error("Could not save the " + format.toUpperCase() + " file.");
                SWTHelper.showError((String)(String.valueOf(format.toUpperCase()) + " " + Messages.ERROR_WRITING_FILE_TITLE), (String)Messages.ERROR_WRITING_FILE);
            }
        }
    }

    private String getNameSuggestion() {
        AbstractDataProvider provider = ProviderManager.getInstance().getProvider();
        String name = StringHelper.removeIllegalCharacters(provider.getName(), SINGLE_SPACED_FILES);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        name = String.valueOf(name) + "_" + format.format(Calendar.getInstance().getTime());
        return name;
    }
}

