/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.export;

import be.quodlibet.boxable.BaseTable;
import be.quodlibet.boxable.Cell;
import be.quodlibet.boxable.HorizontalAlignment;
import be.quodlibet.boxable.Row;
import ch.unibe.iam.scg.archie.model.AbstractDataProvider;
import ch.unibe.iam.scg.archie.model.DataSet;
import ch.unibe.iam.scg.archie.utils.ProviderHelper;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.slf4j.LoggerFactory;

public class PDFWriter {
    public static void saveFile(String fileName, AbstractDataProvider provider) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PDDocument document = new PDDocument();){
            PDPage page = new PDPage(new PDRectangle(PDRectangle.A4.getHeight(), PDRectangle.A4.getWidth()));
            document.addPage(page);
            PDPageContentStream contentStream = new PDPageContentStream(document, page);
            float yPosDescriptionEnd = PDFWriter.writeProviderInformation(contentStream, provider, page);
            contentStream.close();
            PDFWriter.createDataTable(document, page, provider.getDataSet(), yPosDescriptionEnd);
            PDFWriter.addPageNumbers(document);
            document.save((OutputStream)new FileOutputStream(fileName));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void createDataTable(PDDocument doc, PDPage page, DataSet data, float startY) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (PDPageContentStream contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true);){
            float margin = 50.0f;
            float tableWidth = page.getMediaBox().getWidth() - 2.0f * margin;
            BaseTable table = new BaseTable(startY, startY, margin, tableWidth, margin, doc, page, true, true);
            Color darkGray = new Color(200, 200, 200);
            Color lightGray = new Color(230, 230, 230);
            Color white = new Color(255, 255, 255);
            Row headerRow = table.createRow(15.0f);
            for (String heading : data.getHeadings()) {
                Cell cell = headerRow.createCell(100.0f / (float)data.getHeadings().size(), heading);
                cell.setFont((PDFont)PDType1Font.HELVETICA_BOLD);
                if (!PDFWriter.checkUnicodeSupport(cell.getFont(), heading)) {
                    cell.setFont(PDFWriter.getUnicodeFont(doc));
                }
                cell.setFillColor(darkGray);
                cell.setAlign(HorizontalAlignment.CENTER);
            }
            table.addHeaderRow(headerRow);
            boolean toggleColor = false;
            for (Object[] row : data) {
                Row dataRow = table.createRow(10.0f);
                Object[] objectArray = row;
                int n = row.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    String text = "";
                    if (obj != null) {
                        text = obj.toString();
                    }
                    String cleanText = PDFWriter.cleanText(text);
                    Cell cell = dataRow.createCell(100.0f / (float)row.length, cleanText);
                    cell.setFont((PDFont)PDType1Font.HELVETICA);
                    if (!PDFWriter.checkUnicodeSupport(cell.getFont(), cleanText)) {
                        cell.setFont(PDFWriter.getUnicodeFont(doc));
                    }
                    cell.setFillColor(toggleColor ? lightGray : white);
                    cell.setAlign(HorizontalAlignment.RIGHT);
                    ++n2;
                }
                boolean bl = toggleColor = !toggleColor;
            }
            table.draw();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static float writeProviderInformation(PDPageContentStream contentStream, AbstractDataProvider provider, PDPage page) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        contentStream.beginText();
        contentStream.setFont((PDFont)PDType1Font.HELVETICA, 12.0f);
        float yPos = page.getMediaBox().getHeight() - 50.0f;
        contentStream.newLineAtOffset(50.0f, yPos);
        contentStream.showText(String.valueOf(provider.getName()) + " " + dateFormat.format(Calendar.getInstance().getTime()));
        contentStream.endText();
        Map<String, Object> getters = ProviderHelper.getGetterMap(provider, true);
        contentStream.beginText();
        contentStream.setFont((PDFont)PDType1Font.HELVETICA, 10.0f);
        contentStream.newLineAtOffset(50.0f, yPos - 15.0f);
        int totalLines = 0;
        float maxWidth = page.getMediaBox().getWidth() - 100.0f;
        for (String key : getters.keySet()) {
            List<String> wrappedText = PDFWriter.wrapText(String.valueOf(key) + ": " + getters.get(key).toString(), maxWidth, contentStream, 10.0f);
            for (String line : wrappedText) {
                String cleanLine = PDFWriter.cleanText(line);
                contentStream.showText(cleanLine);
                contentStream.newLineAtOffset(0.0f, -15.0f);
            }
            totalLines += wrappedText.size();
        }
        contentStream.endText();
        return yPos - 15.0f - (float)(15 * totalLines);
    }

    private static List<String> wrapText(String text, float maxWidth, PDPageContentStream contentStream, float fontSize) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        float currentWidth = 0.0f;
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            float wordWidth = fontSize * PDType1Font.HELVETICA.getStringWidth(String.valueOf(word) + " ") / 1000.0f;
            if (currentWidth + wordWidth < maxWidth) {
                currentLine.append(word).append(" ");
                currentWidth += wordWidth;
            } else {
                lines.add(currentLine.toString().trim());
                currentLine = new StringBuilder(String.valueOf(word) + " ");
                currentWidth = wordWidth;
            }
            ++n2;
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString().trim());
        }
        return lines;
    }

    private static void addPageNumbers(PDDocument document) throws IOException {
        int totalPages = document.getNumberOfPages();
        int i = 0;
        while (i < totalPages) {
            PDPage page = document.getPage(i);
            PDPageContentStream footerContentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true);
            footerContentStream.beginText();
            footerContentStream.setFont((PDFont)PDType1Font.HELVETICA, 10.0f);
            footerContentStream.newLineAtOffset(page.getMediaBox().getWidth() - 100.0f, 30.0f);
            footerContentStream.showText("Seite " + (i + 1) + " von " + totalPages);
            footerContentStream.endText();
            footerContentStream.close();
            ++i;
        }
    }

    private static String cleanText(String text) {
        return text.replace("\r", "").replace("\n", "");
    }

    private static boolean checkUnicodeSupport(PDFont font, String text) throws IOException {
        try {
            font.encode(text);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static PDFont getUnicodeFont(PDDocument document) {
        InputStream fontStream = PDFont.class.getResourceAsStream("/org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf");
        if (fontStream == null) {
            LoggerFactory.getLogger(PDFWriter.class).warn("path to resource is null");
        }
        try {
            return PDType0Font.load((PDDocument)document, (InputStream)fontStream);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(PDFWriter.class).error("could not load font into document", (Throwable)e);
            return null;
        }
    }
}

