/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.controller;

import ch.rgw.tools.Money;
import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.model.ChartModel;
import ch.unibe.iam.scg.archie.model.DataSet;
import ch.unibe.iam.scg.archie.ui.GraphicalMessage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.swt.ChartComposite;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.slf4j.LoggerFactory;

public class ProviderChartFactory {
    private static ProviderChartFactory INSTANCE;
    private ChartModel model = null;

    private ProviderChartFactory() {
    }

    public static ProviderChartFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProviderChartFactory();
        }
        return INSTANCE;
    }

    public void setChartModel(ChartModel model) {
        this.model = model;
        assert (this.model != null);
    }

    public Composite createChart(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.model == null) {
            return new GraphicalMessage(parent, ArchieActivator.getImage("error"), Messages.NO_CHART_MODEL);
        }
        if (this.model.getChartType() == 1) {
            return this.createPieChart(parent);
        }
        return this.createBarChart(parent);
    }

    private Composite createPieChart(Composite parent) {
        DataSet dataset = this.model.getDataSet();
        DefaultPieDataset pieDataset = this.createJFreePieDataset(dataset);
        JFreeChart chart = this.createJFreePieChart((PieDataset)pieDataset);
        TextTitle subtitle = new TextTitle(String.valueOf(dataset.getHeadings().get(this.model.getValuesIndex())) + " per " + dataset.getHeadings().get(this.model.getKeysIndex()));
        chart.addSubtitle((Title)subtitle);
        ChartComposite chartComposite = new ChartComposite(parent, 0, chart);
        chartComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        return chartComposite;
    }

    private JFreeChart createJFreePieChart(PieDataset pieDataset) {
        if (this.model.isThreeDimensional()) {
            return ChartFactory.createPieChart3D((String)this.model.getChartName(), (PieDataset)pieDataset, (boolean)false, (boolean)true, (boolean)false);
        }
        return ChartFactory.createPieChart((String)this.model.getChartName(), (PieDataset)pieDataset, (boolean)false, (boolean)true, (boolean)false);
    }

    private DefaultPieDataset createJFreePieDataset(DataSet dataset) {
        DefaultPieDataset pieDataset = new DefaultPieDataset();
        Comparable<?>[] keys = dataset.getColumn(this.model.getKeysIndex());
        Comparable<?>[] values = dataset.getColumn(this.model.getValuesIndex());
        int[] rows = this.model.getRows();
        int i = 0;
        while (i < rows.length) {
            block5: {
                double value;
                int rowIndex;
                block7: {
                    block8: {
                        block6: {
                            rowIndex = rows[i];
                            if (keys[rowIndex] == null || values[rowIndex] == null) break block5;
                            value = 0.0;
                            if (!(values[rowIndex] instanceof Money)) break block6;
                            value = ((Money)values[rowIndex]).doubleValue();
                            break block7;
                        }
                        if (!(values[rowIndex] instanceof Number)) break block8;
                        value = ((Number)((Object)values[rowIndex])).doubleValue();
                        break block7;
                    }
                    String valString = values[rowIndex].toString().trim();
                    if (valString.isEmpty()) break block5;
                    value = Double.parseDouble(valString);
                }
                String key = keys[rowIndex].toString().trim();
                if (!key.isEmpty()) {
                    pieDataset.setValue((Comparable)((Object)key), value);
                }
            }
            ++i;
        }
        return pieDataset;
    }

    private Composite createBarChart(Composite parent) {
        DataSet dataset = this.model.getDataSet();
        DefaultCategoryDataset barDataset = this.createJFreeBarDataset(dataset);
        JFreeChart chart = this.createJFreeBarChart((CategoryDataset)barDataset);
        ChartComposite chartComposite = new ChartComposite(parent, 0, chart);
        chartComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        return chartComposite;
    }

    private DefaultCategoryDataset createJFreeBarDataset(DataSet dataset) {
        DefaultCategoryDataset categoryDataSet = new DefaultCategoryDataset();
        int[] rows = this.model.getRows();
        int[] columns = this.model.getColumns();
        int rowTitleColumnIndex = this.model.getCategoryColumnIndex();
        int i = 0;
        while (i < rows.length) {
            int rowIndex = rows[i];
            Comparable<?>[] row = dataset.getRow(rowIndex);
            String rowTitle = row[rowTitleColumnIndex].toString();
            int j = 0;
            while (j < columns.length) {
                double value = 0.0;
                int columnIndex = columns[j];
                String columnTitle = dataset.getHeadings().get(columnIndex);
                Comparable<?> cell = dataset.getCell(rowIndex, columnIndex);
                if (cell instanceof Money) {
                    value = ((Money)cell).doubleValue();
                } else {
                    String strValue = cell.toString().replaceAll(",", ".");
                    if (strValue != null) {
                        try {
                            value = Double.parseDouble(strValue);
                        }
                        catch (NumberFormatException e) {
                            LoggerFactory.getLogger(this.getClass()).warn("Could not parse [" + strValue + "] as double");
                        }
                    }
                }
                categoryDataSet.addValue(value, (Comparable)((Object)columnTitle), (Comparable)((Object)rowTitle));
                ++j;
            }
            ++i;
        }
        return categoryDataSet;
    }

    private JFreeChart createJFreeBarChart(CategoryDataset barDataset) {
        if (this.model.isThreeDimensional() && this.model.isLineChart()) {
            return ChartFactory.createLineChart3D((String)this.model.getChartName(), (String)"Category", (String)"Value", (CategoryDataset)barDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        }
        if (this.model.isThreeDimensional() && !this.model.isLineChart()) {
            return ChartFactory.createBarChart3D((String)this.model.getChartName(), (String)"Category", (String)"Value", (CategoryDataset)barDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        }
        if (this.model.isLineChart()) {
            JFreeChart chart = ChartFactory.createLineChart((String)this.model.getChartName(), (String)"Category", (String)"Value", (CategoryDataset)barDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            LineAndShapeRenderer renderer = (LineAndShapeRenderer)((CategoryPlot)chart.getPlot()).getRenderer();
            renderer.setShapesVisible(true);
            renderer.setShapesFilled(true);
            return chart;
        }
        return ChartFactory.createBarChart((String)this.model.getChartName(), (String)"Category", (String)"Value", (CategoryDataset)barDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    }
}

