/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.actions;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.controller.ChartModelManager;
import ch.unibe.iam.scg.archie.controller.ProviderManager;
import ch.unibe.iam.scg.archie.controller.TableFactory;
import ch.unibe.iam.scg.archie.controller.TableManager;
import ch.unibe.iam.scg.archie.controller.TreeFactory;
import ch.unibe.iam.scg.archie.model.AbstractDataProvider;
import ch.unibe.iam.scg.archie.model.DataSet;
import ch.unibe.iam.scg.archie.model.DatasetTableColumnSorter;
import ch.unibe.iam.scg.archie.model.SetDataException;
import ch.unibe.iam.scg.archie.ui.ParametersPanel;
import ch.unibe.iam.scg.archie.ui.ProviderInformatioPanel;
import ch.unibe.iam.scg.archie.ui.ResultPanel;
import ch.unibe.iam.scg.archie.ui.views.StatisticsView;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class NewStatisticsAction
extends Action
implements IJobChangeListener,
Observer {
    private StatisticsView view;
    private ParametersPanel parameters;
    private ProviderInformatioPanel providerInformation;
    private ArrayList<IPropertyChangeListener> listeners;
    public static final String JOB_RUNNING = "JOB_RUNNING";
    public static final String JOB_DONE = "JOB_DONE";

    public NewStatisticsAction(ParametersPanel parameters) {
        super(Messages.ACTION_NEWSTAT_TITLE, 1);
        ProviderManager.getInstance().addObserver(this);
        this.setToolTipText(Messages.ACTION_NEWSTAT_DESCRIPTION);
        this.setImageDescriptor(ArchieActivator.getImageDescriptor("icons/database_go.png"));
        this.setEnabled(false);
        this.parameters = parameters;
        this.listeners = new ArrayList();
    }

    public void run() {
        if (ProviderManager.getInstance().hasProvider() && this.parameters.allFieldsValid()) {
            AbstractDataProvider provider = ProviderManager.getInstance().getProvider();
            try {
                this.parameters.updateProviderParameters();
            }
            catch (SetDataException e) {
                SWTHelper.showError((String)Messages.ERROR, (String)e.getMessage());
                return;
            }
            catch (Exception e) {
                ArchieActivator.LOG.log(String.valueOf(Messages.ACTION_NEWSTAT_ERROR_COULDNT_UPDATE_PROVIDER) + " " + provider.getName() + ".\n" + e.getLocalizedMessage(), 3);
                e.printStackTrace();
            }
            try {
                this.view = (StatisticsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.unibe.iam.scg.archie.ui.views.StatisticsView");
            }
            catch (PartInitException e) {
                ArchieActivator.LOG.log(String.valueOf(Messages.ACTION_NEWSTAT_ERROR_COULDNT_INIT_VIEW) + "\n" + e.getLocalizedMessage(), 3);
                e.printStackTrace();
            }
            this.view.clean();
            this.setEnabled(false);
            this.providerInformation = new ProviderInformatioPanel(this.view.getParent());
            this.providerInformation.updateProviderInformation(provider);
            ResultPanel resultComposite = new ResultPanel(this.view.getParent(), 0x800000);
            this.view.setResultComposite(resultComposite);
            this.view.getParent().layout();
            this.updateListeners();
            provider.schedule();
            provider.addJobChangeListener(this);
        } else {
            SWTHelper.showError((String)Messages.ERROR_FIELDS_NOT_VALID_TITLE, (String)Messages.ERROR_FIELDS_NOT_VALID);
        }
    }

    public void done(IJobChangeEvent event) {
        UiDesk.getDisplaySafe().ifPresent(d -> d.syncExec(() -> {
            ResultPanel results = this.view.getResultPanel();
            if (results != null && !results.isDisposed()) {
                AbstractDataProvider provider = ProviderManager.getInstance().getProvider();
                DataSet dataset = provider.getDataSet();
                results.removeLoadingMessage();
                if (dataset.isEmpty()) {
                    results.showEmptyMessage();
                } else {
                    TreeViewer viewer;
                    MenuManager menuManager = new MenuManager();
                    if (provider.isTree()) {
                        TreeFactory treeFactory = TreeFactory.getInstance();
                        viewer = treeFactory.createTreeFromData(results, dataset, provider, true);
                        viewer.setInput((Object)dataset);
                    } else {
                        TableFactory tableFactory = TableFactory.getInstance();
                        viewer = tableFactory.createTableFromData(results, dataset, provider.getLabelProvider(), (IContentProvider)provider.getContentProvider());
                        new DatasetTableColumnSorter((Table)viewer.getControl(), dataset);
                        TableManager.getInstance().setTable((Table)viewer.getControl());
                    }
                    Menu menu = menuManager.createContextMenu(viewer.getControl());
                    viewer.getControl().setMenu(menu);
                    this.view.getSite().registerContextMenu(menuManager, (ISelectionProvider)viewer);
                    this.view.getSite().setSelectionProvider((ISelectionProvider)viewer);
                }
                ChartModelManager.getInstance().clean();
                results.layout();
                this.setEnabled(true);
                for (IPropertyChangeListener listener : this.listeners) {
                    listener.propertyChange(new PropertyChangeEvent((Object)this, JOB_DONE, null, null));
                }
            }
        }));
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.listeners.remove(listener);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (ProviderManager.getInstance().hasProvider()) {
            this.setEnabled(true);
        }
    }

    private void updateListeners() {
        for (IPropertyChangeListener listener : this.listeners) {
            listener.propertyChange(new PropertyChangeEvent((Object)this, JOB_RUNNING, null, null));
        }
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }
}

