/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie;

import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.util.Log;
import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.model.AbstractDataProvider;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ArchieActivator
extends AbstractUIPlugin {
    private static ArchieActivator PLUGIN;
    public static final String PLUGIN_ID = "ch.unibe.iam.scg.archie";
    public static final String PLUGIN_NAME = "Archie";
    public static final String IMG_NEW_QUERY = "query";
    public static final String IMG_COFFEE = "coffee";
    public static final String IMG_IMPORTANT = "important";
    public static final String IMG_WARNING = "warningt";
    public static final String IMG_ERROR = "error";
    public static final String IMG_INFO = "info";
    public static final String IMG_CANCEL = "cancel";
    public static final String IMG_BUTTON_CALENDAR = "buttoCalendar";
    public static final String IMG_DEC_VALID = "decorationValid";
    public static final String IMG_CHART_PIE_BIG = "chartPieBig";
    public static final String IMG_CHART_BAR_BIG = "chartBarBig";
    public static final String IMG_PATIENT_MALE = "user";
    public static final String IMG_PATIENT_FEMALE = "user_female";
    public static final String IMG_GO = "go";
    public static final String IMG_REFRESH = "refresh";
    private static IPreferenceStore PREFERENCE_STORE;
    public static final Log LOG;
    private TreeMap<String, AbstractDataProvider> providers;
    private Hashtable<String, String> categories;

    static {
        PREFERENCE_STORE = null;
        LOG = Log.get((String)PLUGIN_NAME);
    }

    public ArchieActivator() {
        PLUGIN = this;
        LOG.log(Messages.ARCHIE_STARTED, -1);
        this.initializeAvailableCategories();
    }

    public static ArchieActivator getInstance() {
        return PLUGIN;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Image getImage(String descriptor) {
        return ArchieActivator.getInstance().getImageRegistry().get(descriptor);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        PLUGIN = null;
        super.stop(context);
    }

    public IPreferenceStore getPreferenceStore() {
        if (PREFERENCE_STORE == null) {
            PREFERENCE_STORE = new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL);
        }
        return PREFERENCE_STORE;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        super.initializeImageRegistry(registry);
        registry.put(IMG_NEW_QUERY, ArchieActivator.getImageDescriptor("icons/database_go.png"));
        registry.put(IMG_COFFEE, ArchieActivator.getImageDescriptor("icons/kteatime.png"));
        registry.put(IMG_IMPORTANT, ArchieActivator.getImageDescriptor("icons/important.png"));
        registry.put(IMG_WARNING, ArchieActivator.getImageDescriptor("icons/warning.png"));
        registry.put(IMG_ERROR, ArchieActivator.getImageDescriptor("icons/error.png"));
        registry.put(IMG_INFO, ArchieActivator.getImageDescriptor("icons/info.png"));
        registry.put(IMG_CANCEL, ArchieActivator.getImageDescriptor("icons/cancel.png"));
        registry.put(IMG_BUTTON_CALENDAR, ArchieActivator.getImageDescriptor("icons/calendar.png"));
        registry.put(IMG_DEC_VALID, ArchieActivator.getImageDescriptor("icons/tick.png"));
        registry.put(IMG_CHART_PIE_BIG, ArchieActivator.getImageDescriptor("icons/chart_pie_big.png"));
        registry.put(IMG_CHART_BAR_BIG, ArchieActivator.getImageDescriptor("icons/chart_bar_big.png"));
        registry.put(IMG_PATIENT_MALE, ArchieActivator.getImageDescriptor("icons/user.png"));
        registry.put(IMG_PATIENT_FEMALE, ArchieActivator.getImageDescriptor("icons/user_female.png"));
        registry.put(IMG_GO, ArchieActivator.getImageDescriptor("icons/control.png"));
        registry.put(IMG_REFRESH, ArchieActivator.getImageDescriptor("icons/arrow_circle_double.png"));
    }

    public TreeMap<String, AbstractDataProvider> getProviderTable() {
        if (this.providers == null) {
            this.providers = new TreeMap();
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IConfigurationElement[] extensions = reg.getConfigurationElementsFor("ch.unibe.iam.scg.archie.dataprovider");
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement element = extensions[i];
                if ("DataProvider".equals(element.getName())) {
                    try {
                        Object executable = element.createExecutableExtension("class");
                        if (executable instanceof AbstractDataProvider) {
                            String category = element.getAttribute("category") == null ? "" : String.valueOf(this.getCategoryNameFromId(element.getAttribute("category"))) + ": ";
                            AbstractDataProvider provider = (AbstractDataProvider)((Object)executable);
                            this.providers.put(String.valueOf(category) + provider.getName(), provider);
                        }
                    }
                    catch (CoreException e) {
                        String errorMessage = "Error while trying to load the data provider: " + element.getName() + "\n" + e.getLocalizedMessage();
                        LOG.log(errorMessage, 3);
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        return ArchieActivator.getInstance().providers;
    }

    private void initializeAvailableCategories() {
        if (this.categories == null) {
            this.categories = new Hashtable();
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = reg.getConfigurationElementsFor("ch.unibe.iam.scg.archie.dataprovider");
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                if ("category".equals(element.getName())) {
                    this.categories.put(element.getAttribute("id"), element.getAttribute("name"));
                }
                ++i;
            }
        }
    }

    private String getCategoryNameFromId(String categoryId) {
        if (this.categories == null) {
            String error = "Provider categories have to be initialized first.";
            LOG.log(error, 2);
            throw new IllegalStateException("Provider categories have to be initialized first.");
        }
        for (Map.Entry<String, String> category : this.categories.entrySet()) {
            if (!category.getKey().equals(categoryId)) continue;
            return category.getValue();
        }
        return "";
    }
}

