/*
 * Decompiled with CFR 0.152.
 */
package ch.pharmed.phmprescriber;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Artikel;
import ch.elexis.data.Prescription;
import ch.elexis.data.Rezept;
import ch.pharmed.phmprescriber.IADialog;
import ch.pharmed.phmprescriber.Interaction;
import ch.pharmed.phmprescriber.Physician;
import ch.pharmed.phmprescriber.Printer;
import ch.pharmedsolutions.www.rezeptserver.ArrayOfProduct;
import ch.pharmedsolutions.www.rezeptserver.Patient;
import ch.pharmedsolutions.www.rezeptserver.PrescriptionPortType;
import ch.pharmedsolutions.www.rezeptserver.PrescriptionResponse;
import ch.pharmedsolutions.www.rezeptserver.PrescriptionService;
import ch.pharmedsolutions.www.rezeptserver.Product;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class Sender {
    private Physician ph;
    private Rezept rp;
    private ch.elexis.data.Patient pat;
    private String GLN = "";
    private String presID;
    private String QRCode;
    private ResourceBundle messages;

    public Sender(Rezept pres, Physician phys) {
        this.ph = phys;
        this.rp = pres;
        if (this.rp != null) {
            this.pat = this.rp.getPatient();
        }
        this.messages = ResourceBundle.getBundle("ch.pharmed.phmprescriber.MessagesBundle", new Locale("de", "CH"));
    }

    public void setLanguage(Locale currentLocale) {
        this.messages = ResourceBundle.getBundle("ch.pharmed.phmprescriber.MessagesBundle", currentLocale);
    }

    public ResourceBundle getMessages() {
        return this.messages;
    }

    public void sendnprint() {
        Interaction IA;
        List<String> interactions;
        String strCFG;
        if (!this.isInputValid().booleanValue()) {
            return;
        }
        Shell shell = UiDesk.getDisplay().getActiveShell();
        if (this.ph.hasShops().booleanValue()) {
            HashMap<String, String> hmShops = this.ph.shops;
            Object[] ShopNames = hmShops.keySet().toArray(new String[0]);
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider());
            dialog.setElements(ShopNames);
            dialog.setTitle(this.messages.getString("Sender_5"));
            dialog.setMessage(this.messages.getString("Sender_6"));
            dialog.setMultipleSelection(false);
            dialog.setAllowDuplicates(false);
            if (dialog.open() == 0) {
                Object result = dialog.getFirstResult();
                this.GLN = hmShops.get((String)result);
            }
        }
        if ((strCFG = ConfigServiceHolder.getGlobal((String)"ch.pharmed.phmprescriber/check_interactions", (String)"")).equals("true") && (interactions = (IA = new Interaction()).checkPrescription(this.rp)) != null) {
            IADialog dialog = new IADialog(shell);
            dialog.setProductDescr(interactions);
            dialog.setResourceBundle(this.messages);
            dialog.create();
            if (dialog.open() != 0) {
                return;
            }
        }
        if (!this.postPrescription().booleanValue()) {
            SWTHelper.alert((String)this.messages.getString("Sender_9"), (String)this.messages.getString("Sender_10"));
            return;
        }
        Printer printer = new Printer(this.ph, this.rp, this.presID, this.QRCode);
    }

    private Boolean isInputValid() {
        if (this.rp == null) {
            SWTHelper.alert((String)this.messages.getString("Sender_11"), (String)this.messages.getString("Sender_12"));
            return false;
        }
        System.out.println(this.ph.getZsrid().length());
        if (this.ph.getZsrid().length() < 7) {
            SWTHelper.alert((String)this.messages.getString("Sender_13"), (String)this.messages.getString("Sender_14"));
            return false;
        }
        return true;
    }

    private Date convertStringtoDate(String strDate, String Format2) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(Format2);
        try {
            Date convertedDate = dateFormat.parse(strDate);
            return convertedDate;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Boolean postPrescription() {
        String defaultDateFormat = "dd.MM.yyyy";
        ch.pharmedsolutions.www.rezeptserver.Prescription prescription = new ch.pharmedsolutions.www.rezeptserver.Prescription();
        prescription.setSoftware(BigInteger.valueOf(10L));
        prescription.setPassword("mdjKhd8J39Ad=idk=");
        prescription.setZsrId(this.ph.getZsrid());
        if (this.GLN.length() == 13) {
            prescription.setGLNTargetpharmacy(this.GLN);
        }
        prescription.setDate(this.convertStringToGregorian(this.rp.getDate(), defaultDateFormat));
        Patient patient = new Patient();
        patient.setFirstName(this.pat.getVorname());
        patient.setLastName(this.pat.getName());
        patient.setBirthDate(this.convertStringToGregorian(this.pat.getGeburtsdatum(), defaultDateFormat));
        prescription.setPatient(patient);
        ArrayOfProduct arrayOfProducts = new ArrayOfProduct();
        Product[] Products = new Product[this.rp.getLines().size()];
        int i = 0;
        while (i < this.rp.getLines().size()) {
            Products[i] = new Product();
            Prescription actualLine = (Prescription)this.rp.getLines().get(i);
            Pattern pattern = Pattern.compile("([0-9.]{1,5})([-])([0-9.]{1,5})([-])([0-9.]{1,5})([-])([0-9.]{0,5})([0-9])");
            Matcher matcher = pattern.matcher(actualLine.getDosis());
            if (matcher.find()) {
                Products[i].setPosology(actualLine.getDosis());
                Products[i].setRemark(actualLine.getBemerkung());
            } else if (actualLine.getDosis().length() > 0) {
                Products[i].setRemark(String.valueOf(actualLine.getDosis()) + ", " + actualLine.getBemerkung());
            } else {
                Products[i].setRemark(actualLine.getBemerkung());
            }
            Artikel article = actualLine.getArtikel();
            Products[i].setPharmacode(null);
            Products[i].setEanId(null);
            if (article.getPharmaCode().length() > 0) {
                Products[i].setPharmacode(new BigInteger(article.getPharmaCode()));
            }
            if (article.getEAN().length() > 0) {
                Products[i].setEanId(new BigInteger(article.getEAN()));
            }
            if (Products[i].getPharmacode() == null & Products[i].getEanId() == null) {
                Products[i].setPharmacode(BigInteger.valueOf(111L));
                Products[i].setEanId(BigInteger.valueOf(111L));
                Products[i].setProductName(article.getLabel());
            }
            Products[i].setPrescriptorQty(1);
            Products[i].setPrescriptorRepetitionEnd(null);
            arrayOfProducts.getItem().add(Products[i]);
            ++i;
        }
        prescription.setProducts(arrayOfProducts);
        PrescriptionResponse response = new PrescriptionResponse();
        try {
            response = this.consumService(prescription);
            if (response != null) {
                this.presID = response.getPrescriptionID();
                this.QRCode = response.getQRCodeString();
                System.out.println("Success");
                return true;
            }
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex);
        }
        return false;
    }

    private PrescriptionResponse consumService(ch.pharmedsolutions.www.rezeptserver.Prescription prescription) {
        PrescriptionService service = new PrescriptionService();
        PrescriptionPortType port = service.getPrescriptionPort();
        return port.postPrescription(prescription);
    }

    private XMLGregorianCalendar convertStringToGregorian(String pDate, String dateFormat) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(this.convertStringtoDate(pDate, dateFormat));
        XMLGregorianCalendar finaldate = null;
        try {
            finaldate = DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        return finaldate;
    }
}

