/*
 * Decompiled with CFR 0.152.
 */
package ch.novcom.elexis.mednet.plugin.ui.preferences;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.WidgetFactory;
import ch.novcom.elexis.mednet.plugin.MedNet;
import ch.novcom.elexis.mednet.plugin.messages.MedNetMessages;
import java.nio.file.Paths;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MainPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    Text exePath;
    private Button exePathSelection;
    private Text purgeInterval;

    public MainPreferencePage() {
        super(1);
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout(3, false));
        WidgetFactory.createLabel((Composite)ret, (String)MedNetMessages.MainPreferences_labelExePath);
        this.exePath = new Text(ret, 2048);
        this.exePath.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.exePath.setTextLimit(80);
        this.exePath.setEnabled(false);
        if (MedNet.getSettings().getExePath() != null) {
            this.exePath.setText(MedNet.getSettings().getExePath().toString());
        }
        this.exePathSelection = new Button(ret, 8);
        this.exePathSelection.setText("...");
        this.exePathSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(MainPreferencePage.this.getShell());
                dialog.setText(MedNetMessages.MainPreferences_labelExePath);
                if (System.getProperty("os.name").contains("Windows")) {
                    dialog.setFilterExtensions(new String[]{"*.exe"});
                }
                String selected = dialog.open();
                MainPreferencePage.this.exePath.setText(selected);
            }
        });
        WidgetFactory.createLabel((Composite)ret, (String)MedNetMessages.MainPreferences_labelPurgeInterval);
        this.purgeInterval = new Text(ret, 2048);
        this.purgeInterval.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.purgeInterval.setTextLimit(80);
        this.purgeInterval.setText(String.valueOf(MedNet.getSettings().getArchivePurgeInterval()));
        this.purgeInterval.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text text = (Text)e.getSource();
                String oldS = text.getText();
                String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                boolean isInteger = true;
                int newInt = -1;
                try {
                    newInt = Integer.parseInt(newS);
                }
                catch (NumberFormatException ex) {
                    isInteger = false;
                }
                if (!isInteger || newInt < 0) {
                    e.doit = false;
                }
            }
        });
        return ret;
    }

    public boolean performOk() {
        MedNet.getSettings().setExePath(Paths.get(this.exePath.getText(), new String[0]));
        MedNet.getSettings().setArchivePurgeInterval(Integer.valueOf(this.purgeInterval.getText()));
        MedNet.getSettings().saveSettings();
        return true;
    }

    public void performDefaults() {
        this.purgeInterval.setText(String.valueOf(60));
    }

    protected void createFieldEditors() {
    }

    public void init(IWorkbench workbench) {
    }
}

