/*
 * Decompiled with CFR 0.152.
 */
package ch.novcom.elexis.mednet.plugin.ui.preferences;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Query;
import ch.novcom.elexis.mednet.plugin.MedNet;
import ch.novcom.elexis.mednet.plugin.data.ContactLinkRecord;
import ch.novcom.elexis.mednet.plugin.messages.MedNetMessages;
import ch.novcom.elexis.mednet.plugin.ui.dialog.ContactLinkRecordEditDialog;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class ContactLinkPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer tableViewer;
    private Table table;
    private String[] tableheaders = new String[]{MedNetMessages.ContactLinkPreferences_MedNetId, MedNetMessages.ContactLinkPreferences_MedNetName, MedNetMessages.ContactLinkPreferences_ContactLabel, MedNetMessages.ContactLinkPreferences_DocImport, MedNetMessages.ContactLinkPreferences_DocImportId, MedNetMessages.ContactLinkPreferences_FormImport, MedNetMessages.ContactLinkPreferences_XIDDomain};
    private int[] tableColwidth = new int[]{8, 19, 19, 19, 8, 19, 8};

    public ContactLinkPreferencePage() {
        super(MedNetMessages.ContactLinkPreferences_title);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite tableComposite = new Composite(parent, 0);
        GridData gd = new GridData();
        tableComposite.setLayoutData((Object)gd);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer = new TableViewer(tableComposite, 67584);
        this.table = this.tableViewer.getTable();
        int i = 0;
        while (i < this.tableheaders.length) {
            TableColumn tc = new TableColumn(this.table, 16384);
            tc.setText(this.tableheaders[i]);
            tableColumnLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(this.tableColwidth[i], true));
            tc.setData((Object)i);
            tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ContactLinkPreferencePage.this.tableViewer.refresh(true);
                }
            });
            ++i;
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ContactLinkRecord.getAllContactLinkRecords().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ReceivingListLabelProvider());
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)ContactLinkPreferencePage.this.tableViewer.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof ContactLinkRecord) {
                    ContactLinkRecord li = (ContactLinkRecord)o;
                    ContactLinkRecordEditDialog dialog = new ContactLinkRecordEditDialog(ContactLinkPreferencePage.this.getShell(), li);
                    if (dialog.open() == 0) {
                        ContactLinkPreferencePage.this.tableViewer.refresh();
                    }
                }
            }
        });
        this.tableViewer.setInput((Object)this);
        return tableComposite;
    }

    protected void contributeButtons(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button bNewItem = new Button(parent, 8);
        bNewItem.setText(MedNetMessages.ContactLinkPreferences_new);
        bNewItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
                    handlerService.executeCommand("ch.novcom.elexis.mednet.plugin.data.contactlinkrecord.create", null);
                }
                catch (Exception ex) {
                    throw new RuntimeException("ch.novcom.elexis.mednet.plugin.data.contactlinkrecord.create", ex);
                }
                ContactLinkPreferencePage.this.tableViewer.refresh();
            }
        });
        ++((GridLayout)parent.getLayout()).numColumns;
        Button bDelItem = new Button(parent, 8);
        bDelItem.setText(MedNetMessages.ContactLinkPreferences_delete);
        bDelItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)ContactLinkPreferencePage.this.tableViewer.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof ContactLinkRecord) {
                    ContactLinkRecord li = (ContactLinkRecord)o;
                    if (MessageDialog.openQuestion((Shell)ContactLinkPreferencePage.this.getShell(), (String)MedNetMessages.ContactLinkPreferences_delete, (String)MessageFormat.format(MedNetMessages.ContactLinkPreferences_reallyDelete, li.getLabel()))) {
                        if (ContactLinkPreferencePage.this.deleteRecord(li)) {
                            li.removeFromDatabase();
                            ContactLinkPreferencePage.this.tableViewer.remove((Object)li);
                        } else {
                            MessageDialog.openWarning((Shell)ContactLinkPreferencePage.this.getShell(), (String)MedNetMessages.ContactLinkPreferences_delete, (String)MedNetMessages.ContactLinkPreferences_deleteFailed);
                        }
                    }
                }
            }
        });
        ++((GridLayout)parent.getLayout()).numColumns;
        Button bDelAllItems = new Button(parent, 8);
        bDelAllItems.setText(MedNetMessages.ContactLinkPreferences_deleteAll);
        bDelAllItems.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SWTHelper.askYesNo((String)MedNetMessages.ContactLinkPreferences_deleteAllTitle, (String)MedNetMessages.ContactLinkPreferences_deleteAllExplain)) {
                    Query qbli = new Query(ContactLinkRecord.class);
                    List items = qbli.execute();
                    boolean success = true;
                    for (ContactLinkRecord li : items) {
                        if (ContactLinkPreferencePage.this.deleteRecord(li)) {
                            li.removeFromDatabase();
                            continue;
                        }
                        success = false;
                    }
                    if (!success) {
                        MessageDialog.openWarning((Shell)ContactLinkPreferencePage.this.getShell(), (String)MedNetMessages.ContactLinkPreferences_deleteAll, (String)MedNetMessages.ContactLinkPreferences_deleteAllFailed);
                    }
                    ContactLinkPreferencePage.this.tableViewer.refresh();
                }
            }
        });
        if (!AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(ILabItem.class, (Right)Right.DELETE))) {
            bDelAllItems.setEnabled(false);
        }
    }

    private boolean deleteRecord(ContactLinkRecord li) {
        boolean ret = true;
        Query qbe = new Query(ContactLinkRecord.class);
        qbe.add("id", "=", li.getId());
        List list = qbe.execute();
        for (ContactLinkRecord po : list) {
            po.removeFromDatabase();
        }
        return ret;
    }

    public Point computeSize() {
        return new Point(350, 350);
    }

    static class ReceivingListLabelProvider
    extends ColumnLabelProvider
    implements ITableLabelProvider {
        ReceivingListLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ContactLinkRecord contactLinkRecord = (ContactLinkRecord)element;
            Kontakt kontakt = Kontakt.load((String)contactLinkRecord.getContactID());
            switch (columnIndex) {
                case 0: {
                    return contactLinkRecord.getMedNetID();
                }
                case 1: {
                    return MedNet.getSettings().getInstitutions().get(contactLinkRecord.getMedNetID());
                }
                case 2: {
                    return kontakt.getLabel(true);
                }
                case 3: {
                    return String.valueOf(contactLinkRecord.docImport_isActive() ? "on" : "off") + (contactLinkRecord.getCategoryDoc().isEmpty() ? "" : " ( " + contactLinkRecord.getCategoryDoc() + " )");
                }
                case 4: {
                    return contactLinkRecord.getDocImport_id();
                }
                case 5: {
                    return String.valueOf(contactLinkRecord.formImport_isActive() ? "on" : "off") + (contactLinkRecord.getCategoryForm().isEmpty() ? "" : " ( " + contactLinkRecord.getCategoryForm() + " )");
                }
                case 6: {
                    return contactLinkRecord.getXIDDomain();
                }
            }
            return "?col?";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

