/*
 * Decompiled with CFR 0.152.
 */
package ch.novcom.elexis.mednet.plugin.data;

import ch.elexis.core.importer.div.importers.ILabItemResolver;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.importer.div.importers.DefaultHL7Parser;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Xid;
import ch.novcom.elexis.mednet.plugin.MedNet;
import ch.novcom.elexis.mednet.plugin.MedNetConfigFormItem;
import ch.novcom.elexis.mednet.plugin.MedNetLabItemResolver;
import ch.novcom.elexis.mednet.plugin.data.ContactLinkRecord;
import ch.novcom.elexis.mednet.plugin.data.PatientDocumentManager;
import ch.novcom.elexis.mednet.plugin.messages.MedNetMessages;
import ch.rgw.tools.Result;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DocumentImporter.class.getName());
    private static final Pattern documentFilenamePattern = Pattern.compile("^([^_]*_)*(?<uniqueMessageId>[^_]+)_(?<caseNr>[^_]*)_(?<transactionDateTime>[^_]*)_(?<orderNr>[^_]+)_(?<samplingDateTime>[^_]*)_(?<PatientLastName>[^_]*)_(?<PatientBirthdate>[0-9]{8})?_(?<PatientId>[^_]*)_(?<recipient>\\d+)$");
    private static final Pattern formFilenamePattern = Pattern.compile("^(?<transactionDateTime>[0-9]{14})_(?<sender>[^_]*)_(?<PatientId>[^_]*)_(?<PatientLastName>[^_]*)_(?<PatientFirstName>[^_]*)_(?<PatientBirthdate>[0-9]{8})?_(?<institutionId>[^_]*)_(?<formId>[^_]*)_(?<orderNr>[^_]*)$");
    private static final SimpleDateFormat documentDateTimeParser = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final SimpleDateFormat documentDateParser = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat birthdateParser = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat birthdateHumanReadableFormatter = new SimpleDateFormat("dd-MM-yyyy");
    private static final Pattern hl7PatientPattern = Pattern.compile("^PID\\|[^\\|]*\\|(?<id>[^\\|]*)\\|(?<institutionId>[^\\|]*)\\|[^\\|]*\\|(?<lastname>[^\\|\\^]*)\\^?(?<firstname>[^\\|\\^]*)[^\\|]*\\|[^\\|]*\\|(?<birthdate>[^\\|]*)\\|(?<gender>[^\\|]*)\\|.*$");
    private static final Charset DEFAULT_HL7_INPUTENCODING = Charset.forName("ISO-8859-1");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean process(Path hl7File, Path pdfFile, ContactLinkRecord contactLink, Kontakt institution, boolean overwriteOlderEntries, boolean askUser) throws IOException {
        String logPrefix = "process() - ";
        boolean success = true;
        Patient patient = null;
        if (hl7File != null) {
            LOGGER.info(String.valueOf(logPrefix) + "Import document -- HL7: " + hl7File.toString());
        }
        if (pdfFile != null) {
            LOGGER.info(String.valueOf(logPrefix) + "Import document -- PDF: " + pdfFile.toString());
        }
        if (hl7File != null && Files.exists(hl7File, new LinkOption[0]) && Files.isRegularFile(hl7File, new LinkOption[0])) {
            block31: {
                String docImportId = institution.getId();
                if (contactLink.getDocImport_id() != null && !contactLink.getDocImport_id().isEmpty()) {
                    docImportId = contactLink.getDocImport_id();
                }
                DefaultHL7Parser hlp = new DefaultHL7Parser(docImportId);
                try {
                    Result res = null;
                    res = contactLink.getDocImport_id() != null && !contactLink.getDocImport_id().isEmpty() ? hlp.importFile(hl7File.toFile(), null, false) : hlp.importFile(hl7File.toFile(), null, (ILabItemResolver)new MedNetLabItemResolver(institution.getLabel(true)), false);
                    if (res.isOK()) {
                        IPatient ipat = hlp.hl7Reader.getPatient();
                        patient = DocumentImporter.getPatient(ipat.getId(), ipat.getLastName(), ipat.getFirstName(), ipat.getDateOfBirth().format(DateTimeFormatter.ofPattern("yyyyMMdd")), ipat.getGender().value(), false);
                        success = true;
                        break block31;
                    }
                    LOGGER.error(String.valueOf(logPrefix) + "Unable to import the hl7.");
                    return false;
                }
                catch (Exception ex) {
                    success = false;
                    LOGGER.error(String.valueOf(logPrefix) + "Exception importing the hl7. ", (Throwable)ex);
                }
            }
            if (success && patient != null && contactLink.getXIDDomain() != null && !contactLink.getXIDDomain().isEmpty()) {
                String patient_institutionId = null;
                try {
                    BufferedReader lineReader = Files.newBufferedReader(hl7File, DEFAULT_HL7_INPUTENCODING);
                    int nbMatches = 0;
                    int i = 0;
                    while (i < 4 && lineReader.ready() && nbMatches < 3) {
                        String line = lineReader.readLine();
                        Matcher patientMatcher = hl7PatientPattern.matcher(line);
                        if (patientMatcher.matches()) {
                            ++nbMatches;
                            patient_institutionId = patientMatcher.group("institutionId");
                            break;
                        }
                        ++i;
                    }
                    lineReader.close();
                }
                catch (IOException ioe) {
                    LOGGER.error(String.valueOf(logPrefix) + "Unable to load the hl7 file. ", (Throwable)ioe);
                }
                if (patient_institutionId != null && !patient_institutionId.isEmpty()) {
                    try {
                        Xid.localRegisterXIDDomainIfNotExists((String)contactLink.getXIDDomain(), (String)institution.getLabel(true), (int)1);
                        String db_patient_institutionId = DocumentImporter.getInstitutionXID(contactLink.getXIDDomain(), patient);
                        if (db_patient_institutionId == null) {
                            new Xid((PersistentObject)patient, contactLink.getXIDDomain(), patient_institutionId);
                            LOGGER.info(MessageFormat.format("xid {0} ({2}) successfully saved to Patient {1}", patient_institutionId, patient.getLabel(), institution.getLabel(true)));
                        } else if (db_patient_institutionId.equals(patient_institutionId)) {
                            DocumentImporter.deleteInstitutionXID(contactLink.getXIDDomain(), patient);
                            new Xid((PersistentObject)patient, contactLink.getXIDDomain(), patient_institutionId);
                            LOGGER.info(MessageFormat.format("xid {0} ({2}) from Patient {1} successfully updated (old value {3})", patient_institutionId, patient.getLabel(), institution.getLabel(true), db_patient_institutionId));
                        }
                    }
                    catch (Xid.XIDException e) {
                        LOGGER.error(MessageFormat.format("xid {0} ({2}) has not been saved to Patient {1}", patient_institutionId, patient.getLabel(), institution.getLabel(true)), (Throwable)e);
                    }
                }
            }
        }
        if (!success) return success;
        if (pdfFile == null) return success;
        if (!Files.exists(pdfFile, new LinkOption[0])) return success;
        if (!Files.isRegularFile(pdfFile, new LinkOption[0])) return success;
        String samplingDateTime = "";
        String transmissionDateTime = "";
        String patientId = "";
        String patientLastName = "";
        String patientFirstName = "";
        String patientBirthDate = "";
        String orderNr = "";
        Matcher filenameMatcher = documentFilenamePattern.matcher(DocumentImporter.getBaseName(pdfFile));
        if (!filenameMatcher.matches()) {
            LOGGER.warn("The PDF filename has not the expected Pattern and cannot be imported into omnivore:" + pdfFile);
            return success;
        }
        samplingDateTime = filenameMatcher.group("samplingDateTime");
        transmissionDateTime = filenameMatcher.group("transactionDateTime");
        patientId = filenameMatcher.group("PatientId");
        patientLastName = filenameMatcher.group("PatientLastName");
        patientBirthDate = filenameMatcher.group("PatientBirthdate");
        orderNr = filenameMatcher.group("orderNr");
        if (patient == null) {
            patient = DocumentImporter.getPatient(patientId, patientLastName, patientFirstName, patientBirthDate, "", askUser);
        }
        if (patient == null) return false;
        PatientDocumentManager documentManager = new PatientDocumentManager(patient);
        if (documentManager == null) return success;
        Date samplingDateTimeObj = null;
        if (samplingDateTime != null && !samplingDateTime.isEmpty()) {
            try {
                samplingDateTimeObj = documentDateTimeParser.parse(samplingDateTime);
            }
            catch (ParseException pe1) {
                try {
                    samplingDateTimeObj = documentDateParser.parse(samplingDateTime);
                }
                catch (ParseException pe2) {
                    LOGGER.warn("process Unable to parse samplingDateTime:" + samplingDateTime, (Throwable)pe2);
                }
            }
        }
        Date transmissionDateTimeObj = null;
        if (transmissionDateTime != null && !transmissionDateTime.isEmpty()) {
            try {
                transmissionDateTimeObj = documentDateTimeParser.parse(transmissionDateTime);
            }
            catch (ParseException pe1) {
                try {
                    transmissionDateTimeObj = documentDateParser.parse(transmissionDateTime);
                }
                catch (ParseException pe2) {
                    LOGGER.warn("process Unable to parse transmissionDateTime:" + transmissionDateTime, (Throwable)pe2);
                }
            }
        }
        if (transmissionDateTimeObj != null) {
            String keywords = orderNr;
            documentManager.addDocument(contactLink, institution, orderNr, pdfFile, samplingDateTimeObj, transmissionDateTimeObj, keywords);
            return true;
        }
        LOGGER.warn("No valid transmissionDateTime found in the filename:" + pdfFile + " the file will not be imported in Omnivore");
        return success;
    }

    public static boolean processForm(Path pdfFile, boolean askUser) throws IOException {
        String logPrefix = "processForm() - ";
        boolean success = false;
        Patient patient = null;
        if (pdfFile != null && Files.exists(pdfFile, new LinkOption[0]) && Files.isRegularFile(pdfFile, new LinkOption[0])) {
            PatientDocumentManager documentManager;
            LOGGER.info(String.valueOf(logPrefix) + "import form -- PDF: " + pdfFile.toString());
            String documentDateTime = "";
            String patientId = "";
            String patientLastName = "";
            String patientFirstName = "";
            String patientBirthDate = "";
            String orderNr = "";
            String institutionId = "";
            String institutionName = "";
            String formularId = "";
            String formularName = "";
            ContactLinkRecord contactLink = null;
            Matcher filenameMatcher = formFilenamePattern.matcher(DocumentImporter.getBaseName(pdfFile));
            if (filenameMatcher.matches()) {
                List<ContactLinkRecord> contactLinkList;
                documentDateTime = filenameMatcher.group("transactionDateTime");
                patientId = filenameMatcher.group("PatientId");
                patientLastName = filenameMatcher.group("PatientLastName");
                patientLastName = filenameMatcher.group("PatientFirstName");
                patientBirthDate = filenameMatcher.group("PatientBirthdate");
                orderNr = filenameMatcher.group("orderNr");
                institutionId = filenameMatcher.group("institutionId");
                formularId = filenameMatcher.group("formId");
                Map<String, Map<String, MedNetConfigFormItem>> configFormItems = MedNet.getSettings().getConfigFormItems();
                if (configFormItems.containsKey(institutionId) && configFormItems.get(institutionId).containsKey(formularId)) {
                    MedNetConfigFormItem item = configFormItems.get(institutionId).get(formularId);
                    formularName = item.getFormName();
                    institutionName = item.getInstitutionName();
                }
                if ((contactLinkList = ContactLinkRecord.getContactLinkRecord(null, institutionId)) != null && contactLinkList.size() > 0 && (contactLink = contactLinkList.get(0)) != null && !contactLink.formImport_isActive()) {
                    LOGGER.info(String.valueOf(logPrefix) + "import ignored for " + institutionName);
                    return true;
                }
            }
            if ((patient = DocumentImporter.getPatient(patientId, patientLastName, patientFirstName, patientBirthDate, "", askUser)) != null && (documentManager = new PatientDocumentManager(patient)) != null) {
                Date documentDateTimeObj = new Date();
                try {
                    documentDateTimeObj = documentDateTimeParser.parse(documentDateTime);
                }
                catch (ParseException pe) {
                    LOGGER.warn(String.valueOf(logPrefix) + "Unable to parse documentDateTime:" + documentDateTime, (Throwable)pe);
                }
                String keywords = orderNr;
                documentManager.addForm(contactLink, institutionName, formularName, orderNr, pdfFile, documentDateTimeObj, keywords);
                success = true;
            }
        } else if (pdfFile != null) {
            LOGGER.error(String.valueOf(logPrefix) + "following file is not valid: " + pdfFile.toString());
        } else {
            LOGGER.error(String.valueOf(logPrefix) + "the file is null");
        }
        return success;
    }

    private static Patient getPatient(String id, String lastname, String firstname, String birthdate, String sex, boolean askUser) {
        String logPrefix = "getPatient() - ";
        Patient patient = null;
        if (id != null && !id.isEmpty()) {
            patient = DocumentImporter.getPatientFromDB(id);
        }
        if (patient == null) {
            if (!(lastname == null || lastname.isEmpty() || firstname == null || firstname.isEmpty() || birthdate == null || birthdate.isEmpty() || (patient = DocumentImporter.getPatientFromDB(lastname, firstname, birthdate, sex)) == null)) {
                LOGGER.debug(String.valueOf(logPrefix) + "Patient found in the database. " + patient.getLabel());
            }
            if (patient == null) {
                if (askUser) {
                    patient = DocumentImporter.patientSelectorDialog(lastname, firstname, birthdate, sex);
                }
                if (patient != null) {
                    LOGGER.debug(String.valueOf(logPrefix) + "Patient identified by the user. " + patient.getLabel());
                } else {
                    LOGGER.warn(String.valueOf(logPrefix) + "Patient identification aborded by the user. ");
                }
            }
        }
        return patient;
    }

    private static Patient patientSelectorDialog(String lastname, String firstname, String birthdate, String sex) {
        String logPrefix = "patientSelectorDialog() - ";
        Patient retVal = null;
        String birthdateString = birthdate;
        try {
            birthdateString = birthdateHumanReadableFormatter.format(birthdateParser.parse(birthdate));
        }
        catch (ParseException e) {
            LOGGER.error(String.valueOf(logPrefix) + "Unable to parse birthdate " + birthdate);
        }
        retVal = (Patient)KontaktSelektor.showInSync(Patient.class, (String)MedNetMessages.DocumentImporter_SelectPatient, (String)MessageFormat.format(MedNetMessages.DocumentImporter_WhoIs, lastname, firstname, birthdateString, sex));
        return retVal;
    }

    private static Patient getPatientFromDB(String patId) {
        String logPrefix = "getPatientFromDB() - ";
        Query patientQuery = new Query(Patient.class);
        patientQuery.add("PatientNr", "=", patId);
        List result = patientQuery.execute();
        if (result.size() == 1) {
            return (Patient)result.get(0);
        }
        if (result.size() >= 1) {
            LOGGER.error(String.valueOf(logPrefix) + "Multiple patients found with the id :" + patId);
            return null;
        }
        return null;
    }

    public static Patient getPatientFromDB(String lastname, String firstname, String birthdate, String sex) {
        List result;
        Query patientQuery = new Query(Patient.class);
        if (lastname != null && !lastname.isEmpty()) {
            patientQuery.add("Name", "=", lastname);
        }
        if (firstname != null && !firstname.isEmpty()) {
            patientQuery.add("Vorname", "=", firstname);
        }
        if (birthdate != null && !birthdate.isEmpty()) {
            patientQuery.add("Geburtsdatum", "=", birthdate);
        }
        if (sex != null && !sex.isEmpty()) {
            String sexParam = sex.toLowerCase();
            if ("f".equals(sexParam)) {
                sexParam = "w";
            }
            patientQuery.add("Geschlecht", "=", sexParam);
        }
        if ((result = patientQuery.execute()).size() == 1) {
            return (Patient)result.get(0);
        }
        if (result.size() >= 1) {
            LOGGER.error("getPatientFromDB() Multiple patients found for :" + lastname + " " + firstname + " " + birthdate + " " + sex);
            return null;
        }
        return null;
    }

    public static String getBaseName(Path file) {
        int pos = file.getFileName().toString().lastIndexOf(".");
        if (pos > 0) {
            return file.getFileName().toString().substring(0, pos);
        }
        return file.getFileName().toString();
    }

    public static String getExtension(Path file) {
        int pos = file.getFileName().toString().lastIndexOf(".");
        if (pos > 1) {
            return file.getFileName().toString().substring(pos + 1);
        }
        return file.getFileName().toString();
    }

    public static String getInstitutionXID(String xidDomain, Patient patient) {
        Query patientInstitutionXIDQuery = new Query(Xid.class);
        patientInstitutionXIDQuery.add("object", "=", patient.getId());
        patientInstitutionXIDQuery.add("domain", "=", xidDomain);
        List patienten = patientInstitutionXIDQuery.execute();
        if (patienten.isEmpty()) {
            return null;
        }
        return ((Xid)patienten.get(0)).getDomainId();
    }

    public static void deleteInstitutionXID(String xidDomain, Patient patient) {
        Query patientInstitutionXIDQuery = new Query(Xid.class);
        patientInstitutionXIDQuery.add("object", "=", patient.getId());
        patientInstitutionXIDQuery.add("domain", "=", xidDomain);
        List patientenXids = patientInstitutionXIDQuery.execute();
        if (patientenXids.isEmpty()) {
            return;
        }
        for (Xid xid : patientenXids) {
            xid.delete();
        }
    }
}

