/*
 * Decompiled with CFR 0.152.
 */
package ch.novcom.elexis.mednet.plugin;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.novcom.elexis.mednet.plugin.MedNet;
import ch.novcom.elexis.mednet.plugin.MedNetConfigDocumentPath;
import ch.novcom.elexis.mednet.plugin.MedNetConfigFormItem;
import ch.novcom.elexis.mednet.plugin.MedNetConfigFormPath;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MedNetSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MedNetSettings.class.getName());
    public static final String PLUGIN_ID = "ch.novcom.elexis.mednet.plugin";
    public static final String cfgBase = "ch/novcom/elexis/mednet/plugin";
    public static final int DEFAULT_ARCHIVEPURGEINTERVAL = 60;
    public static final int DEFAULT_DBVERSION = 0;
    public static final String cfgExePath = "ch/novcom/elexis/mednet/plugin/exe";
    public static final String cfgFormsArchivePurgeInterval = "ch/novcom/elexis/mednet/plugin/archivePurgeIntervalDays";
    public static final String cfgDBVersion = "ch/novcom/elexis/mednet/plugin/dbVersion";
    private int dbVersion;
    private Path exePath;
    private int archivePurgeInterval;
    private Map<String, MedNetConfigFormPath> configFormPaths = null;
    private Set<MedNetConfigDocumentPath> configDocumentPaths = null;
    private Map<String, String> institutionsList = null;
    private Map<String, Map<String, MedNetConfigFormItem>> configFormItems = null;

    public MedNetSettings() {
        this.loadSettings();
    }

    public int getDBVersion() {
        return this.dbVersion;
    }

    public void setDBVersion(int dbVersion) {
        this.dbVersion = dbVersion;
    }

    public Path getExePath() {
        return this.exePath;
    }

    public void setExePath(Path path) {
        this.exePath = path;
    }

    public int getArchivePurgeInterval() {
        return this.archivePurgeInterval;
    }

    public void setArchivePurgeInterval(int interval) {
        this.archivePurgeInterval = interval;
    }

    public Map<String, MedNetConfigFormPath> getConfigFormPaths() {
        if (this.configFormPaths == null && this.exePath != null) {
            this.configFormPaths = MedNet.export_ConfigForms();
        }
        return this.configFormPaths;
    }

    public Set<MedNetConfigDocumentPath> getConfigDocumentPaths() {
        if (this.configDocumentPaths == null && this.exePath != null) {
            this.configDocumentPaths = MedNet.export_ConfigResults();
        }
        return this.configDocumentPaths;
    }

    public Map<String, String> getInstitutions() {
        if (this.institutionsList == null) {
            this.institutionsList = new TreeMap<String, String>();
            for (Map<String, MedNetConfigFormItem> formItemMap : this.getConfigFormItems().values()) {
                for (MedNetConfigFormItem formItem : formItemMap.values()) {
                    this.institutionsList.putIfAbsent(formItem.getInstitutionID(), formItem.getInstitutionName());
                }
            }
            for (MedNetConfigDocumentPath docItem : this.getConfigDocumentPaths()) {
                this.institutionsList.putIfAbsent(docItem.getInstitutionID(), docItem.getInstitutionName());
            }
        }
        return this.institutionsList;
    }

    public Map<String, Map<String, MedNetConfigFormItem>> getConfigFormItems() {
        if (this.configFormItems == null && this.exePath != null) {
            this.configFormItems = MedNet.listForms();
        }
        return this.configFormItems;
    }

    public void loadSettings() {
        String cfgDBVersionString;
        String cfgFormsArchivePurgeIntervalString;
        String logPrefix = "loadSettings() - ";
        String exePathString = ConfigServiceHolder.getGlobal((String)cfgExePath, (String)"");
        if (exePathString != null && !exePathString.isEmpty()) {
            this.exePath = Paths.get(exePathString, new String[0]);
            if (!Files.isRegularFile(this.exePath, new LinkOption[0])) {
                LOGGER.error(String.valueOf(logPrefix) + "MedNet exe path: " + this.exePath.toString() + " is not a valid file");
                this.exePath = null;
            }
        }
        if ((cfgFormsArchivePurgeIntervalString = ConfigServiceHolder.getGlobal((String)cfgFormsArchivePurgeInterval, (String)"")) != null && !cfgFormsArchivePurgeIntervalString.isEmpty()) {
            try {
                this.archivePurgeInterval = Integer.parseInt(cfgFormsArchivePurgeIntervalString);
            }
            catch (Exception e) {
                this.archivePurgeInterval = -1;
                LOGGER.error(String.valueOf(logPrefix) + "Form archive purge interval: " + cfgFormsArchivePurgeIntervalString + " is not a valid number");
            }
        } else {
            this.archivePurgeInterval = 60;
        }
        if ((cfgDBVersionString = ConfigServiceHolder.getGlobal((String)cfgDBVersion, (String)"")) != null && !cfgDBVersionString.isEmpty()) {
            try {
                this.dbVersion = Integer.parseInt(cfgDBVersionString);
            }
            catch (Exception e) {
                this.dbVersion = -1;
                LOGGER.error(String.valueOf(logPrefix) + "DB Version: " + cfgDBVersionString + " is not a valid number");
            }
        } else {
            this.dbVersion = 0;
        }
    }

    public void saveSettings() {
        if (this.exePath != null) {
            ConfigServiceHolder.setGlobal((String)cfgExePath, (String)this.exePath.toString());
        }
        ConfigServiceHolder.setGlobal((String)cfgFormsArchivePurgeInterval, (int)this.archivePurgeInterval);
        ConfigServiceHolder.setGlobal((String)cfgDBVersion, (int)this.dbVersion);
    }
}

