/*
 * Decompiled with CFR 0.152.
 */
package ch.ngiger.comm.vpn;

import ch.elexis.core.events.MessageEvent;
import ch.rgw.tools.ExHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import org.eclipse.swt.program.Program;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenVPN {
    Logger logger = LoggerFactory.getLogger(OpenVPN.class);

    public boolean ping(String hostname) {
        boolean result = false;
        try {
            result = InetAddress.getByName(hostname).isReachable(3000);
        }
        catch (UnknownHostException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean openConnection(String ovpnConfig, String ovpnIp, int timeout) {
        try {
            String ext = ".ovpn";
            File temp = File.createTempFile("start_ovpn", ".cmd");
            temp.deleteOnExit();
            File myFile = new File(ovpnConfig);
            File parent = new File(myFile.getParent());
            String parentDir = parent.getParent();
            String cmd = "";
            String exe = "";
            String os = System.getProperty("os.name").toLowerCase();
            if (os.indexOf("win") >= 0) {
                cmd = "cd " + parentDir + File.separator + "config && ";
                cmd = String.valueOf(cmd) + " start /min ";
                File ovpnExe = new File(String.valueOf(parentDir) + File.separator + "bin" + File.separator, "openvpn");
                exe = ovpnExe.getAbsolutePath();
                cmd = String.valueOf(cmd) + " " + ovpnExe + " --config " + myFile.getName();
                FileWriter fos = new FileWriter(temp);
                this.logger.info(cmd);
                fos.write(cmd);
                fos.close();
                boolean bl = Program.launch((String)temp.getAbsolutePath());
            }
            boolean j = false;
            int maxWait = 20;
            long startMs = Calendar.getInstance().getTimeInMillis();
            while (true) {
                if (this.ping(ovpnIp)) {
                    System.out.println("Ping was okay to server: " + ovpnIp);
                    return true;
                }
                long actualMs = Calendar.getInstance().getTimeInMillis();
                if (actualMs - startMs >= (long)(timeout * 1000)) {
                    this.logger.error("Could not ping to server: " + ovpnIp);
                    return false;
                }
                System.out.println("Pinging");
            }
        }
        catch (Exception ex) {
            this.logger.error("Could not start program");
            ExHandler.handle((Throwable)ex);
            MessageEvent.fireError((String)"OpenVPN", (String)String.format("Could not start program %s", ex.getMessage()));
        }
        return true;
    }

    public void closeConnection() {
        this.logger.info("Close connection");
    }
}

