/*
 * Decompiled with CFR 0.152.
 */
package ch.ngiger.comm.ftp;

import ch.elexis.core.data.util.FileUtility;
import ch.elexis.core.events.MessageEvent;
import ch.ngiger.comm.ftp.FtpSemaException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpServer
extends FTPClient {
    private String fullSemaName;
    private String serverAddress;
    private static Logger logger = LoggerFactory.getLogger(FTPClient.class);

    private void setWorkingDirectory(String serverFile) throws IOException {
        String path = FileUtility.getFilepath((String)serverFile);
        if (path != null && path.length() > 0) {
            this.changeWorkingDirectory(path);
        }
    }

    public void downloadFile(String remoteFilenamePath, String localFilenamePath) throws IOException {
        this.setWorkingDirectory(remoteFilenamePath);
        String remoteFile = FileUtility.getFilename((String)remoteFilenamePath);
        try (FileOutputStream localFile = null;){
            localFile = new FileOutputStream(localFilenamePath);
            if (!this.retrieveFile(remoteFile, localFile)) {
                throw new IOException("File not received succesfully: " + this.getReplyString());
            }
        }
    }

    public boolean deleteFile(String name) throws IOException {
        return super.deleteFile(name);
    }

    public boolean uploadFile(String remoteFilenamePath, String localFilenamePath) throws IOException {
        this.setWorkingDirectory(remoteFilenamePath);
        String remoteFile = FileUtility.getFilename((String)remoteFilenamePath);
        try (FileInputStream localFile = null;){
            localFile = new FileInputStream(localFilenamePath);
            if (!this.storeFile(remoteFile, localFile)) {
                throw new IOException("File not sent succesfully: " + this.getReplyString());
            }
        }
        return true;
    }

    public void disconnect() throws IOException {
        if (this.isConnected()) {
            super.disconnect();
        }
    }

    public String[] listNames() throws IOException {
        String[] files = super.listNames();
        if (files == null) {
            return new String[0];
        }
        return files;
    }

    public FTPFile[] listFiles() throws IOException {
        FTPFile[] files = super.listFiles();
        if (files == null) {
            return new FTPFile[0];
        }
        return files;
    }

    public void openConnection(String host, String user, String pwd) throws IOException {
        if (!this.isConnected()) {
            this.connect(host);
            this.serverAddress = host;
            this.mode(2);
        }
        if (this.isConnected() && !this.login(user, pwd)) {
            throw new IOException(this.getReplyStrings()[0]);
        }
        this.enterLocalPassiveMode();
    }

    public void closeConnection() throws IOException {
        if (this.isConnected()) {
            super.disconnect();
        }
    }

    private void uploadSemaphore(String semaName) throws IOException {
        this.fullSemaName = String.valueOf(System.getProperty("user.home", "")) + System.getProperty("file.separator") + semaName;
        File file = new File(this.fullSemaName);
        file.createNewFile();
        this.uploadFile(file.getName(), file.getPath());
    }

    public void addSemaphore(String downloadDir, String ourFile, String theirFile) throws FtpSemaException {
        try {
            String[] filenameList;
            this.uploadSemaphore(ourFile);
            String[] stringArray = filenameList = this.listNames();
            int n = filenameList.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                if (filename.toLowerCase().equals(theirFile)) {
                    throw new FtpSemaException("FtpServer.semaphore.error");
                }
                ++n2;
            }
        }
        catch (IOException e) {
            throw new FtpSemaException(e);
        }
    }

    public void removeSemaphore() throws IOException {
        String name = new File(this.fullSemaName).getName();
        boolean res = super.deleteFile(name);
        if (res) {
            logger.info(String.format("Deleted semaphore %s on %s", name, this.serverAddress));
        } else {
            logger.error(String.format("Unable to delete semaphore %s on %s", name, this.serverAddress));
            MessageEvent.fireError((String)"FTP Semaphore delete error", (String)String.format("Unable to delete semaphore %s on %s", name, this.serverAddress));
        }
    }
}

