/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.elexis.directories.views;

import ch.elexis.core.ui.contacts.dialogs.PatientErfassenDialog;
import ch.elexis.core.ui.dialogs.KontaktErfassenDialog;
import ch.elexis.core.ui.util.SWTHelper;
import ch.medshare.elexis.directories.DirectoriesContentParser;
import ch.medshare.elexis.directories.DirectoriesHelper;
import ch.medshare.elexis.directories.KontaktEntry;
import ch.medshare.elexis.directories.views.Messages;
import ch.rgw.tools.ExHandler;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class WeisseSeitenSearchForm
extends Composite {
    private final ListenerList listeners = new ListenerList();
    private List<KontaktEntry> kontakte = new Vector<KontaktEntry>();
    private String searchInfoText = "";

    public WeisseSeitenSearchForm(Composite parent, int style) {
        super(parent, style);
        this.createPartControl(parent);
    }

    private void createPartControl(Composite parent) {
        this.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.setLayout((Layout)new GridLayout(3, false));
        Label nameLabel = new Label((Composite)this, 0);
        nameLabel.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        nameLabel.setText(Messages.WeisseSeitenSearchForm_label_werWasWo);
        Label geoLabel = new Label((Composite)this, 0);
        geoLabel.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        geoLabel.setText(Messages.WeisseSeitenSearchForm_label_Ort);
        new Label((Composite)this, 0);
        final Text nameText = new Text((Composite)this, 2048);
        nameText.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        final Text geoText = new Text((Composite)this, 2048);
        geoText.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Button searchBtn = new Button((Composite)this, 0);
        searchBtn.setText(Messages.WeisseSeitenSearchForm_btn_Suchen);
        nameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    WeisseSeitenSearchForm.this.searchAction(nameText.getText(), geoText.getText());
                }
            }
        });
        geoText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    WeisseSeitenSearchForm.this.searchAction(nameText.getText(), geoText.getText());
                }
            }
        });
        searchBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WeisseSeitenSearchForm.this.searchAction(nameText.getText(), geoText.getText());
            }
        });
    }

    private void readKontakte(String name, String geo) {
        Cursor backupCursor = this.getShell().getCursor();
        Cursor waitCursor = new Cursor((Device)this.getShell().getDisplay(), 1);
        this.getShell().setCursor(waitCursor);
        try {
            try {
                String content = DirectoriesHelper.readContent(name, geo);
                DirectoriesContentParser parser = new DirectoriesContentParser(content);
                this.kontakte = parser.extractKontakte();
                this.searchInfoText = parser.getSearchInfo();
            }
            catch (IOException e) {
                ExHandler.handle((Throwable)e);
                this.getShell().setCursor(backupCursor);
            }
        }
        finally {
            this.getShell().setCursor(backupCursor);
        }
    }

    private void searchAction(String name, String geo) {
        this.readKontakte(name, geo);
        this.resultChanged();
    }

    private void resultChanged() {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener != null) {
                ((Listener)listener).handleEvent(null);
            }
            ++n2;
        }
    }

    private String[] getFields(KontaktEntry entry) {
        String name = String.valueOf(entry.getName()) + " " + entry.getVorname();
        String geo = String.valueOf(entry.getPlz()) + " " + entry.getOrt();
        if (!entry.isDetail()) {
            this.readKontakte(name, geo);
            KontaktEntry detailEntry = null;
            if (this.getKontakte().size() == 1) {
                detailEntry = this.getKontakte().get(0);
            } else if (this.getKontakte().size() > 1) {
                String strasse = entry.getAdresse().trim();
                for (KontaktEntry tempEntry : this.getKontakte()) {
                    if (!strasse.contains(tempEntry.getAdresse())) continue;
                    detailEntry = tempEntry;
                }
            }
            if (detailEntry != null && detailEntry.countNotEmptyFields() > entry.countNotEmptyFields()) {
                entry = detailEntry;
            }
        }
        return new String[]{entry.getName(), entry.getVorname(), "", entry.getAdresse(), entry.getPlz(), entry.getOrt(), entry.getTelefon(), entry.getZusatz(), entry.getFax(), entry.getEmail()};
    }

    public void openPatientenDialog(KontaktEntry entry) {
        if (entry != null) {
            PatientErfassenDialog dialog = new PatientErfassenDialog(this.getShell(), entry.toHashmap());
            dialog.open();
        }
    }

    public void openKontaktDialog(KontaktEntry entry) {
        if (entry != null) {
            KontaktErfassenDialog dialog = new KontaktErfassenDialog(this.getShell(), this.getFields(entry));
            dialog.open();
        }
    }

    public List<KontaktEntry> getKontakte() {
        return this.kontakte;
    }

    public String getSearchInfoText() {
        return this.searchInfoText;
    }

    public void addResultChangeListener(Listener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeResultChangeListener(Listener listener) {
        this.listeners.add((Object)listener);
    }
}

