/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.elexis.directories;

import ch.elexis.core.ui.util.SWTHelper;
import ch.medshare.elexis.directories.HtmlParser;
import ch.medshare.elexis.directories.KontaktEntry;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoriesContentParser
extends HtmlParser {
    private static final String ADR_LISTENTRY_TAG = "<div class='row local-listing'";
    private static final String ADR_SINGLEDETAILENTRY_TAG = "<div class='eight columns details'";
    private static String metaPLZTrunc = "";
    private static String metaOrtTrunc = "";
    private static String metaStrasseTrunc = "";
    private final Logger logger = LoggerFactory.getLogger((String)"ch.medshare.elexis_directories");

    public DirectoriesContentParser(String htmlText) {
        super(htmlText);
    }

    private String reverseString(String text) {
        if (text == null) {
            return "";
        }
        String reversed = "";
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            reversed = String.valueOf(c) + reversed;
            ++n2;
        }
        return reversed;
    }

    private String[] getVornameNachname(String text) {
        String vorname = "";
        String nachname = text;
        int nameEndIndex = text.trim().indexOf(" ");
        if (nameEndIndex > 0) {
            vorname = text.trim().substring(nameEndIndex).trim();
            nachname = text.trim().substring(0, nameEndIndex).trim();
        }
        return new String[]{vorname, nachname};
    }

    private String removeDirt(String text) {
        text = text.replaceAll("^+\\s", "");
        text = text.replaceAll("\\s+$", "");
        return text.replace("<span class=\"highlight\">", "").replace("</span>", "");
    }

    public String getSearchInfo() {
        this.reset();
        this.logger.debug("DirectoriesContentParser.java: getSearchInfo() running...\n");
        this.logger.debug("Beginning of substrate: <" + this.extract("<", ">") + "...\n");
        String searchInfoText = this.extract("<title>", "</title>");
        if (searchInfoText == null) {
            return "";
        }
        this.logger.debug("DirectoriesContentParser.java: getSearchInfo(): searchInfoText != null\n");
        this.logger.debug("DirectoriesContentParser.java: getSearchInfo(): \"" + searchInfoText + "\"\n\n");
        return searchInfoText.replace("<strong class=\"what\">", "").replace("<strong class=\"where\">", "").replace("<strong>", "").replace("</strong>", "").trim();
    }

    public List<KontaktEntry> extractKontakte() throws IOException {
        this.reset();
        this.logger.debug("DirectoriesContentParser.java: extractKontakte() running...\n");
        this.logger.debug("Beginning of substrate: <" + this.extract("<", ">") + "...\n");
        if (this.getNextPos("<meta content='Adresse von ") > 0) {
            this.logger.debug("Processing a <meta> field to help processing the 'details' field later on which is very unstructured after 20131124...\n");
            this.moveTo("<meta content='Adresse von ");
            metaStrasseTrunc = this.removeDirt(this.extract("Strasse: ", ",")).replaceAll("[^A-Za-z0-9]", "");
            metaPLZTrunc = this.removeDirt(this.extract("PLZ: ", ",")).replaceAll("[^A-Za-z0-9]", "");
            metaOrtTrunc = this.removeDirt(this.extract("Ort: ", ",")).replaceAll("[^A-Za-z0-9]", "");
            if (metaStrasseTrunc == null) {
                this.logger.debug("WARNING: metaStrasseTrunc == null\n");
            } else {
                this.logger.debug("metaStrasseTrunc == " + metaStrasseTrunc + "\n");
            }
            if (metaPLZTrunc == null) {
                this.logger.debug("WARNING: metaPLZTrunc == null\n");
            } else {
                this.logger.debug("metaPLZTrunc == " + metaPLZTrunc + "\n");
            }
            if (metaOrtTrunc == null) {
                this.logger.debug("WARNING: metaOrtTrunc == null\n");
            } else {
                this.logger.debug("metaOrtTrunc == " + metaOrtTrunc + "\n");
            }
        }
        Vector<KontaktEntry> kontakte = new Vector<KontaktEntry>();
        int listIndex = this.getNextPos(ADR_LISTENTRY_TAG);
        int detailIndex = this.getNextPos(ADR_SINGLEDETAILENTRY_TAG);
        this.logger.debug("DirectoriesContentParser.java: extractKontakte() initial values of...\n");
        this.logger.debug("DirectoriesContentParser.java: extractKontakte().listIndex: " + listIndex + "\n");
        this.logger.debug("DirectoriesContentParser.java: extractKontakte().detailIndex: " + detailIndex + "\n");
        while (listIndex > 0 || detailIndex > 0) {
            KontaktEntry entry = null;
            this.logger.debug("DirectoriesContentParser.java: extractKontakte() intraloop values of...\n");
            this.logger.debug("DirectoriesContentParser.java: extractKontakte().listIndex: " + listIndex + "\n");
            this.logger.debug("DirectoriesContentParser.java: extractKontakte().detailIndex: " + detailIndex + "\n");
            if (detailIndex < 0 || listIndex >= 0 && listIndex < detailIndex) {
                this.logger.debug("DirectoriesContentParser.java: Parsing Liste:\n");
                entry = this.extractListKontakt();
            } else if (listIndex < 0 || detailIndex >= 0 && detailIndex < listIndex) {
                this.logger.debug("DirectoriesContentParser.java: Parsing Einzeladresse:\n");
                entry = this.extractKontakt();
            }
            if (entry != null) {
                this.logger.debug("DirectoriesContentParser.java: entry: " + entry.toString() + "\n");
            } else {
                this.logger.debug("DirectoriesContentParser.java: entry: NULL\n");
            }
            if (entry != null) {
                kontakte.add(entry);
            }
            listIndex = this.getNextPos(ADR_LISTENTRY_TAG);
            detailIndex = this.getNextPos(ADR_SINGLEDETAILENTRY_TAG);
        }
        return kontakte;
    }

    private KontaktEntry extractListKontakt() throws IOException, MalformedURLException {
        int CommaPos;
        this.logger.debug("DirectoriesContentParser.java: extractListKontakt() running...\n");
        this.logger.debug("Beginning of substrate: <" + this.extract("<", ">") + "...\n");
        if (!this.moveTo(ADR_LISTENTRY_TAG)) {
            return null;
        }
        this.logger.debug("DirectoriesContentParser.java: extractListKontakt() extracting next entry...\n");
        int nextEntryPoxIndex = this.getNextPos(ADR_LISTENTRY_TAG);
        this.logger.debug("DirectoriesContentParser.java: extractListKontakt() nextEntryPoxIndex: " + nextEntryPoxIndex + "\n");
        this.logger.debug("DirectoriesContentParser.java: Shouldn't the \\\" in the following line and similar ones throughout this file be changed to a simple ' ???\n");
        this.moveTo("<h2><a href=\"http://tel.local.ch/");
        String nameVornameText = this.extract("\">", "</a>");
        nameVornameText = this.removeDirt(nameVornameText);
        if (nameVornameText == null || nameVornameText.length() == 0) {
            return null;
        }
        String[] vornameNachname = this.getVornameNachname(nameVornameText);
        String vorname = vornameNachname[0];
        String nachname = vornameNachname[1];
        this.logger.debug("DirectoriesContentParser.java: extractListKontakt() nameVornameText: " + nameVornameText + "\n");
        this.logger.debug("DirectoriesContentParser.java: extractListKontakt() Possibly add better processing of a successor to role/categories/profession fields here as well, see comments above.\n");
        String zusatz = "";
        int catIndex = this.getNextPos("<span class='categories'>");
        if (catIndex > 0 && (catIndex < nextEntryPoxIndex || nextEntryPoxIndex == -1)) {
            this.moveTo("<span class='categories'>");
            zusatz = this.extractTo("</span>");
            zusatz = zusatz.replaceAll("&nbsp;&bull;&nbsp;", ", ");
        }
        this.logger.debug("DirectoriesContentParser.java: extractListKontakt() catIndex: " + catIndex + "\n");
        this.logger.debug("DirectoriesContentParser.java: extractListKontakt() zusatz: \"" + zusatz + "\"\n\n");
        String adressTxt = this.extract("<span class='address'>", "</span>");
        this.logger.debug("DirectoriesContentParser.java: extractListKontakt().addressTxt:\n" + adressTxt + "\n\n");
        String strasse = "";
        String plz = "";
        String ort = "";
        if (adressTxt.contains(", ")) {
            CommaPos = adressTxt.lastIndexOf(", ");
            if (CommaPos > -1) {
                strasse = this.removeDirt(adressTxt.substring(0, CommaPos));
                int SpacePos = adressTxt.indexOf(" ", CommaPos + 2);
                if (SpacePos > -1) {
                    plz = this.removeDirt(adressTxt.substring(CommaPos + 2, SpacePos));
                    ort = this.removeDirt(adressTxt.substring(SpacePos + 1));
                } else {
                    ort = this.removeDirt(adressTxt.substring(CommaPos + 2));
                }
            } else {
                ort = this.removeDirt(adressTxt);
            }
        }
        if (strasse != "" && (CommaPos = strasse.lastIndexOf(", ")) > -1) {
            zusatz = zusatz == "" ? this.removeDirt(strasse.substring(0, CommaPos)) : String.valueOf(this.removeDirt(strasse.substring(0, CommaPos))) + " - " + zusatz;
            strasse = this.removeDirt(strasse.substring(CommaPos + 2));
        }
        String telNr = "";
        int phonePos = this.getNextPos("<span class='phone'");
        if (phonePos >= 0 && (phonePos < nextEntryPoxIndex || nextEntryPoxIndex == -1)) {
            this.moveTo("<span class='phone'");
            this.moveTo("<label>Telefon");
            this.moveTo("number\"");
            telNr = this.extract(">", "</").replace("&nbsp;", "").replace("*", "").trim();
        }
        return new KontaktEntry(vorname, nachname, zusatz, strasse, plz, ort, telNr, "", "", false);
    }

    public static String decodeURIComponent(String s) {
        if (s == null) {
            return null;
        }
        String result = null;
        try {
            result = URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            result = s;
        }
        return result;
    }

    private KontaktEntry extractKontakt() {
        this.logger.debug("DirectoriesContentParser.java: extractKontakt() running...\n");
        this.logger.debug("Beginning of substrate: <" + this.extract("<", ">") + "...\n");
        if (!this.moveTo(ADR_SINGLEDETAILENTRY_TAG)) {
            return null;
        }
        this.logger.debug("DirectoriesContentParser.java: extractKontakt() extracting next entry...\n");
        this.logger.debug("DirectoriesContentParser.java: extractKontakt() Add processing of the class='title', class='urls', and optionally class='region'. \n");
        String vorname = "";
        String nachname = "";
        String streetAddress = "";
        String poBox = "";
        String plzCode = "";
        String ort = "";
        String zusatz = "";
        String tel = "";
        String fax = "";
        String email = "";
        Boolean doItOnceMore = true;
        while (doItOnceMore.booleanValue()) {
            this.moveTo("<h4 class='name fn'");
            String nameVornameText = this.extract(">", "</h4>");
            this.logger.debug("DirectoriesContentParser.java: extractKontakt().nameVornameText: \"" + nameVornameText + "\"\n");
            if (nameVornameText == null || nameVornameText.length() == 0) {
                return null;
            }
            String[] vornameNachname = this.getVornameNachname(nameVornameText);
            if (vorname.equals("")) {
                vorname = vornameNachname[0];
                nachname = vornameNachname[1];
            } else {
                nachname = String.valueOf(nachname) + " " + vorname;
                vorname = String.valueOf(vornameNachname[1]) + " " + vornameNachname[0];
            }
            this.logger.debug("DirectoriesContentParser.java: extractKontakt() nameVornameText: " + nameVornameText + "\n");
            if (this.moveTo("<div class='profession'>")) {
                zusatz = this.extractTo("</div>");
            }
            if (zusatz != null) {
                zusatz = zusatz.replace("Dr. med. PD", "PD Dr. med.");
                zusatz = zusatz.replace("Dr. med. Prof.", "Prof. Dr. med.");
            }
            this.logger.debug("DirectoriesContentParser.java: extractKontakt() zusatz: \"" + zusatz + "\"\n\n");
            String adressTxt = this.extract("<p class='address'>", "</p>").trim();
            this.logger.debug("DirectoriesContentParser.java: adressTxt: " + adressTxt + "\n");
            String[] addressLines = adressTxt.split("<br/>");
            this.logger.debug("Trying to use Meta-Info collected above to parse the address content...\n");
            if (metaStrasseTrunc == null) {
                this.logger.debug("WARNING: metaStrasseTrunc == null\n");
            } else {
                this.logger.debug("metaStrasseTrunc == " + metaStrasseTrunc + "\n");
            }
            if (metaPLZTrunc == null) {
                this.logger.debug("WARNING: metaPLZTrunc == null\n");
            } else {
                this.logger.debug("metaPLZTrunc == " + metaPLZTrunc + "\n");
            }
            if (metaOrtTrunc == null) {
                this.logger.debug("WARNING: metaOrtTrunc == null\n");
            } else {
                this.logger.debug("metaOrtTrunc == " + metaOrtTrunc + "\n");
            }
            String[] stringArray = addressLines;
            int n = addressLines.length;
            int n2 = 0;
            while (n2 < n) {
                String thisLine = stringArray[n2];
                if (thisLine != null) {
                    thisLine = thisLine.trim();
                }
                if (thisLine == null) {
                    this.logger.debug("WARNING: thisLine == null\n");
                } else {
                    this.logger.debug("thisLine == " + thisLine + "\n");
                    if (thisLine.startsWith(metaStrasseTrunc)) {
                        streetAddress = this.removeDirt(thisLine);
                    }
                    if (thisLine.startsWith(metaPLZTrunc)) {
                        int i = thisLine.indexOf(" ");
                        plzCode = this.removeDirt(thisLine.substring(0, i));
                        ort = this.removeDirt(thisLine.substring(i + 1));
                    }
                }
                ++n2;
            }
            String poBoxA = "";
            String poBoxB = "";
            String[] stringArray2 = addressLines;
            int n3 = addressLines.length;
            int n4 = 0;
            while (n4 < n3) {
                String thisLine = stringArray2[n4];
                if (thisLine != null) {
                    thisLine = thisLine.trim();
                }
                if (thisLine == null) {
                    this.logger.debug("WARNING: thisLine == null\n");
                } else {
                    this.logger.debug("thisLine == " + thisLine + "\n");
                    if (thisLine.startsWith("Postfach")) {
                        poBoxA = this.removeDirt(thisLine);
                    }
                }
                ++n4;
            }
            if (poBoxA != "") {
                stringArray2 = addressLines;
                n3 = addressLines.length;
                n4 = 0;
                while (n4 < n3) {
                    String thisLine = stringArray2[n4];
                    if (thisLine != null) {
                        thisLine = thisLine.trim();
                    }
                    if (thisLine == null) {
                        this.logger.debug("WARNING: thisLine == null\n");
                    } else {
                        this.logger.debug("thisLine == " + thisLine + "\n");
                        if (thisLine.contains(metaOrtTrunc) && !thisLine.startsWith(metaPLZTrunc)) {
                            poBoxB = thisLine;
                        }
                    }
                    ++n4;
                }
            }
            poBox = poBoxB.equals("") ? poBoxA : String.valueOf(poBoxA) + ", " + poBoxB;
            if (streetAddress == null) {
                this.logger.debug("WARNING: streetAddress == null\n");
            } else {
                this.logger.debug("streetAddress == " + streetAddress + "\n");
            }
            if (poBox == null) {
                this.logger.debug("WARNING: poBox == null\n");
            } else {
                this.logger.debug("poBox == " + poBox + "\n");
            }
            if (plzCode == null) {
                this.logger.debug("WARNING: plzCode == null\n");
            } else {
                this.logger.debug("plzCode == " + plzCode + "\n");
            }
            if (ort == null) {
                this.logger.debug("WARNING: ort == null\n");
            } else {
                this.logger.debug("ort == " + ort + "\n");
            }
            if (zusatz == null || zusatz.length() == 0) {
                zusatz = poBox;
            }
            if (this.moveTo("<tr class='phone'>") && this.moveTo("<span>\nTelefon:") && this.moveTo("href=\"tel:")) {
                this.moveTo("number\"");
                tel = this.extract(">", "</").replace("&nbsp;", "").replace("*", "").trim();
            }
            if (this.moveTo("<tr class='fax'>") && this.moveTo("<span>\nFax:")) {
                this.moveTo("number'");
                fax = this.extract(">", "</").replace("&nbsp;", "").replace("*", "").trim();
            }
            this.logger.debug("jsdebug: Trying to parse e-mail...\n");
            if (this.moveTo("<div class='email'")) {
                email = email.equals("") ? this.extract("href=\"mailto:", "\">").trim() : String.valueOf(email) + "; " + this.extract("href=\"mailto:", "\">").trim();
            }
            if (!(doItOnceMore = Boolean.valueOf(this.getNextPos("<h4 class='name fn'") > 0)).booleanValue()) continue;
            SWTHelper.showInfo((String)"Warnung", (String)"Dieser eine Eintrag liefert gleich mehrere Adressen.\n\nBitte f\u00fchren Sie selbst eine Suche im WWW auf tel.local.ch durch,\num alle Angaben zu sehen.\n\nIch versuche, f\u00fcr die Namen die Informationen sinnvoll zusammenzuf\u00fcgen;\nf\u00fcr die Adressdaten bleibt von mehreren Eintr\u00e4gen der letzte bestehen.\n\nFalls Sie eine Verbesserung ben\u00f6tigen, fragen Sie bitte\njoerg.sigle@jsigle.com - Danke!");
        }
        return new KontaktEntry(vorname, nachname, zusatz, streetAddress, plzCode, ort, tel, fax, email, true);
    }
}

