/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.xml.documents;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.itmed.fop.printing.preferences.PreferenceConstants;
import ch.itmed.fop.printing.preferences.Setting;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class PageProperties {
    public static Element setProperties(Document doc, String docName) {
        boolean globalSetting = Setting.isGlobalSetting(docName);
        Element page = doc.createElement("Page");
        PageProperties.initDefaults(docName, globalSetting);
        page.setAttribute("pageHeight", String.valueOf(Setting.getString(docName, PreferenceConstants.getDocPreferenceConstant(docName, 5))) + "mm");
        page.setAttribute("pageWidth", String.valueOf(Setting.getString(docName, PreferenceConstants.getDocPreferenceConstant(docName, 6))) + "mm");
        page.setAttribute("textOrientation", Setting.getString(docName, PreferenceConstants.getDocPreferenceConstant(docName, 7)));
        page.setAttribute("marginTop", String.valueOf(Setting.getString(docName, PreferenceConstants.getDocPreferenceConstant(docName, 8))) + "mm");
        page.setAttribute("marginBottom", String.valueOf(Setting.getString(docName, PreferenceConstants.getDocPreferenceConstant(docName, 9))) + "mm");
        page.setAttribute("marginLeft", String.valueOf(Setting.getString(docName, PreferenceConstants.getDocPreferenceConstant(docName, 10))) + "mm");
        page.setAttribute("marginRight", String.valueOf(Setting.getString(docName, PreferenceConstants.getDocPreferenceConstant(docName, 11))) + "mm");
        return page;
    }

    private static void initDefaults(String docName, boolean globalSetting) {
        if (globalSetting) {
            ConfigServiceHolder.get().set(String.valueOf(PreferenceConstants.getDocPreferenceConstant(docName, 5)) + "_default", "89");
            ConfigServiceHolder.get().set(String.valueOf(PreferenceConstants.getDocPreferenceConstant(docName, 6)) + "_default", "57");
            ConfigServiceHolder.get().set(String.valueOf(PreferenceConstants.getDocPreferenceConstant(docName, 7)) + "_default", "0");
            ConfigServiceHolder.get().set(String.valueOf(PreferenceConstants.getDocPreferenceConstant(docName, 8)) + "_default", "6");
            ConfigServiceHolder.get().set(String.valueOf(PreferenceConstants.getDocPreferenceConstant(docName, 9)) + "_default", "6");
            ConfigServiceHolder.get().set(String.valueOf(PreferenceConstants.getDocPreferenceConstant(docName, 10)) + "_default", "6");
            ConfigServiceHolder.get().set(String.valueOf(PreferenceConstants.getDocPreferenceConstant(docName, 11)) + "_default", "6");
        } else {
            ConfigServiceHolder.get().setLocal(String.valueOf(PreferenceConstants.getDocPreferenceConstant(docName, 5)) + "_default", "89");
            ConfigServiceHolder.get().setLocal(String.valueOf(PreferenceConstants.getDocPreferenceConstant(docName, 6)) + "_default", "57");
            ConfigServiceHolder.get().setLocal(String.valueOf(PreferenceConstants.getDocPreferenceConstant(docName, 7)) + "_default", "0");
            ConfigServiceHolder.get().setLocal(String.valueOf(PreferenceConstants.getDocPreferenceConstant(docName, 8)) + "_default", "6");
            ConfigServiceHolder.get().setLocal(String.valueOf(PreferenceConstants.getDocPreferenceConstant(docName, 9)) + "_default", "6");
            ConfigServiceHolder.get().setLocal(String.valueOf(PreferenceConstants.getDocPreferenceConstant(docName, 10)) + "_default", "6");
            ConfigServiceHolder.get().setLocal(String.valueOf(PreferenceConstants.getDocPreferenceConstant(docName, 11)) + "_default", "6");
        }
    }

    public static void setCurrentDate(Element page) {
        LocalDate localDate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.YYYY").withZone(ZoneId.systemDefault());
        String currentDate = formatter.format(localDate);
        page.setAttribute("currentDate", currentDate);
    }
}

